<html>
<head>
<title>The Particle Data Scheme</title>
<link rel="stylesheet" type="text/css" href="pythia.css"/>
<link rel="shortcut icon" href="pythia32.gif"/>
</head>
<body>

<script language=javascript type=text/javascript>
function stopRKey(evt) {
var evt = (evt) ? evt : ((event) ? event : null);
var node = (evt.target) ? evt.target :((evt.srcElement) ? evt.srcElement : null);
if ((evt.keyCode == 13) && (node.type=="text"))
{return false;}
}

document.onkeypress = stopRKey;
</script>
<?php
if($_POST['saved'] == 1) {
if($_POST['filepath'] != "files/") {
echo "<font color='red'>SETTINGS SAVED TO FILE</font><br/><br/>"; }
else {
echo "<font color='red'>NO FILE SELECTED YET.. PLEASE DO SO </font><a href='SaveSettings.php'>HERE</a><br/><br/>"; }
}
?>

<form method='post' action='ParticleDataScheme.php'>
 
<h2>The Particle Data Scheme</h2> 
 
The particle data scheme may take somewhat longer to understand than 
the settings one. In particular the set of methods to access information 
is rather more varied, to allow better functionality for advanced usage. 
However, PYTHIA does come with a sensible default set of particle 
properties and decay tables. Thus there is no need to learn any of the 
methods on this page to get going. Only when you perceive a specific need 
does it make sense to learn the basics. 
 
<p/> 
The central section on this page is the Operation one. The preceding 
sections are there mainly to introduce the basic structure and the set 
of properties that can be accessed. The subsequent sections provide a 
complete listing of the existing public methods, which most users 
probably will have little interaction with. 
 
<h3>Databases</h3> 
 
The management of particle data is based on three classes: 
<ul> 
<li><code>ParticleData</code>, which is the top-level class, with 
methods that can be used to interrogate all particle data. It contains 
a map of PDG particle identity numbers [<a href="Bibliography.php" target="page">Yao06</a>] onto the relevant 
<code>ParticleDataEntry</code> objects,</li> 
<li><code>ParticleDataEntry</code>, which stores the relevant information 
on an individual particle species, and</li> 
<li><code>DecayChannel</code>, which stores info on one particular decay 
mode of a particle.</li> 
 
</ul> 
The objects of these classes together form a database that is 
continuously being used as the program has to assign particle masses, 
select decay modes, etc. 
 
<p/> 
Each <code>Pythia</code> object has a public member 
<code>particleData</code> of the <code>ParticleData</code> class. 
Therefore you access the particle data methods as 
<code>pythia.particleData.command(argument)</code>, 
assuming that <code>pythia</code> is an instance of the 
<code>Pythia</code> class. Further, for some of the most frequent user 
tasks, <code>Pythia</code> methods have been defined, so that 
<code>pythia.command(argument)</code> 
would work, see further below. 
 
<p/> 
A fundamental difference between the particle data classes and the 
settings ones is that the former are accessed regularly during the 
event generation process, as a new particle is produced and its mass 
need to be set, e.g., while the latter are mainly/only used 
at the initialization stage. Nevertheless, it is not a good idea to 
change data in either of them in mid-run, since this may lead to 
inconsistencies. 
 
<h3>Stored properties for particles</h3> 
 
The main properties stored for each particle are as follows. 
Different ways to set and get these properties will be described 
further down. 
 
<ul> 
 
<li><code>name</code>: a character string with the name of the 
particle. Particle and antiparticle names are stored separately, 
with <code>void</code> returned when no antiparticle exists.</li> 
 
<li><code>spinType</code>: the spin type, of the form <i>2 s + 1</i>, 
with special code 0 for entries of unknown or indeterminate spin.</li> 
 
<li><code>chargeType</code>: three times the charge (to make it an 
integer).</li> 
 
<li><code>colType</code>: the colour type, with 0 uncoloured, 1 triplet, 
-1 antitriplet and 2 octet. (A preliminary implementation of colour 
  sextets, available since version 8.150, further uses 3 for a sextet 
  and -3 for an antisextet.) </li> 
 
<li><code>m0</code>: the nominal mass <i>m_0</i> (in GeV).</li> 
 
<li><code>mWidth</code>: the width <i>Gamma</i> of the Breit-Wigner 
distribution (in GeV).</li> 
 
<li><code>mMin</code>: the lower limit of the allowed mass range 
generated by the Breit-Wigner (in GeV). Has no meaning for particles 
without width, and would typically be 0 there.</li> 
 
<li><code>mMax</code>: the upper limit of the allowed mass range 
generated by the Breit-Wigner (in GeV). If <i>mMax &lt; mMin</i> then 
no upper limit is imposed. Has no meaning for particles without width, 
and would typically be 0 there.</li> 
 
<li><code>tau0</code>: the nominal proper lifetime <i>tau_0</i> 
(in mm/c).</li> 
 
<li><code>isResonance</code>: a flag telling whether a particle species 
is considered as a resonance or not. Here 
<?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>"resonance"</a> is used as shorthand 
for any massive particle where the decay process should be counted as part 
of the hard process itself, and thus be performed before showers and other 
event aspects are added. Restrictions on allowed decay channels is also 
directly reflected in the cross section of simulated processes, while 
those of normal hadrons and other light particles are not. 
In practice, it is reserved for states above the <i>b bbar</i> 
bound systems in mass, i.e. for <i>W, Z, t</i>, Higgs states, 
supersymmetric states and (most?) other states in any new theory. 
All particles with <code>m0</code> above 20 GeV are by default 
initialized to be considered as resonances.</li> 
 
<li><code>mayDecay</code>: a flag telling whether a particle species 
may decay or not, offering the main user switch. Whether a given particle 
of this kind then actually will decay also depends on it having allowed 
decay channels, and on other flags for 
<?php $filepath = $_GET["filepath"];
echo "<a href='ParticleDecays.php?filepath=".$filepath."' target='page'>";?>particle decays</a> 
(or <?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>resonance decays</a>). 
All particles with <code>tau0</code> below 1000 mm are 
by default initialized to allow decays.</li> 
 
<li><code>doExternalDecays</code>: a flag telling whether a particle 
should be handled by an external decay package or not, with the latter 
default. Can be manipulated as described on this page, but should 
normally not be. Instead the 
<code><?php $filepath = $_GET["filepath"];
echo "<a href='ExternalDecays.php?filepath=".$filepath."' target='page'>";?>Pythia::decayPtr(...)</a></code> 
method should be provided with the list of relevant particles.</li> 
 
<li><code>isVisible</code>: a flag telling whether a particle species 
is to be considered as visible in a detector or not, as used e.g. in 
analysis routines. By default the invisibles include neutrinos, 
Dark Matter particles (codes 51 - 60) and a few BSM particles (gravitino, 
sneutrinos, neutralinos) that have neither strong nor electromagnetic 
charge, and are not made up of constituents that have it. The value of 
this flag is only relevant if a particle is long-lived enough actually 
to make it to a detector.</li> 
 
<li><code>doForceWidth</code>: a flag applicable only for resonances 
(see <code>isResonance</code> above), whereby it is possible to force 
resonances to retain their assigned width, whatever that is, see 
<?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>Resonance Decays</a> for details.</li> 
 
</ul> 
 
<h3>Stored properties for decays</h3> 
 
An unstable particle has a decay table consisting of one or more 
decay channel. The following properties are stored for each such channel. 
Again different ways to set and get these properties will be described 
further down. 
<ul> 
 
<li><code>onMode</code>: integer code for use or not of channel,<br/> 
0 if a channel is off,<br/> 
1 if on,<br/> 
2 if on for a particle but off for an antiparticle,<br/> 
3 if on for an antiparticle but off for a particle.<br/> 
If a particle is its own antiparticle then 2 is on and 3 off 
but, of course, for such particles it is much simpler and safer 
to use only 1 and 0.<br/> 
The 2 and 3 options can be used e.g. to encode CP violation in 
B decays, or to let the <i>W</i>'s in a <i>q qbar &rarr; W^+ W^-</i> 
process decay in different channels. </li> 
 
<li><code>bRatio</code>: the branching ratio of the channel 
(with some reservations for resonances, see <code>meMode</code> 
below).</li> 
 
<li><code>meMode</code>: the mode of processing this channel, possibly 
with matrix elements; see the 
<?php $filepath = $_GET["filepath"];
echo "<a href='ParticleDecays.php?filepath=".$filepath."' target='page'>";?>particle decays</a> and 
<?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>resonance decays</a> 
descriptions for the list of possibilities. 
Notably the default code 0 for a particle means pure phase space 
decays according to the given branching ratios, while for a resonance 
it means that code exists for the dynamic calculations of partial 
widths and thereby branching ratios as a function of the resonance mass 
(which is done e.g. at initialization based on the mass set by the user). 
Then codes 1 - 99 are reserved for various matrix-element-improved 
ordinary particle decays, and 100 - 103 for resonances where the 
partial width of a given channel is calculated from the total width 
and the stored branching ratio. Thus, to enforce a new branching ratio 
for a resonance channel (with its own partial-width calculation code) 
it is not sufficient only to change the <code>bRatio</code> but also 
to set e.g. <code>meMode = 100</code>. </li> 
 
<li><code>multiplicity</code>: the number of decay products of the 
channel. Can be at most 8.</li> 
 
<li><code>product(i)</code>: the identity code of the decay products, 
where <code>i</code> runs between <code>0</code> and 
<code>multiplicity - 1</code>. Trailing positions are filled with 0. 
</li> 
 
</ul> 
 
<h3>Operation</h3> 
 
The normal flow of the particle data operations is: 
 
<ol> 
 
<li> 
When a <code>Pythia</code> object <code>pythia</code> is created, the 
<code>pythia.particleData</code> member is asked to scan the 
<code>ParticleData.xml</code> file. 
 
<p/> 
All lines beginning with <code>&lt;particle</code> are scanned for 
information on a particle species, and all lines beginning with 
<code>&lt;channel</code> are assumed to contain a decay channel of the 
enclosing particle. In both cases XML syntax is used, with attributes 
used to identify the stored properties, and with omitted properties 
defaulting back to 0 where meaningful. The particle and channel 
information may be split over several lines, up to the &gt; endtoken. 
The format of a <code>&lt;particle</code> tag is: 
<pre> 
    &lt;particle id="..." name="..." antiName="..." spinType="..." chargeType="..." colType="..." 
       m0="..." mWidth="..." mMin="..." mMax="..." tau0="..."&gt; 
    &lt;/particle&gt; 
</pre> 
where the fields are the properties already introduced above. 
Note that <code>isResonance</code>, <code>mayDecay</code>, 
<code>doExternalDecay</code>, <code>isVisible</code> and 
<code>doForceWidth</code> are not set here, but are provided with 
default values by the rules described above. Once initialized, also 
these latter properties can be changed, see below.<br/> 
 
The format of  a <code>&lt;channel></code> tag is: 
<pre> 
    &lt;channel onMode="..." bRatio="..." meMode="..." products="..." /&gt; 
</pre> 
again see properties above. The products are given as a blank-separated 
list of <code>id</code> codes. 
<br/><b>Important</b>: the values in the <code>.xml</code> file should not 
be changed, except by the PYTHIA authors. Any changes should be done 
with the help of the methods described below. 
</li> 
 
<li> <p/> 
Between the creation of the <code>Pythia</code> object and the 
<code>init</code> call for it, you may use the methods of the 
<code>ParticleData</code> class to modify some of the default values. 
Several different approaches can be chosen for this. 
 
<p/> 
a) Inside your main program you can directly set values with 
<pre> 
    pythia.readString(string); 
</pre> 
where both the variable name and the value are contained inside 
the character string, separated by blanks and/or a =, e.g. 
<pre> 
    pythia.readString("111:mayDecay = off"); 
</pre> 
switches off the decays of the <i>pi^0</i>.<br/> 
 
The particle id (> 0) and the property to be changed must be given, 
separated by a colon.<br/> 
 
The allowed properties are: <code>name</code>, <code>antiName</code>, 
<code>spinType</code>, <code>chargeType</code>, <code>colType</code>, 
<code>m0</code>, <code>mWidth</code>, <code>mMin</code>, 
<code>mMax</code>, <code>tau0</code>, <code>isResonance</code>, 
<code>mayDecay</code>, <code>doExternalDecay</code>, 
<code>isVisible</code> and <code>doForceWidth</code>. All of these 
names are case-insensitive. Names that do not match an existing 
variable are ignored.<br/> 
 
Strings beginning with a non-alphanumeric character, like # or !, 
are assumed to be comments and are not processed at all. For 
<code>bool</code> values, the following notation may be used 
interchangeably: <code>true = on = yes = ok = 1</code>, while everything 
else gives <code>false</code> (including but not limited to 
<code>false</code>, <code>off</code>, <code>no</code> and 
<code>0</code>). 
 
<p/> 
Particle data often comes in sets of closely related information. 
Therefore some properties expect the value to consist of several 
numbers. These can then be separated by blanks (or by commas). 
A simple example is <code>names</code>, which expects both the 
name and antiname to be given. A more interesting one is the 
<code>all</code> property, 
<pre> 
    id:all = name antiName spinType chargeType colType m0 mWidth mMin mMax tau0 
</pre> 
where all the current information on the particle itself is replaced, 
but any decay channels are kept unchanged. Using <code>new</code> instead 
of <code>all</code> also removes any previous decay channels. 
If the string contains fewer fields than expected the trailing 
properties are set to vanish ("void", 0 or 0.). Note that such a 
truncated string should not be followed by a comment, since this 
comment would then be read in as if it contained the missing properties. 
The truncation can be done anywhere, specifically a string with only 
<code>id:new</code> defines a new "empty" particle. 
As before, <code>isResonance</code>, <code>mayDecay</code>, 
<code>doExternalDecay</code>, <code>isVisible</code> and 
<code>doForceWidth</code> are (re)set to their default values, and 
would have to be changed separately if required. 
 
<p/> 
A further command is <code>rescaleBR</code>, which rescales each of the 
existing branching ratios with a common factor, such that their new 
sum is the provided value. This may be a first step towards adding 
new decay channels, see further below. 
 
<p/> 
Alternatively the <code>id</code> code may be followed by another integer, 
which then gives the decay channel number. This then has to be 
followed by the property specific to this channel, either 
<code>onMode</code>, <code>bRatio</code>, <code>meMode</code> or 
<code>products</code>. In the latter case all the products of 
the channel should be given: 
<pre> 
    id:channel:products =  product1 product2 .... 
</pre> 
The line will be scanned until the end of the line, or until a 
non-number word is encountered, or until the maximum allowed number 
of eight products is encountered, whichever happens first. (Thus the 
multiplicity of a decay channel need not be input; it is automatically 
calculated from the products list.) It is also possible to replace all 
the properties of a channel in a similar way: 
<pre> 
    id:channel:all = onMode bRatio meMode product1 product2 .... 
</pre> 
To add a new channel at the end, use 
<pre> 
    id:addChannel = onMode bRatio meMode product1 product2 .... 
</pre> 
 
<p/> 
It is currently not possible to remove a channel selectively, but 
setting its branching ratio vanishing is as effective. If you want to 
remove all existing channels and force decays into one new channel 
you can use 
<pre> 
    id:oneChannel = onMode bRatio meMode product1 product2 .... 
</pre> 
 A first <code>oneChannel</code> command could be followed by 
several subsequent <code>addChannel</code> ones, to build 
up a completely new decay table for an existing particle. 
 
<p/> 
When adding new channels or changing branching ratios in general, 
note that, once a particle is to be decayed, the sum of branching 
ratios is always rescaled to unity. Beforehand, <code>rescaleBR</code> 
may be used to rescale an existing branching ratio by the given factor. 
 
<p/> 
There are a few commands that will study all the decay channels of the 
given particle, to switch them on or off as desired. The 
<pre> 
    id:onMode = onMode 
</pre> 
will set the <code>onMode</code> property of all channels to the 
desired value. The 
<pre> 
    id:offIfAny   = product1 product2 .... 
    id:onIfAny    = product1 product2 .... 
    id:onPosIfAny = product1 product2 .... 
    id:onNegIfAny = product1 product2 .... 
</pre> 
will set the <code>onMode</code> 0, 1, 2 or 3, respectively, for all 
channels which contain any of the enumerated products, where the matching 
to these products is done without distinction of particles and 
antiparticles. Note that "<code>Pos</code>" and "<code>Neg</code>" 
are slightly misleading since it refers to the particle and antiparticle 
of the <code>id</code> species rather than charge, but should still be 
simpler to remember and understand than alternative notations. 
Correspondingly 
<pre> 
    id:offIfAll   = product1 product2 .... 
    id:onIfAll    = product1 product2 .... 
    id:onPosIfAll = product1 product2 .... 
    id:onNegIfAll = product1 product2 .... 
</pre> 
will set the <code>onMode</code> 0, 1, 2 or 3, respectively, for all 
channels which contain all of the enumerated products, again without 
distinction of particles and antiparticles. If the same product appears 
twice in the list it must also appear twice in the decay channel, and 
so on. The decay channel is allowed to contain further particles, 
beyond the product list. By contrast, 
<pre> 
    id:offIfMatch   = product1 product2 .... 
    id:onIfMatch    = product1 product2 .... 
    id:onPosIfMatch = product1 product2 .... 
    id:onPosIfMatch = product1 product2 .... 
</pre> 
requires the decay-channel multiplicity to agree with that of the product 
list, but otherwise works as the <code>onIfAll/offIfAll</code> methods. 
 
<p/> 
Note that the action of several of the commands depends on the order 
in which they are executed, as one would logically expect. For instance, 
<code>id:oneChannel</code> removes all decay channels of <code>id</code> 
and thus all previous changes in this decay table, while subsequent 
additions or changes would still take effect. Another example would be that 
<code>23:onMode = off</code> followed by <code>23:onIfAny = 1 2 3 4 5</code> 
would let the <i>Z^0</i> decay to quarks, while no decays would be 
allowed if the order were to be reversed. 
 
<p/> 
b) The <code>Pythia</code> <code>readString(string)</code> method actually 
does not do changes itself, but sends on the string either to the 
<code>ParticleData</code> class or to the <code>Settings</code> one, 
depending on whether the string begins with a digit or a letter. 
If desired, it is possible to communicate directly with the corresponding 
<code>ParticleData</code> method: 
<pre> 
    pythia.particleData.readString("111:mayDecay = off"); 
    pythia.particleData.readString("15:2:products = 16 -211"); 
</pre> 
In this case, changes intended for <code>Settings</code> would not be 
understood. 
 
<p/> 
c) Underlying this are commands for all the individual properties in 
the <code>ParticleData</code> class, one for each. These are 
further described below. Thus, an example now reads 
<pre> 
    pythia.particleData.mayDecay(111, false); 
</pre> 
Boolean values should here be given as <code>true</code> or 
<code>false</code>. 
 
<p/> 
d) A simpler and more useful way is to collect all your changes 
in a separate file, with one line per change, e.g. 
<pre> 
    111:mayDecay = off 
</pre> 
The file can be read by the 
<pre> 
    pythia.readFile(fileName); 
</pre> 
method, where <code>fileName</code> is a string, e.g. 
<code>pythia.readFile("main.cmnd")</code> (or an <code>istream</code> 
instead of a <code>fileName</code>). Each line is processed as 
described for the string in 2a). This file can freely mix commands to 
the <code>Settings</code> and <code>ParticleData</code> classes. 
</li> 
 
<li> <p/> 
A routine <code>reInit(fileName)</code> is provided, and can be used to 
zero the particle data table and reinitialize it from scratch. 
Such a call might be useful if several subruns are to be made with 
widely different particle data - normally the maps are only built 
from scratch once, namely when the <code>Pythia()</code> object is 
created. Also, there is no other possibility to restore the default 
values, unlike for the settings. 
</li> 
 
<li> <p/> 
You may at any time obtain a listing of all the particle data by calling 
<pre> 
    pythia.particleData.listAll(); 
</pre> 
The listing is by increasing <code>id</code> number. It shows the basic 
quantities introduced above. Some are abbreviated in the header to fit on 
the lines: <code>spn = spinType</code>, <code>chg = chargeType</code>, 
<code>col = colType</code>, <code>res = isResonance</code>, 
<code>dec = mayDecay && canDecay</code> (the latter checks that decay 
channels have been defined), <code>ext = doExternalDecay</code>, 
<code>vis = isVisible</code> and <code>wid = doForceWidth</code>.<br/> 
 
To list only those particles that were changed (one way or another, the 
listing will not tell what property or decay channel was changed), instead use 
<pre> 
    pythia.particleData.listChanged(); 
</pre> 
(This info is based on a further <code>hasChanged</code> flag of a particle 
or a channel, set <code>true</code> whenever any of the changing methods are 
used. It is possible to manipulate this value, but this is not recommended.) 
By default the internal initialization of the widths of resonances such as 
<i>gamma^*/Z^0, W^+-, t/tbar, H^0</i> do not count as changes; if you want 
to list also those changes instead call <code>listChanged(true)</code>. 
<br/> 
 
To list only one particle, give its <code>id</code> code as argument to 
the <code>list(...)</code> function.. To list a restricted set of particles, 
give in their <code>id</code> codes to <code>list(...)</code> as a 
<code>vector&lt;int></code>. 
</li> 
 
<li> <p/> 
For wholesale changes of particle properties all available data can be 
written out, edited, and then read back in again. These methods are 
mainly intended for expert users. You can choose between two alternative 
syntaxes. 
 
<p/> 
a) XML syntax, using the <code>&lt;particle</code> and 
<code>&lt;channel</code> lines already described. You use the method 
<code>particleData.listXML(fileName)</code> to produce such an XML 
file and <code>particleData.readXML(fileName)</code> to read it back 
in after editing. 
 
<p/> 
b) Fixed/free format, using exactly the same information as illustrated 
for the <code>&lt;particle</code> and <code>&lt;channel</code> lines 
above, but now without any tags. This means that all information fields 
must be provided (if there is no antiparticle then write 
<code>void</code>), in the correct order (while the order is irrelevant 
with XML syntax), and all on one line. Information is written out in 
properly lined-up columns, but the reading is done using free format, 
so fields need only be separated by at least one blank. Each new particle 
is supposed to be separated by (at least) one blank line, whereas no 
blank lines are allowed between the particle line and the subsequent 
decay channel lines, if any.  You use the method 
<code>particleData.listFF(fileName)</code> to produce such a fixed/free 
file and <code>particleData.readFF(fileName)</code> to read it back 
in after editing. 
 
<p/> 
As an alternative to the <code>readXML</code> and <code>readFF</code> 
methods you can also use the 
<code>particleData.reInit(fileName, xmlFormat)</code> method, where 
<code>xmlFormat = true</code> (default) corresponds to reading an XML 
file and <code>xmlFormat = false</code> to a fixed/free format one. 
 
<p/> 
To check that the new particle and decay tables makes sense, you can use 
the <code>particleData.checkTable()</code> method, either directly or by 
switching it on among the standard 
<?php $filepath = $_GET["filepath"];
echo "<a href='ErrorChecks.php?filepath=".$filepath."' target='page'>";?>error checks</a>. 
</li> 
 
</ol> 
 
<h2>The public methods</h2> 
 
In the following we present briefly the public methods in the three 
classes used to build up the particle database. The order 
is top-down, i.e from the full table of all particles to a single 
particle to a single channel. 
Note that these methods usually are less elegant and safe than the 
input methods outlined above. If you use any of these methods, it is 
likely to be the ones in the full database, i.e. the first ones to be 
covered in the following. 
 
<p/> 
For convenience, we have grouped related input and output methods 
together. It should be obvious from the context which is which: 
the input is of type <code>void</code> and has an extra last argument, 
namely is the input value, while the output method returns a 
quantity of the expected type. 
 
<h3>The ParticleData methods</h3> 
 
<a name="method1"></a>
<p/><strong>ParticleData::ParticleData() &nbsp;</strong> <br/>
the constructor has no arguments and does not do anything. Internal. 
   
 
<a name="method2"></a>
<p/><strong>ParticleData& operator=( const ParticleData& particleDataIn) &nbsp;</strong> <br/>
copy the database from an existing <code>ParticleData</code> object. 
Can be useful when running with multiple <code>Pythia</code> instances. 
Does not include the links to the resonance decay handling set up by 
<code>initWidths(...)</code>. 
   
 
<a name="method3"></a>
<p/><strong>void ParticleData::initPtr(Info* infoPtr, Settings* settingsPtrIn, Rndm* rndmPtrIn, CoupSM* coupSMPtrIn) &nbsp;</strong> <br/>
initialize pointers to a few other classes. Internal. 
   
 
<a name="method4"></a>
<p/><strong>bool ParticleData::init(string startFile = &quot;../share/Pythia8/xmldoc/ParticleData.xml&quot;) &nbsp;</strong> <br/>
read in an XML-style file with particle data and initialize the 
particle data tables accordingly. This command is executed 
in the <code>Pythia</code> constructor, i.e. is mainly for 
internal use. 
<br/><code>argument</code><strong> startFile </strong> (<code>default = <strong>../share/Pythia8/xmldoc/ParticleData.xml</strong></code>) :  
the name of the data file to be read. When called from the 
<code>Pythia</code> constructor the directory is provided by the 
<code><?php $filepath = $_GET["filepath"];
echo "<a href='ProgramFlow.php?filepath=".$filepath."' target='page'>";?>PYTHIA8DATA</a></code> 
environment variable, if set, else by the argument of this constructor, 
which has the default value &quot;../share/Pythia8/xmldoc&quot;. 
   
   
 
<a name="method5"></a>
<p/><strong>bool ParticleData::init(const ParticleData& particleDataIn &nbsp;</strong> <br/>
copy particle data from information stored in an existing 
<code>ParticleData</code> instance. 
   
 
<a name="method6"></a>
<p/><strong>bool ParticleData::init(istream& is &nbsp;</strong> <br/>
copy particle data from a stream (rather than from a file). 
   
 
<a name="method7"></a>
<p/><strong>bool ParticleData::reInit(string startFile, bool xmlFormat = true) &nbsp;</strong> <br/>
overwrite the existing database by reading from the specified file. 
Unlike <code>init</code> above this method is not called by the 
<code>Pythia</code> constructor, but is entirely intended for users 
who want to replace the existing particle data with their own. 
<br/><code>argument</code><strong> startFile </strong>  : the path and name of file to be read. 
   
<br/><code>argument</code><strong> xmlFormat </strong>  : if true read the same kind of XML-style file 
as used by <code>init</code>, if not use an alternative "free format" 
file (i.e. without any XML tags, but with well-defined rules 
specifying in which order properties are stored). 
   
   
 
<a name="method8"></a>
<p/><strong>void ParticleData::initWidths( vector&lt;ResonanceWidths*&gt; resonancePtrs) &nbsp;</strong> <br/>
initialize Breit-Wigner shape parameters for all particles, 
and the detailed handling of resonances, i.e. particles with 
perturbatively calculable partial widths, which can be used to 
obtain a mass-dependent Breit-Wigner and a dynamic choice of 
decay channels. Called from <code>Pythia::init()</code>. 
   
 
<a name="method9"></a>
<p/><strong>bool ParticleData::readXML(string inFile, bool reset = true) &nbsp;</strong> <br/>
   
<strong>void ParticleData::listXML(string outFile) &nbsp;</strong> <br/>
read in XML-style data from a file or write it out to a file. For the 
former one can also decide whether to reset all particles to scratch, 
or only overwrite those particles in the file. The former method is 
used by <code>init</code> and <code>reInit</code> above. 
   
 
<a name="method10"></a>
<p/><strong>bool ParticleData::readFF(string inFile, bool reset = true) &nbsp;</strong> <br/>
   
<strong>void ParticleData::listFF(string outFile) &nbsp;</strong> <br/>
read in free-format-style data from a file or write it out to a file. 
For the former one can also decide whether to reset all particles to 
scratch, or only overwrite those particles in the file. The former 
method is used by <code>reInit</code> above. 
   
 
<a name="method11"></a>
<p/><strong>bool ParticleData::readString(string line, bool warn = true) &nbsp;</strong> <br/>
read in a string and interpret is as a new or changed particle data. 
The possibilities are extensively described above. It is normally 
used indirectly, via <code>Pythia::readString(...)</code> and 
<code>Pythia::readFile(...)</code>. 
<br/><code>argument</code><strong> line </strong>  :  
the string to be interpreted as an instruction. 
   
<br/><code>argument</code><strong> warn </strong> (<code>default = <strong>on</strong></code>) :  
write a warning message or not whenever the instruction does not make 
sense, e.g. if the particle does not exist in the database. 
   
<br/><b>Note:</b> the method returns false if it fails to 
make sense out of the input string. 
   
 
<a name="method12"></a>
<p/><strong>void ParticleData::listAll() &nbsp;</strong> <br/>
   
<strong>void ParticleData::listChanged(bool changedRes = false) &nbsp;</strong> <br/>
   
<strong>void ParticleData::list(bool changedOnly = false, bool changedRes = true) &nbsp;</strong> <br/>
methods intended to present a listing of particle data in a readable 
format. The first two are special cases of the third. The first 
lists all particle data, the second only data for those particles that 
were changed after the original creation of the particle data table. 
Resonances are a special case since they can get their data changed 
by being linked to an object that does the calculation of branching 
ratios. By default the second method does not count such resonances 
as changed, whereas the third does and thus lists all resonances. 
   
 
<a name="method13"></a>
<p/><strong>void ParticleData::list(int idList) &nbsp;</strong> <br/>
   
<strong>void ParticleData::list(vector&lt;int&gt; idList) &nbsp;</strong> <br/>
list particle data for one single particle, with the identity code as 
input, or for a set of particles, with an input vector of identity codes. 
   
 
<a name="method14"></a>
<p/><strong>vector&lt;string&gt; ParticleData::getReadHistory() &nbsp;</strong> <br/>
Method to retrieve the history of <code>readString</code> commands that 
have been processed by the <code>ParticleData</code> instance, e.g. for 
inspection. Note that <code>ParticleData</code> commands read by 
<code>Pythia::readString</code> and <code>Pythia::readFile</code> 
are interpreted by <code>readString</code> and thus also are listed. 
   
 
<a name="method15"></a>
<p/><strong>vector&lt;string&gt; ParticleData::getReadHistory(int subrun) &nbsp;</strong> <br/>
Method to retrieve the history of <code>readString</code> commands that 
have been processed by the <code>ParticleData</code> instance, for a 
specific subrun (see the section on <a href='MainProgramSettings.php?filepath=".$filepath."' target='page'> 
Main-Program Settings</a>). For <code>subrun = -1</code>, returns the 
<code>readString</code> history common to all subruns. For 
<code>subrun >= 0</code>, returns the history of <code>readString</code> 
commands for that specific subrun (omitting the common part). 
   
 
<a name="method16"></a>
<p/><strong>void ParticleData::checkTable(int verbosity) &nbsp;</strong> <br/>
check that the particle decay table makes sense, especially for decays. 
<br/><code>argument</code><strong> verbosity </strong>  :  level of checks. 0 is only minimal, 
e.g. if a particle has no open decay channels. 1, which is the level 
of the first method, provides warning if any individual channel is 
closed, except for resonances. 2 also prints the 
branching-ratio-averaged threshold mass. 11 and 12 are like 1 and 2, 
but also include resonances in the detailed checks. 
   
   
 
<a name="method17"></a>
<p/><strong>void ParticleData::addParticle(int id, string name = &quot; &quot;, int spinType = 0, int chargeType = 0, int colType = 0, double m0 = 0., double mWidth = 0., double mMin = 0., double mMax = 0., double tau0 = 0.) &nbsp;</strong> <br/>
   
<strong>void ParticleData::addParticle(int id, string name, string antiName, int spinType = 0, int chargeType = 0, int colType = 0, double m0 = 0., double mWidth = 0., double mMin = 0., double mMax = 0., double tau0 = 0.) &nbsp;</strong> <br/>
add a particle to the decay table; in the first form a particle which is 
its own antiparticle, in the second where a separate antiparticle exists. 
   
 
<a name="method18"></a>
<p/><strong>void ParticleData::setAll(int id, string name, string antiName, int spinType = 0, int chargeType = 0, int colType = 0, double m0 = 0., double mWidth = 0., double mMin = 0., double mMax = 0.,double tau0 = 0.) &nbsp;</strong> <br/>
change all the properties of the particle associated with a given 
identity code. 
   
 
<a name="method19"></a>
<p/><strong>bool ParticleData::isParticle(int id) &nbsp;</strong> <br/>
query whether the particle data table contains the particle of the 
identity code. 
   
 
<a name="method20"></a>
<p/><strong>int ParticleData::nextId(int id) &nbsp;</strong> <br/>
return the identity code of the sequentially next particle stored in table. 
   
 
<a name="method21"></a>
<p/><strong>bool ParticleData::hasAnti(int id) &nbsp;</strong> <br/>
bool whether a distinct antiparticle exists or not. Is true if an 
antiparticle name has been set (and is different from 
<code>void</code>). 
   
 
<a name="method22"></a>
<p/><strong>void ParticleData::name(int id, string name) &nbsp;</strong> <br/>
   
<strong>void ParticleData::antiName(int id, string antiName) &nbsp;</strong> <br/>
   
<strong>void ParticleData::names(int id, string name, string antiName) &nbsp;</strong> <br/>
   
<strong>string ParticleData::name(int id) &nbsp;</strong> <br/>
particle and antiparticle names are stored separately, the sign of 
<code>id</code> determines which of the two is returned, with 
<code>void</code> used to indicate the absence of an antiparticle. 
   
 
<a name="method23"></a>
<p/><strong>void ParticleData::spinType(int id, int spinType) &nbsp;</strong> <br/>
   
<strong>int ParticleData::spinType(int id) &nbsp;</strong> <br/>
the spin type, of the form <i>2 s + 1</i>, with special code 0 
for entries of unknown or indeterminate spin. 
   
 
<a name="method24"></a>
<p/><strong>void ParticleData::chargeType(int id, int chargeType) &nbsp;</strong> <br/>
   
<strong>int ParticleData::chargeType(int id) &nbsp;</strong> <br/>
three times the charge (to make it an integer), taking into account 
the sign of <code>id</code>. 
   
 
<a name="method25"></a>
<p/><strong>double ParticleData::charge(int id) &nbsp;</strong> <br/>
the electrical charge of a particle, equal to 
<code>chargeType(id)/3</code>. 
   
 
<a name="method26"></a>
<p/><strong>void ParticleData::colType(int id, int colType) &nbsp;</strong> <br/>
   
<strong>int ParticleData::colType(int id) &nbsp;</strong> <br/>
the colour type, with 0 uncoloured, 1 triplet, -1 antitriplet and 2 
octet, taking into account the sign of <code>id</code>. 
   
 
<a name="method27"></a>
<p/><strong>void ParticleData::m0(int id, double m0) &nbsp;</strong> <br/>
   
<strong>double ParticleData::m0(int id) &nbsp;</strong> <br/>
the nominal mass <i>m_0</i> (in GeV). 
   
 
<a name="method28"></a>
<p/><strong>void ParticleData::mWidth(int id, double mWidth) &nbsp;</strong> <br/>
   
<strong>double ParticleData::mWidth(int id) &nbsp;</strong> <br/>
the width <i>Gamma</i> of the Breit-Wigner distribution (in GeV). 
   
 
<a name="method29"></a>
<p/><strong>void ParticleData::mMin(int id, double mMin) &nbsp;</strong> <br/>
   
<strong>double ParticleData::mMin(int id) &nbsp;</strong> <br/>
the lower limit of the allowed mass range generated by the Breit-Wigner 
(in GeV). Has no meaning for particles without width, and would 
typically be 0 there. 
   
 
<a name="method30"></a>
<p/><strong>void ParticleData::mMax(int id, double mMax) &nbsp;</strong> <br/>
   
<strong>double ParticleData::mMax(int id) &nbsp;</strong> <br/>
the upper limit of the allowed mass range generated by the Breit-Wigner 
(in GeV). If <i>mMax &lt; mMin</i> then no upper limit is imposed. 
Has no meaning for particles without width, and would typically 
be 0 there. 
   
 
<a name="method31"></a>
<p/><strong>double ParticleData::m0Min(int id) &nbsp;</strong> <br/>
similar to <code>mMin()</code> above, except that for particles with 
no width the <code>m0(id)</code> value is returned. 
   
 
<a name="method32"></a>
<p/><strong>double ParticleData::m0Max(int id) &nbsp;</strong> <br/>
similar to <code>mMax()</code> above, except that for particles with 
no width the <code>m0(id)</code> value is returned. 
   
 
<a name="method33"></a>
<p/><strong>void ParticleData::tau0(int id, double tau0) &nbsp;</strong> <br/>
   
<strong>double ParticleData::tau0(int id) &nbsp;</strong> <br/>
the nominal proper lifetime <i>tau_0</i> (in mm/c). 
   
 
<a name="method34"></a>
<p/><strong>void ParticleData::isResonance(int id, bool isResonance) &nbsp;</strong> <br/>
   
<strong>bool ParticleData::isResonance(int id) &nbsp;</strong> <br/>
a flag telling whether a particle species are considered as a resonance 
or not. Here <?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>"resonance"</a> 
is used as shorthand for any massive particle 
where the decay process should be counted as part of the hard process 
itself, and thus be performed before showers and other event aspects 
are added. Restrictions on allowed decay channels is also directly 
reflected in the cross section of simulated processes, while those of 
normal hadrons and other light particles are not. 
In practice, it is reserved for states above the <i>b bbar</i> 
bound systems in mass, i.e. for <i>W, Z, t</i>, Higgs states, 
supersymmetric states and (most?) other states in any new theory. 
All particles with <code>m0</code> above 20 GeV are by default 
initialized to be considered as resonances. 
   
 
<a name="method35"></a>
<p/><strong>void ParticleData::mayDecay(int id, bool mayDecay) &nbsp;</strong> <br/>
   
<strong>bool ParticleData::mayDecay(int id) &nbsp;</strong> <br/>
a flag telling whether a particle species may decay or not, offering 
the main user switch. Whether a given particle of this kind then actually 
will decay also depends on it having allowed decay channels, and on 
other flags for <?php $filepath = $_GET["filepath"];
echo "<a href='ParticleDecays.php?filepath=".$filepath."' target='page'>";?>particle decays</a> 
(or <?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>resonance decays</a>). 
All particles with <code>tau0</code> below 1000 mm are 
by default initialized to allow decays. 
   
 
<a name="method36"></a>
<p/><strong>void ParticleData::doExternalDecays(int id, bool doExternalDecays) &nbsp;</strong> <br/>
   
<strong>bool ParticleData::doExternalDecay(int id) &nbsp;</strong> <br/>
a flag telling whether a particle should be handled by an external 
decay package or not, with the latter default. Can be manipulated as 
described on this page, but should normally not be. Instead the 
<code><?php $filepath = $_GET["filepath"];
echo "<a href='ExternalDecays.php?filepath=".$filepath."' target='page'>";?>pythia.decayPtr</a></code> 
method should be provided with the list of relevant particles. 
   
 
<a name="method37"></a>
<p/><strong>void ParticleData::isVisible(int id, bool isVisible) &nbsp;</strong> <br/>
   
<strong>bool ParticleData::isVisible(int id) &nbsp;</strong> <br/>
a flag telling whether a particle species is to be considered as 
visible in a detector or not, as used e.g. in analysis routines. 
By default the invisibles include neutrinos, Dark Matter particles 
(codes 51 - 60) and a few BSM particles (gravitino, sneutrinos, 
neutralinos) that have neither strong nor electromagnetic charge, 
and are not made up of constituents that have it. The value of this 
flag is only relevant if a particle is long-lived enough actually 
to make it to a detector. 
   
 
<a name="method38"></a>
<p/><strong>void ParticleData::doForceWidth(int id, bool doForceWidth) &nbsp;</strong> <br/>
   
<strong>bool ParticleData::doForceWidth(int id) &nbsp;</strong> <br/>
a flag applicable only for resonances (see <code>isResonance</code> above), 
whereby it is possible to force resonances to retain their assigned widths, 
whatever that is, see <?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>Resonance Decays</a> 
for details. The normal behaviour is <code>false</code>, i.e. the width 
is based on hardcoded calculations whenever available. 
   
 
<a name="method39"></a>
<p/><strong>void ParticleData::hasChanged(int id, bool hasChanged) &nbsp;</strong> <br/>
   
<strong>bool ParticleData::hasChanged(int id) &nbsp;</strong> <br/>
keep track of whether the data for a particle has been changed 
in any respect between initialization and the current status. 
Is used e.g. by the <code>listChanged</code> method to determine 
which particles to list. 
   
 
<a name="method40"></a>
<p/><strong>bool ParticleData::useBreitWigner(int id) &nbsp;</strong> <br/>
tells whether a particle will have a Breit-Wigner mass distribution or 
not. Is determined by an internal logic based on the particle width and 
on the value of the 
<code><?php $filepath = $_GET["filepath"];
echo "<a href='ParticleData.php?filepath=".$filepath."' target='page'>";?>ParticleData:modeBreitWigner</a></code> 
switch. 
   
 
<a name="method41"></a>
<p/><strong>double ParticleData::constituentMass(int id) &nbsp;</strong> <br/>
is the constituent mass for a quark, hardcoded as 
<i>m_u = m_d = 0.325</i>, <i>m_s = 0.50</i>, <i>m_c = 1.60</i> 
and <i>m_b = 5.0</i> GeV, for a diquark the sum of quark constituent 
masses, and for everything else the same as the ordinary mass. 
   
 
<a name="method42"></a>
<p/><strong>double ParticleData::mSel(int id) &nbsp;</strong> <br/>
returns a mass distributed according to a truncated Breit-Wigner, 
with parameters as described here. Is equal to <code>m0(id)</code> for 
particles without width. 
   
 
<a name="method43"></a>
<p/><strong>double ParticleData::mRun(int id, double mH) &nbsp;</strong> <br/>
calculate the running mass of species <code>id</code> when probed at a 
hard mass scale of <code>mH</code>. Only applied to obtain the 
running quark masses; for all other particle the normal fixed mass 
is used. 
   
 
<a name="method44"></a>
<p/><strong>bool ParticleData::canDecay(int id) &nbsp;</strong> <br/>
true for a particle with at least one decay channel defined. 
   
 
<a name="method45"></a>
<p/><strong>bool ParticleData::isLepton(int id) &nbsp;</strong> <br/>
true for a lepton or an antilepton (including neutrinos). 
   
 
<a name="method46"></a>
<p/><strong>bool ParticleData::isQuark(int id) &nbsp;</strong> <br/>
true for a quark or an antiquark. 
   
 
<a name="method47"></a>
<p/><strong>bool ParticleData::isGluon(int id) &nbsp;</strong> <br/>
true for a gluon. 
   
 
<a name="method48"></a>
<p/><strong>bool ParticleData::isDiquark(int id) &nbsp;</strong> <br/>
true for a diquark or antidiquark. 
   
 
<a name="method49"></a>
<p/><strong>bool ParticleData::isParton() &nbsp;</strong> <br/>
true for a gluon, a quark or antiquark up to the b (but excluding top), 
and a diquark or antidiquark consisting of quarks up to the b. 
   
 
<a name="method50"></a>
<p/><strong>bool ParticleData::isHadron(int id) &nbsp;</strong> <br/>
true for a hadron (made up out of normal quarks and gluons, 
i.e. not for R-hadrons and other exotic states). 
   
 
<a name="method51"></a>
<p/><strong>bool ParticleData::isMeson(int id) &nbsp;</strong> <br/>
true for a meson. 
   
 
<a name="method52"></a>
<p/><strong>bool ParticleData::isBaryon(int id) &nbsp;</strong> <br/>
true for a baryon or antibaryon. 
   
 
<a name="method53"></a>
<p/><strong>bool ParticleData::isOctetHadron(int id) &nbsp;</strong> <br/>
true for an intermediate hadron-like state with a colour octet charge 
as used in the colour octet model for 
<?php $filepath = $_GET["filepath"];
echo "<a href='OniaProcesses.php?filepath=".$filepath."' target='page'>";?>onia</a> production. 
   
 
<a name="method54"></a>
<p/><strong>int ParticleData::heaviestQuark(int id) &nbsp;</strong> <br/>
extracts the heaviest quark or antiquark, i.e. one with largest 
<code>id</code> number, for a hadron. 
   
 
<a name="method55"></a>
<p/><strong>int ParticleData::baryonNumberType(int id) &nbsp;</strong> <br/>
is 1 for a quark, 2 for a diquark, 3 for a baryon, the same with a 
minus sign for antiparticles, and else zero. 
   
 
<a name="method56"></a>
<p/><strong>void ParticleData::rescaleBR(int id, double newSumBR = 1.) &nbsp;</strong> <br/>
rescales all partial branching ratios by a common factor, such that 
the sum afterward becomes <code>newSumBR</code>. 
   
 
<a name="method57"></a>
<p/><strong>void setResonancePtr(int id, ResonanceWidths* resonancePtr) &nbsp;</strong> <br/>
set a pointer for a particle kind to a <code>ResonanceWidths</code> object. 
This is done, from inside <code>ParticleData::initWidths</code>, only for 
resonances, i.e. for particles such as <i>Z^0</i>, <i>W^+-</i>, top, 
Higgs, and new unstable states beyond the Standard Model. The presence 
of such an object will allow a more dynamic calculation of partial and 
total widths, as illustrated by the following methods. 
   
 
<a name="method58"></a>
<p/><strong>void ParticleData::resInit(int id) &nbsp;</strong> <br/>
initialize the treatment of a resonance. 
   
 
<a name="method59"></a>
<p/><strong>double ParticleData::resWidth(int id, double mHat, int idInFlav = 0, bool openOnly = false, bool setBR = false) &nbsp;</strong> <br/>
calculate the total with for a resonance of a given current mass, 
optionally including coupling to incoming flavour state (consider 
the <i>gamma*/Z^0</i> combination), optionally excluding decay 
channels that have been closed by the user, and optionally storing 
the results in the normal decay table. 
   
 
<a name="method60"></a>
<p/><strong>double ParticleData::resWidthOpen(int id, double mHat, int idInFlav = 0) &nbsp;</strong> <br/>
special case of <code>resWidth</code>, where only open channels are 
included, but results are not stored in the normal decay table. 
   
 
<a name="method61"></a>
<p/><strong>double ParticleData::resWidthStore(int id, double mHat, int idInFlav = 0) &nbsp;</strong> <br/>
special case of <code>resWidth</code>, where only open channels are 
included, and results are stored in the normal decay table. 
   
 
<a name="method62"></a>
<p/><strong>double ParticleData::resOpenFrac(int id1, int id2 = 0, int id3 = 0) &nbsp;</strong> <br/>
calculate the fraction of the full branching ratio that is left 
open by the user choice of allowed decay channels. Can be applied 
to a final state with up to three resonances. Since the procedure 
is multiplicative, it would be easy to generalize also to more. 
   
 
<a name="method63"></a>
<p/><strong>double ParticleData::resWidthRescaleFactor(int id) &nbsp;</strong> <br/>
the factor used to rescale all partial widths in case the total 
width is being forced to a specific value by the user. 
   
 
<a name="method64"></a>
<p/><strong>double ParticleData::resWidthChan(int id, double mHat, int idAbs1 = 0, int idAbs2 = 0) &nbsp;</strong> <br/>
special case to calculate one final-state width; currently only used 
for Higgs decay to <i>q qbar</i>, <i>g g</i> or 
<i>gamma gamma</i>. 
   
 
<a name="method65"></a>
<p/><strong>ParticleDataEntry* ParticleData::particleDataEntryPtr(int id) &nbsp;</strong> <br/>
returns a pointer to the <code>ParticleDataEntry</code> object. 
The methods in the next section can then be used to manipulate 
this object. 
   
 
<a name="method66"></a>
<p/><strong>bool ParticleData::getIsInit() &nbsp;</strong> <br/>
return true if the database has been initialized, else false. 
   
 
<h3>The ParticleDataEntry methods</h3> 
 
Most of the methods that can be applied to a single 
<code>ParticleDataEntry</code> object are almost identical with 
those used above for the <code>ParticleData</code>, except 
that the <code>id</code> argument is no longer needed to find 
the right entry in the table. By and large, this makes direct 
access to the <code>ParticleDataEntry</code> methods superfluous. 
There are a few methods that are unique to each class, however. 
Furthermore, to avoid some naming ambiguities, many methods that 
set values begin with <code>set</code>. 
 
<a name="method67"></a>
<p/><strong>ParticleDataEntry::ParticleDataEntry(int id = 0, string name = &quot; &quot;, int spinType = 0, int chargeType = 0, int colType = 0, double m0 = 0., double mWidth = 0., double mMin = 0., double mMax = 0., double tau0 = 0.) &nbsp;</strong> <br/>
   
<strong>ParticleDataEntry::ParticleDataEntry(int id, string name, string antiName, int spinType = 0, int chargeType = 0, int colType = 0, double m0 = 0., double mWidth = 0., double mMin = 0., double mMax = 0., double tau0 = 0.) &nbsp;</strong> <br/>
there are two alternative constructors, that both expect the 
properties of a particle as input. The first assumes that there 
is only one particle, the latter that there is a 
particle-antiparticle pair (but if the antiparticle name is 
<code>void</code> one reverts back to the particle-only case). 
   
 
<a name="method68"></a>
<p/><strong>ParticleDataEntry& operator=( const ParticleDataEntry& particleDataEntryIn) &nbsp;</strong> <br/>
copy the values stored in an existing <code>ParticleDataEntry</code> 
object. 
   
 
<a name="method69"></a>
<p/><strong>ParticleDataEntry::~ParticleDataEntry &nbsp;</strong> <br/>
the destructor is needed to delete any <code>ResonanceWidths</code> 
objects that have been created and linked to the respective particle. 
   
 
<a name="method70"></a>
<p/><strong>void ParticleDataEntry::setDefaults() &nbsp;</strong> <br/>
initialize some particle flags with default values, e.g. whether 
a particle is a resonance, may decay, or is visible. Is called from the 
constructors and from <code>setAll</code>. 
   
 
<a name="method71"></a>
<p/><strong>void ParticleDataEntry::initPtr(ParticleData* particleDataPtrIn) &nbsp;</strong> <br/>
initialize pointer back to the whole database (so that masses of 
decay products can be accessed, e.g.). 
   
 
<a name="method72"></a>
<p/><strong>void ParticleDataEntry::setAll( string name, string antiName, int spinType = 0, int chargeType = 0, int colType = 0, double m0 = 0., double mWidth = 0., double mMin = 0., double mMax = 0.,double tau0 = 0.) &nbsp;</strong> <br/>
change all the properties of the particle associated with a given 
identity code. 
   
 
<a name="method73"></a>
<p/><strong>int ParticleDataEntry::id() &nbsp;</strong> <br/>
the PDG identity code. 
   
 
<a name="method74"></a>
<p/><strong>bool ParticleDataEntry::hasAnti() &nbsp;</strong> <br/>
tell whether a separate antiparticle exists. 
   
 
<a name="method75"></a>
<p/><strong>void ParticleDataEntry::setName(string name) &nbsp;</strong> <br/>
   
<strong>void ParticleDataEntry::setAntiName(string antiName) &nbsp;</strong> <br/>
   
<strong>void ParticleDataEntry::setNames(string name, string antiName) &nbsp;</strong> <br/>
   
<strong>string ParticleDataEntry::name(int id = 1) &nbsp;</strong> <br/>
set or get the particle or antiparticle name. Only the sign of 
<code>id</code> is needed to distinguish particle/antiparticle. 
   
 
<a name="method76"></a>
<p/><strong>void ParticleDataEntry::setSpinType(int spinType) &nbsp;</strong> <br/>
   
<strong>int ParticleDataEntry::spinType() &nbsp;</strong> <br/>
set or get the particle spin type, i.e. <i>2 s + 1</i>, or 0 in some 
special cases. 
   
 
<a name="method77"></a>
<p/><strong>void ParticleDataEntry::setChargeType(int chargeType) &nbsp;</strong> <br/>
   
<strong>int ParticleDataEntry::chargeType(int id = 1) &nbsp;</strong> <br/>
   
<strong>double ParticleDataEntry::charge(int id = 1) &nbsp;</strong> <br/>
set or get the particle charge type, i.e. three times the charge, 
or the charge itself. Only the sign of <code>id</code> is needed 
to distinguish particle/antiparticle. 
   
 
<a name="method78"></a>
<p/><strong>void ParticleDataEntry::setColType(int colType) &nbsp;</strong> <br/>
   
<strong>int ParticleDataEntry::colType(int id = 1) &nbsp;</strong> <br/>
set or get the particle colour type, 0 for singlet, 1 for triplet, 
-1 for antitriplet, 2 for octet. Only the sign of <code>id</code> 
is needed to distinguish particle/antiparticle. 
   
 
<a name="method79"></a>
<p/><strong>void ParticleDataEntry::setM0(double m0) &nbsp;</strong> <br/>
   
<strong>double ParticleDataEntry::m0() &nbsp;</strong> <br/>
the nominal mass <i>m_0</i> (in GeV). 
   
 
<a name="method80"></a>
<p/><strong>void ParticleDataEntry::setMWidth(double mWidth) &nbsp;</strong> <br/>
   
<strong>double ParticleDataEntry::mWidth() &nbsp;</strong> <br/>
the width <i>Gamma</i> of the Breit-Wigner distribution (in GeV). 
   
 
<a name="method81"></a>
<p/><strong>void ParticleDataEntry::setMMin(double mMin) &nbsp;</strong> <br/>
   
<strong>double ParticleDataEntry::mMin() &nbsp;</strong> <br/>
the lower limit of the allowed mass range generated by the Breit-Wigner 
(in GeV). Has no meaning for particles without width, and would 
typically be 0 there. 
   
 
<a name="method82"></a>
<p/><strong>void ParticleDataEntry::setMMax(double mMax) &nbsp;</strong> <br/>
   
<strong>double ParticleDataEntry::mMax() &nbsp;</strong> <br/>
the upper limit of the allowed mass range generated by the Breit-Wigner 
(in GeV). If <i>mMax &lt; mMin</i> then no upper limit is imposed. 
Has no meaning for particles without width, and would typically 
be 0 there. 
   
 
<a name="method83"></a>
<p/><strong>double ParticleDataEntry::m0Min() &nbsp;</strong> <br/>
similar to <code>mMin()</code> above, except that for particles with 
no width the <code>m0(id)</code> value is returned. 
   
 
<a name="method84"></a>
<p/><strong>double ParticleDataEntry::m0Max() &nbsp;</strong> <br/>
similar to <code>mMax()</code> above, except that for particles with 
no width the <code>m0(id)</code> value is returned. 
   
 
<a name="method85"></a>
<p/><strong>void ParticleDataEntry::setTau0(double tau0) &nbsp;</strong> <br/>
   
<strong>double ParticleDataEntry::tau0() &nbsp;</strong> <br/>
the nominal proper lifetime <i>tau_0</i> (in mm/c). 
   
 
<a name="method86"></a>
<p/><strong>void ParticleDataEntry::setIsResonance(bool isResonance) &nbsp;</strong> <br/>
   
<strong>bool ParticleDataEntry::isResonance() &nbsp;</strong> <br/>
a flag telling whether a particle species are considered as a resonance 
or not. Here <?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>"resonance"</a> 
is used as shorthand for any massive particle 
where the decay process should be counted as part of the hard process 
itself, and thus be performed before showers and other event aspects 
are added. Restrictions on allowed decay channels is also directly 
reflected in the cross section of simulated processes, while those of 
normal hadrons and other light particles are not. 
In practice, it is reserved for states above the <i>b bbar</i> 
bound systems in mass, i.e. for <i>W, Z, t</i>, Higgs states, 
supersymmetric states and (most?) other states in any new theory. 
All particles with <code>m0</code> above 20 GeV are by default 
initialized to be considered as resonances. 
   
 
<a name="method87"></a>
<p/><strong>void ParticleDataEntry::setMayDecay(bool mayDecay) &nbsp;</strong> <br/>
   
<strong>bool ParticleDataEntry::mayDecay() &nbsp;</strong> <br/>
a flag telling whether a particle species may decay or not, offering 
the main user switch. Whether a given particle of this kind then actually 
will decay also depends on it having allowed decay channels, and on 
other flags for <?php $filepath = $_GET["filepath"];
echo "<a href='ParticleDecays.php?filepath=".$filepath."' target='page'>";?>particle decays</a> 
(or <?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>resonance decays</a>). 
All particles with <code>tau0</code> below 1000 mm are 
by default initialized to allow decays. 
   
 
<a name="method88"></a>
<p/><strong>void ParticleDataEntry::setDoExternalDecays(bool doExternalDecays) &nbsp;</strong> <br/>
   
<strong>bool ParticleDataEntry::doExternalDecay() &nbsp;</strong> <br/>
a flag telling whether a particle should be handled by an external 
decay package or not, with the latter default. Can be manipulated as 
described on this page, but should normally not be. Instead the 
<code><?php $filepath = $_GET["filepath"];
echo "<a href='ExternalDecays.php?filepath=".$filepath."' target='page'>";?>pythia.decayPtr</a></code> 
method should be provided with the list of relevant particles. 
   
 
<a name="method89"></a>
<p/><strong>void ParticleDataEntry::setIsVisible(bool isVisible) &nbsp;</strong> <br/>
   
<strong>bool ParticleDataEntry::isVisible() &nbsp;</strong> <br/>
a flag telling whether a particle species is to be considered as 
visible in a detector or not, as used e.g. in analysis routines. 
By default the invisibles include neutrinos, Dark Matter particles 
(codes 51 - 60) and a few BSM particles (gravitino, sneutrinos, 
neutralinos) that have neither strong nor electromagnetic charge, 
and are not made up of constituents that have it. The value of this 
flag is only relevant if a particle is long-lived enough actually 
to make it to a detector. 
   
 
<a name="method90"></a>
<p/><strong>void ParticleDataEntry::setDoForceWidth(bool doForceWidth) &nbsp;</strong> <br/>
   
<strong>bool ParticleDataEntry::doForceWidth() &nbsp;</strong> <br/>
a flag applicable only for resonances (see <code>isResonance</code> above), 
whereby it is possible to force resonances to retain their assigned widths, 
whatever that is, see <?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>Resonance Decays</a> 
for details. The normal behaviour is <code>false</code>, i.e. the width 
is based on hardcoded calculations whenever available. 
   
 
<a name="method91"></a>
<p/><strong>void ParticleDataEntry::setHasChanged(bool hasChanged) &nbsp;</strong> <br/>
   
<a name="method92"></a>
<p/><strong>void ParticleDataEntry::hasChanged(bool hasChanged) &nbsp;</strong> <br/>
keep track of whether the data for a particle has been changed 
in any respect between initialization and the current status. 
Is used e.g. by the <code>ParticleData::listChanged</code> method 
to determine which particles to list. 
   
 
<a name="method93"></a>
<p/><strong>void ParticleDataEntry::initBWmass() &nbsp;</strong> <br/>
Prepare the Breit-Wigner mass selection by precalculating 
frequently-used expressions. 
   
 
<a name="method94"></a>
<p/><strong>double ParticleDataEntry::constituentMass() &nbsp;</strong> <br/>
is the constituent mass for a quark, hardcoded as 
<i>m_u = m_d = 0.325</i>, <i>m_s = 0.50</i>, <i>m_c = 1.60</i> 
and <i>m_b = 5.0</i> GeV, for a diquark the sum of quark constituent 
masses, and for everything else the same as the ordinary mass. 
   
 
<a name="method95"></a>
<p/><strong>double ParticleDataEntry::mSel() &nbsp;</strong> <br/>
give the mass of a particle, either at the nominal value 
or picked according to a (linear or quadratic) Breit-Wigner. 
   
 
<a name="method96"></a>
<p/><strong>double ParticleDataEntry::mRun(double mH) &nbsp;</strong> <br/>
calculate the running quark mass at a hard scale <code>mH</code>. 
For other particles the on-shell mass is given. 
   
 
<a name="method97"></a>
<p/><strong>bool ParticleDataEntry::useBreitWigner() &nbsp;</strong> <br/>
tells whether a particle will have a Breit-Wigner mass distribution or 
not. Is determined by an internal logic based on the particle width and 
on the value of the <code><?php $filepath = $_GET["filepath"];
echo "<a href='ParticleData.php?filepath=".$filepath."' target='page'>";?> 
ParticleData:modeBreitWigner</a></code> switch. 
   
 
<a name="method98"></a>
<p/><strong>bool ParticleDataEntry::canDecay(int id) &nbsp;</strong> <br/>
true for a particle with at least one decay channel defined. 
   
 
<a name="method99"></a>
<p/><strong>bool ParticleDataEntry::isLepton() &nbsp;</strong> <br/>
true for a lepton or an antilepton (including neutrinos). 
   
 
<a name="method100"></a>
<p/><strong>bool ParticleDataEntry::isQuark() &nbsp;</strong> <br/>
true for a quark or an antiquark. 
   
 
<a name="method101"></a>
<p/><strong>bool ParticleDataEntry::isGluon() &nbsp;</strong> <br/>
true for a gluon. 
   
 
<a name="method102"></a>
<p/><strong>bool ParticleDataEntry::isDiquark() &nbsp;</strong> <br/>
true for a diquark or antidiquark. 
   
 
<a name="method103"></a>
<p/><strong>bool ParticleDataEntry::isParton() &nbsp;</strong> <br/>
true for a gluon, a quark or antiquark up to the b (but excluding top), 
and a diquark or antidiquark consisting of quarks up to the b. 
   
 
<a name="method104"></a>
<p/><strong>bool ParticleDataEntry::isHadron() &nbsp;</strong> <br/>
true for a hadron (made up out of normal quarks and gluons, 
i.e. not for R-hadrons and other exotic states). 
   
 
<a name="method105"></a>
<p/><strong>bool ParticleDataEntry::isMeson() &nbsp;</strong> <br/>
true for a meson. 
   
 
<a name="method106"></a>
<p/><strong>bool ParticleDataEntry::isBaryon() &nbsp;</strong> <br/>
true for a baryon or antibaryon. 
   
 
<a name="method107"></a>
<p/><strong>bool ParticleDataEntry::isOctetHadron() &nbsp;</strong> <br/>
true for an intermediate hadron-like state with a colour octet charge 
as used in the colour octet model for 
<?php $filepath = $_GET["filepath"];
echo "<a href='OniaProcesses.php?filepath=".$filepath."' target='page'>";?>onia</a> production. 
   
 
<a name="method108"></a>
<p/><strong>int ParticleDataEntry::heaviestQuark(int id) &nbsp;</strong> <br/>
extracts the heaviest quark or antiquark, i.e. one with largest 
<code>id</code> number, for a hadron. Only the sign of the input 
argument is relevant. 
   
 
<a name="method109"></a>
<p/><strong>int ParticleDataEntry::baryonNumberType(int id) &nbsp;</strong> <br/>
is 1 for a quark, 2 for a diquark, 3 for a baryon, the same with a 
minus sign for antiparticles, and else zero. Only the sign of the 
input argument is relevant. 
   
 
<a name="method110"></a>
<p/><strong>void ParticleDataEntry::clearChannels() &nbsp;</strong> <br/>
resets to an empty decay table. 
   
 
<a name="method111"></a>
<p/><strong>void ParticleDataEntry::addChannel(int onMode = 0, double bRatio = 0., int meMode = 0, int prod0 = 0, int prod1 = 0, int prod2 = 0, int prod3 = 0, int prod4 = 0, int prod5 = 0, int prod6 = 0,  int prod7 = 0,) &nbsp;</strong> <br/>
adds a decay channel with up to 8 products. 
   
 
<a name="method112"></a>
<p/><strong>int ParticleDataEntry::sizeChannels() &nbsp;</strong> <br/>
returns the number of decay channels for a particle. 
   
 
<a name="method113"></a>
<p/><strong>DecayChannel& ParticleDataEntry::channel(int i) &nbsp;</strong> <br/>
   
<strong>const DecayChannel& ParticleDataEntry::channel(int i) &nbsp;</strong> <br/>
gain access to a specified channel in the decay table. 
   
 
<a name="method114"></a>
<p/><strong>void ParticleDataEntry::rescaleBR(double newSumBR = 1.) &nbsp;</strong> <br/>
rescales all partial branching ratios by a common factor, such that 
the sum afterward becomes <code>newSumBR</code>. 
   
 
<a name="method115"></a>
<p/><strong>bool ParticleDataEntry::preparePick(int idSgn, double mHat = 0., int idInFlav = 0) &nbsp;</strong> <br/>
prepare to pick a decay channel. 
   
 
<a name="method116"></a>
<p/><strong>DecayChannel& ParticleDataEntry::pickChannel() &nbsp;</strong> <br/>
pick a decay channel according to branching ratios from 
<code>preparePick</code>. 
   
 
<a name="method117"></a>
<p/><strong>void ParticleDataEntry::setResonancePtr(ResonanceWidths* resonancePtr) &nbsp;</strong> <br/>
   
<strong>ResonanceWidths* ParticleDataEntry::getResonancePtr() &nbsp;</strong> <br/>
set or get a pointer to an object that can be used for dynamic calculation 
of partial and total resonance widths. Here a resonance is a particle 
such as top, <i>Z^0</i>, <i>W^+-</i>, Higgs, and new unstable states 
beyond the Standard Model. 
   
 
<a name="method118"></a>
<p/><strong>void ParticleDataEntry::resInit(Info* infoPtrIn, Settings* settingsPtrIn, ParticleData* particleDataPtrIn, CoupSM* coupSMPtrIn) &nbsp;</strong> <br/>
initialize the treatment of a resonance. 
   
 
<a name="method119"></a>
<p/><strong>double ParticleDataEntry::resWidth(int idSgn, double mHat, int idInFlav = 0, bool openOnly = false, bool setBR = false) &nbsp;</strong> <br/>
calculate the total with for a resonance of a given current mass, 
optionally including coupling to incoming flavour state (consider 
the <i>gamma*/Z^0</i> combination), optionally excluding decay 
channels that have been closed by the user, and optionally storing 
the results in the normal decay table. For the first argument only 
the sign is relevant. 
   
 
<a name="method120"></a>
<p/><strong>double ParticleDataEntry::resWidthOpen(int idSgn, double mHat, int idInFlav = 0) &nbsp;</strong> <br/>
special case of <code>resWidth</code>, where only open channels are 
included, but results are not stored in the normal decay table. 
   
 
<a name="method121"></a>
<p/><strong>double ParticleDataEntry::resWidthStore(int idSgn, double mHat, int idInFlav = 0) &nbsp;</strong> <br/>
special case of <code>resWidth</code>, where only open channels are 
included, and results are stored in the normal decay table. 
   
 
<a name="method122"></a>
<p/><strong>double ParticleDataEntry::resOpenFrac(int idSgn) &nbsp;</strong> <br/>
calculate the fraction of the full branching ratio that is left 
open by the user choice of allowed decay channels. 
   
 
<a name="method123"></a>
<p/><strong>double ParticleDataEntry::resWidthRescaleFactor() &nbsp;</strong> <br/>
the factor used to rescale all partial widths in case the total 
width is being forced to a specific value by the user. 
   
 
<a name="method124"></a>
<p/><strong>double ParticleDataEntry::resWidthChan(double mHat, int idAbs1 = 0, int idAbs2 = 0) &nbsp;</strong> <br/>
special case to calculate one final-state width; currently only used 
for Higgs decay to <i>q qbar</i>, <i>g g</i> or 
<i>gamma gamma</i>. 
   
 
<h3>The DecayChannel methods</h3> 
 
The properties stored in an individual decay channel can be set or get 
by the methods in this section. 
 
<a name="method125"></a>
<p/><strong>DecayChannel::DecayChannel(int onMode = 0, double bRatio = 0., int meMode = 0, int prod0 = 0, int prod1 = 0, int prod2 = 0, int prod3 = 0, int prod4 = 0, int prod5 = 0, int prod6 = 0, int prod7 = 0) &nbsp;</strong> <br/>
the constructor for a decay channel. Internal. 
   
 
<a name="method126"></a>
<p/><strong>DecayChannel& operator=( const DecayChannel& decayChannelIn) &nbsp;</strong> <br/>
copy the values stored in an existing <code>DecayChannel</code> object. 
   
 
<a name="method127"></a>
<p/><strong>void DecayChannel::onMode(int onMode) &nbsp;</strong> <br/>
   
<strong>int DecayChannel::onMode() &nbsp;</strong> <br/>
set or get the <code>onMode</code> of a decay channel,<br/> 
0 if a channel is off,<br/> 
1 if on,<br/> 
2 if on for a particle but off for an antiparticle,<br/> 
3 if on for an antiparticle but off for a particle.<br/> 
If a particle is its own antiparticle then 2 is on and 3 off 
but, of course, for such particles it is much simpler and safer 
to use only 1 and 0.<br/> 
The 2 and 3 options can be used e.g. to encode CP violation in 
B decays, or to let the <i>W</i>'s in a <i>q qbar &rarr; W^+ W^-</i> 
process decay in different channels. 
   
 
<a name="method128"></a>
<p/><strong>void DecayChannel::bRatio(double bRatio, bool countAsChanged = true) &nbsp;</strong> <br/>
   
<strong>double DecayChannel::bRatio() &nbsp;</strong> <br/>
set or get the branching ratio of the channel. Second argument only 
for internal use. 
   
 
<a name="method129"></a>
<p/><strong>void DecayChannel::rescaleBR(double fac) &nbsp;</strong> <br/>
multiply the current branching ratio by <code>fac</code>. 
   
 
<a name="method130"></a>
<p/><strong>void DecayChannel::meMode(int meMode) &nbsp;</strong> <br/>
   
<strong>int DecayChannel::meMode() &nbsp;</strong> <br/>
set or get the mode of processing this channel, possibly with matrix 
elements (see the <?php $filepath = $_GET["filepath"];
echo "<a href='ParticleDecays.php?filepath=".$filepath."' target='page'>";?>particle decays</a> 
and <?php $filepath = $_GET["filepath"];
echo "<a href='ResonanceDecays.php?filepath=".$filepath."' target='page'>";?>resonance decays</a> descriptions). 
   
 
<a name="method131"></a>
<p/><strong>void DecayChannel::multiplicity(int multiplicity) &nbsp;</strong> <br/>
   
<strong>int DecayChannel::multiplicity() &nbsp;</strong> <br/>
set or get the number of decay products in a channel, at most 8. 
(Is normally not to be set by hand, since it is automatically 
updated whenever the products list is changed.) 
   
 
<a name="method132"></a>
<p/><strong>void DecayChannel::product(int i, int product) &nbsp;</strong> <br/>
   
<strong>int DecayChannel::product(int i) &nbsp;</strong> <br/>
set or get a list of the decay products, 8 products 0 &lt;= i &lt; 8, 
with trailing unused ones set to 0. 
   
 
<a name="method133"></a>
<p/><strong>void DecayChannel::setHasChanged(bool hasChanged) &nbsp;</strong> <br/>
   
<strong>bool DecayChannel::hasChanged() &nbsp;</strong> <br/>
used for internal purposes, to know which decay modes have been changed. 
   
 
<a name="method134"></a>
<p/><strong>bool DecayChannel::contains(int id1) &nbsp;</strong> <br/>
   
<strong>bool DecayChannel::contains(int id1, int id2) &nbsp;</strong> <br/>
   
<strong>bool DecayChannel::contains(int id1, int id2, int id3) &nbsp;</strong> <br/>
find if the decay product list contains the one, two or three particle 
identities provided. If the same code is repeated then so must it be in 
the products list. Matching also requires correct sign. 
   
 
<a name="method135"></a>
<p/><strong>void DecayChannel::currentBR(double currentBR) &nbsp;</strong> <br/>
   
<strong>double DecayChannel::currentBR() &nbsp;</strong> <br/>
set or get the current branching ratio, taking into account on/off 
switches and dynamic width for resonances. For internal use. 
   
 
<a name="method136"></a>
<p/><strong>void DecayChannel::onShellWidth(double onShellWidth) &nbsp;</strong> <br/>
   
<strong>double DecayChannel::onShellWidth() &nbsp;</strong> <br/>
set or get the current partial width of the channel; intended for 
resonances where the widths are recalculated based on the current 
resonance mass. For internal use. 
   
 
<a name="method137"></a>
<p/><strong>void DecayChannel::onShellWidthFactor(double factor) &nbsp;</strong> <br/>
multiply the current partial width by <code>factor</code>. 
   
 
<a name="method138"></a>
<p/><strong>void DecayChannel::openSec(int idSgn, double openSecIn) &nbsp;</strong> <br/>
   
<strong>double DecayChannel::openSec(nt idSgn) &nbsp;</strong> <br/>
set or get the fraction of secondary open widths, separately for 
positive and negative particles. For internal use. 
   
 
</body>
</html>
 
<!-- Copyright (C) 2017 Torbjorn Sjostrand --> 
