<html>
<head>
<title>Particle Data</title>
<link rel="stylesheet" type="text/css" href="pythia.css"/>
<link rel="shortcut icon" href="pythia32.gif"/>
</head>
<body>

<script language=javascript type=text/javascript>
function stopRKey(evt) {
var evt = (evt) ? evt : ((event) ? event : null);
var node = (evt.target) ? evt.target :((evt.srcElement) ? evt.srcElement : null);
if ((evt.keyCode == 13) && (node.type=="text"))
{return false;}
}

document.onkeypress = stopRKey;
</script>
<?php
if($_POST['saved'] == 1) {
if($_POST['filepath'] != "files/") {
echo "<font color='red'>SETTINGS SAVED TO FILE</font><br/><br/>"; }
else {
echo "<font color='red'>NO FILE SELECTED YET.. PLEASE DO SO </font><a href='SaveSettings.php'>HERE</a><br/><br/>"; }
}
?>

<form method='post' action='ParticleData.php'>
 
<h2>Particle Data</h2> 
 
The structure and operation of the particle data table is described 
<?php $filepath = $_GET["filepath"];
echo "<a href='ParticleDataScheme.php?filepath=".$filepath."' target='page'>";?>here</a>. That page 
also describes how default data properties can be changed. The 
current page provides the actual default values. 
 
<h3>Main settings</h3> 
 
Apart from the data itself, the particle data table only contains 
a few aspects that are available to change: 
 
<br/><br/><table><tr><td><strong>ParticleData:modeBreitWigner  </td><td>  &nbsp;&nbsp;(<code>default = <strong>4</strong></code>; <code>minimum = 0</code>; <code>maximum = 4</code>)</td></tr></table>
Selection of particle masses when the <code>mSel(id)</code> is called 
to provide a new mass: 
<br/>
<input type="radio" name="1" value="0"><strong>0 </strong>:   mass is fixed at the nominal <ei>m_0</ei> value.  <br/>
<input type="radio" name="1" value="1"><strong>1 </strong>:   particles registered as having a mass width are given a mass  in the range <ei>m_min &lt; m &lt; m_max</ei>, according  to a truncated nonrelativistic Breit-Wigner, i.e. linear in <ei>m</ei>.  <br/>
<input type="radio" name="1" value="2"><strong>2 </strong>:   as above, except that the width is made mass-dependent:  <ei>Gamma = Gamma_0 * sqrt( (m^2 - m_thr^2) / (m_0^2 - m_thr^2) )</ei>  where <ei>m</ei> is the current mass, <ei>m_0</ei> the nominal one and  <ei>m_thr</ei> is the mass threshold, given by the sum of the nominal  masses of the decay products. In order to decouple production and decay  the threshold is defined as the branching-ratio-weighted average over  all allowed decay channels.  <br/>
<input type="radio" name="1" value="3"><strong>3 </strong>:   particles registered as having a mass width are given a mass  in the range <ei>m_min &lt; m &lt; m_max</ei>, according  to a truncated relativistic Breit-Wigner, i.e. quadratic in <ei>m</ei>.  <br/>
<input type="radio" name="1" value="4" checked="checked"><strong>4 </strong>:   as 3, but the width is modified as for 2, and the current mass is used  for its phase-space prefactor, i.e. <ei>m_0 Gamma_0 &rarr; m Gamma(m)</ei>.  <br/>
<br/><b>Note:</b> this mode only applies to normal hadronic 
resonances like the <ei>rho</ei>. The more massive states of the 
<code>isResonance()</code> type, like <ei>Z^0</ei> or top, are 
considered separately. 
 
<br/><br/><table><tr><td><strong>ParticleData:maxEnhanceBW </td><td></td><td> <input type="text" name="2" value="2.5" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>2.5</strong></code>; <code>minimum = 1.</code>; <code>maximum = 5.</code>)</td></tr></table>
The modifications in options 2 and 4 above enhance the large-mass tail 
of the Breit-Wigner distributions (the mass spectrum develops a 
<i>dm/m</i> divergence). 
However, we expect form factors to dampen this tail at masses some distance 
above the nominal one, so cut off the rise by requiring the actual 
Breit-Wigner weight not to be more than a factor <code>maxEnhanceBW</code> 
above the one obtained with options 1 or 3, respectively. This also 
opens up for a simpler technical handling of mass selection in options 
2 and 4, by using standard hit-and-miss Monte Carlo. 
   
 
<p/> 
Since running masses are only calculated for the six quark flavours, 
e.g. to obtain couplings to the Higgs boson(s), there is not an entry 
in the normal tables for each particles, but only the six MSbar mass 
values below, used as starting point for the running. In addition you 
can pick an <i>alpha_s(M_Z)</i>, which is converted into a first-order 
five-flavour Lambda that is used to determine the rate of the running. 
(Without any match to four flavours below <i>m_b</i>; if desired, this 
can be fixed by slightly shifted default mass values, since the routines 
never should be called below the <i>m_b</i> scale anyway.) 
 
<br/><br/><table><tr><td><strong>ParticleData:mdRun </td><td></td><td> <input type="text" name="3" value="0.006" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>0.006</strong></code>; <code>minimum = 0.003</code>; <code>maximum = 0.008</code>)</td></tr></table>
the d quark MSbar mass at 2 GeV scale. 
   
 
<br/><br/><table><tr><td><strong>ParticleData:muRun </td><td></td><td> <input type="text" name="4" value="0.003" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>0.003</strong></code>; <code>minimum = 0.001</code>; <code>maximum = 0.006</code>)</td></tr></table>
the u quark MSbar mass at 2 GeV scale. 
   
 
<br/><br/><table><tr><td><strong>ParticleData:msRun </td><td></td><td> <input type="text" name="5" value="0.095" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>0.095</strong></code>; <code>minimum = 0.060</code>; <code>maximum = 0.150</code>)</td></tr></table>
the s quark MSbar mass at 2 GeV scale. 
   
 
<br/><br/><table><tr><td><strong>ParticleData:mcRun </td><td></td><td> <input type="text" name="6" value="1.25" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>1.25</strong></code>; <code>minimum = 1.00</code>; <code>maximum = 1.50</code>)</td></tr></table>
the c quark MSbar mass at the mass scale itself. 
   
 
<br/><br/><table><tr><td><strong>ParticleData:mbRun </td><td></td><td> <input type="text" name="7" value="4.20" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>4.20</strong></code>; <code>minimum = 4.00</code>; <code>maximum = 4.50</code>)</td></tr></table>
the b quark MSbar mass at the mass scale itself. 
   
 
<br/><br/><table><tr><td><strong>ParticleData:mtRun </td><td></td><td> <input type="text" name="8" value="165.0" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>165.0</strong></code>; <code>minimum = 150.0</code>; <code>maximum = 175.0</code>)</td></tr></table>
the t quark MSbar mass at the mass scale itself. 
   
 
<br/><br/><table><tr><td><strong>ParticleData:alphaSvalueMRun </td><td></td><td> <input type="text" name="9" value="0.125" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>0.125</strong></code>; <code>minimum = 0.10</code>; <code>maximum = 0.20</code>)</td></tr></table>
the <i>alpha_s(M_Z)</i> value used to define the rate at which MSbar 
masses run. 
   
 
<h3>Comments on the data</h3> 
 
Much of the current data has been updated based on the 2012 Review of Particle 
Physics [<a href="Bibliography.php" target="page">Ber12</a>], while some is still based on the 2006 RPP 
[<a href="Bibliography.php" target="page">Yao06</a>]. All known particle masses, widths and lifetimes 
have been set accordingly, while most not-yet-measured particles are kept at 
their values from PYTHIA 6. Decay channels and their branching 
ratios remain a major worry: many particles do not have one single solidly 
measured branching ratio, and many further do not have known branching 
ratios that add up to (the neighbourhood of) unity. 
 
<p/> 
Uncertainties are especially big for the scalar, pseudovector and tensor 
<i>L = 1</i> multiplets available in PYTHIA. We note that 
some distributions become better described when these multiplets are 
included in the generation, while others become worse. It is tempting to 
associate this lackluster performance with the primitive knowledge. 
Not even the multiplets themselves are particularly well known. 
It used to be that the <i>a_0(980)</i> and <i>f_0(980)</i> 
were considered to be members of the scalar multiplet. Nowadays they are 
commonly assumed to be either four-quark states or of some other exotic 
character. This means that the PYTHIA 8 PDG particle codes 
have been changed for these particles, relative to what was used in 
PYTHIA 6 based on previous PDG editions. Specifically their 
numbers are now in the 9000000 series, and they have been replaced in the 
scalar multiplet by <i>a_0(1450)</i> and <i>f_0(1370)</i>. 
 
<p/> 
For charm and bottom mesons the jungle of partial measurements makes 
it very difficult to construct fully consistent sets of decay channels. 
This part of the program has not yet been brought up to date to the 
2006 RPP. Instead the LHCb decay tables (for EvtGen, but without 
using the EvtGen matrix-element machinery) and the DELPHI tune for 
PYTHIA 6 is being used. (This also includes a few non-c/b 
hadrons that only occur in the c/b decay tables.) This has the 
advantage that many tests have been made for consistency, but the 
disadvantage that it is not always in agreement with the latest 
measurements of some specific decay channels. The decays based 
on the LHCb tables (with some modifications) are 411, 421, 431, 441, 
445, 511, 521, 531, 541, 3124, 4122, 4124, 5122, 10441, 10443, 13122, 
14122, 20443, 23122, 30313, 30323, 30443, 33122, 100113, 100213, 100441, 
100443, 100553, 9000111, 9000211. Correspondingly the decays based on 
the DELPHI tables are 415, 425, 435, 515, 525, 535, 4132, 4232, 4332, 
5132, 5232 and 5332. 
 
<h3>The data itself</h3> 
 
Here comes the default particle data used in the program. Do not touch. 
The meaning of the various properties and the format used are explained 
<?php $filepath = $_GET["filepath"];
echo "<a href='ParticleDataScheme.php?filepath=".$filepath."' target='page'>";?>here</a> and the 
<code>meMode</code> codes <?php $filepath = $_GET["filepath"];
echo "<a href='ParticleDecays.php?filepath=".$filepath."' target='page'>";?>here</a>. 
 
<p/>particle: id="0" name="void" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="1" name="d" antiName="dbar" spinType="2" chargeType="-1" colType="1" 
          m0="0.33000" 
 
<p/>particle: id="2" name="u" antiName="ubar" spinType="2" chargeType="2" colType="1" 
          m0="0.33000" 
 
<p/>particle: id="3" name="s" antiName="sbar" spinType="2" chargeType="-1" colType="1" 
          m0="0.50000" 
 
<p/>particle: id="4" name="c" antiName="cbar" spinType="2" chargeType="2" colType="1" 
          m0="1.50000" 
 
<p/>particle: id="5" name="b" antiName="bbar" spinType="2" chargeType="-1" colType="1" 
          m0="4.80000" 
 
<p/>particle: id="6" name="t" antiName="tbar" spinType="2" chargeType="2" colType="1" 
          m0="171.00000" mWidth="1.40000" mMin="86.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="24 1" 
 <br/>      channel: onMode="1" bRatio="0.0017650" products="24 3" 
 <br/>      channel: onMode="1" bRatio="0.9982050" products="24 5" 
 <br/>      channel: onMode="0" bRatio="0.0000000" products="37 5" 
 
<p/>particle: id="7" name="b'" antiName="b'bar" spinType="2" chargeType="-1" colType="1" 
          m0="400.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-24 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-24 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-24 6" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="-24 8" 
 
<p/>particle: id="8" name="t'" antiName="t'bar" spinType="2" chargeType="2" colType="1" 
          m0="400.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="24 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="24 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="24 5" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="24 7" 
 
<p/>particle: id="11" name="e-" antiName="e+" spinType="2" chargeType="-3" colType="0" 
          m0="5.110e-04" 
 
<p/>particle: id="12" name="nu_e" antiName="nu_ebar" spinType="2" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="13" name="mu-" antiName="mu+" spinType="2" chargeType="-3" colType="0" 
          m0="0.10566" tau0="6.58654e+05" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="22" products="-12 11 14" 
 
<p/>particle: id="14" name="nu_mu" antiName="nu_mubar" spinType="2" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="15" name="tau-" antiName="tau+" spinType="2" chargeType="-3" colType="0" 
          m0="1.77682" tau0="8.71100e-02" 
 <br/>      channel: onMode="1" bRatio="0.1076825" meMode="1521" products="16 -211" 
 <br/>      channel: onMode="1" bRatio="0.0069601" meMode="1521" products="16 -321" 
 <br/>      channel: onMode="1" bRatio="0.1772832" meMode="1531" products="16 11 -12" 
 <br/>      channel: onMode="1" bRatio="0.1731072" meMode="1531" products="16 13 -14" 
 <br/>      channel: onMode="1" bRatio="0.2537447" meMode="1532" products="16 111 -211" 
 <br/>      channel: onMode="1" bRatio="0.0015809" meMode="1532" products="16 311 -321" 
 <br/>      channel: onMode="1" bRatio="0.0001511" meMode="1532" products="16 221 -321" 
 <br/>      channel: onMode="1" bRatio="0.0083521" meMode="1533" products="16 -211 -311" 
 <br/>      channel: onMode="1" bRatio="0.0042655" meMode="1533" products="16 111 -321" 
 <br/>      channel: onMode="1" bRatio="0.0924697" meMode="1541" products="16 111 111 -211" 
 <br/>      channel: onMode="1" bRatio="0.0925691" meMode="1541" products="16 -211 -211 211" 
 <br/>      channel: onMode="1" bRatio="0.0039772" meMode="1542" products="16 111 -211 -311" 
 <br/>      channel: onMode="1" bRatio="0.0034701" meMode="1542" products="16 -211 211 -321" 
 <br/>      channel: onMode="1" bRatio="0.0014318" meMode="1542" products="16 -211 -321 321" 
 <br/>      channel: onMode="1" bRatio="0.0015809" meMode="1542" products="16 111 311 -321" 
 <br/>      channel: onMode="1" bRatio="0.0011932" meMode="1542" products="16 130 -211 310" 
 <br/>      channel: onMode="1" bRatio="0.0006463" meMode="1542" products="16 111 111 -321" 
 <br/>      channel: onMode="1" bRatio="0.0002386" meMode="1542" products="16 130 130 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002386" meMode="1542" products="16 -211 310 310" 
 <br/>      channel: onMode="1" bRatio="0.0013821" meMode="1543" products="16 111 -211 221" 
 <br/>      channel: onMode="1" bRatio="0.0017520" meMode="1544" products="16 22 111 -211" 
 <br/>      channel: onMode="1" bRatio="0.0459365" meMode="1551" products="16 111 -211 -211 211" 
 <br/>      channel: onMode="1" bRatio="0.0104401" meMode="1551" products="16 111 111 111 -211" 
 <br/>      channel: onMode="1" bRatio="0.0049069" meMode="1561" products="16 111 111 -211 -211 211" 
 <br/>      channel: onMode="1" bRatio="0.0009515" meMode="1561" products="16 111 111 111 111 -211" 
 <br/>      channel: onMode="1" bRatio="0.0008342" meMode="1561" products="16 -211 -211 -211 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0001631" meMode="0" products="16 -211 -211 211 221" 
 <br/>      channel: onMode="1" bRatio="0.0001491" meMode="0" products="16 111 111 -211 221" 
 <br/>      channel: onMode="1" bRatio="0.0001392" meMode="0" products="16 111 111 -211 223" 
 <br/>      channel: onMode="1" bRatio="0.0001193" meMode="0" products="16 -211 -211 211 223" 
 <br/>      channel: onMode="1" bRatio="0.0004077" meMode="0" products="16 223 -321" 
 <br/>      channel: onMode="1" bRatio="0.0004773" meMode="0" products="16 111 111 111 -321" 
 <br/>      channel: onMode="1" bRatio="0.0003052" meMode="0" products="16 111 -211 211 -321" 
 <br/>      channel: onMode="1" bRatio="0.0002784" meMode="0" products="16 221 -323" 
 <br/>      channel: onMode="1" bRatio="0.0002366" meMode="0" products="16 111 111 -211 -311" 
 <br/>      channel: onMode="1" bRatio="0.0002237" meMode="0" products="16 -211 -211 211 -311" 
 <br/>      channel: onMode="1" bRatio="0.0002953" meMode="0" products="16 111 -211 -311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000590" meMode="0" products="16 111 -211 -321 321" 
 
<p/>particle: id="16" name="nu_tau" antiName="nu_taubar" spinType="2" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="17" name="tau'-" antiName="tau'+" spinType="2" chargeType="-3" colType="0" 
          m0="400.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="-24 18" 
 
<p/>particle: id="18" name="nu'_tau" antiName="nu'_taubar" spinType="2" chargeType="0" colType="0" 
          m0="400.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="24 17" 
 
<p/>particle: id="21" name="g" spinType="3" chargeType="0" colType="2" 
          m0="0.00000" 
 
<p/>particle: id="22" name="gamma" spinType="3" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="23" name="Z0" spinType="3" chargeType="0" colType="0" 
          m0="91.18760" mWidth="2.49520" mMin="10.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.1539950" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.1194200" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.1539840" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.1192590" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.1522720" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0335760" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0668060" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0335760" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0668060" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0335000" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0668060" products="16 -16" 
 
<p/>particle: id="24" name="W+" antiName="W-" spinType="3" chargeType="3" colType="0" 
          m0="80.38500" mWidth="2.08500" mMin="10.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.3213690" products="-1 2" 
 <br/>      channel: onMode="1" bRatio="0.0164940" products="-1 4" 
 <br/>      channel: onMode="1" bRatio="0.0165020" products="-3 2" 
 <br/>      channel: onMode="1" bRatio="0.3206150" products="-3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-5 2" 
 <br/>      channel: onMode="1" bRatio="0.0005910" products="-5 4" 
 <br/>      channel: onMode="1" bRatio="0.1081660" products="-11 12" 
 <br/>      channel: onMode="1" bRatio="0.1081660" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.1080870" products="-15 16" 
 
<p/>particle: id="25" name="h0" spinType="1" chargeType="0" colType="0" 
          m0="125.00000" mWidth="0.00374" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000009" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0002361" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0335602" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.5876728" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0002445" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0690800" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0630585" products="21 21" 
 <br/>      channel: onMode="1" bRatio="0.0028438" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.0017601" products="22 23" 
 <br/>      channel: onMode="1" bRatio="0.0259708" products="23 23" 
 <br/>      channel: onMode="1" bRatio="0.2155720" products="24 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000022 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000023 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000023 1000023" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000023" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000025" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000023" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000025" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000035" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000024 -1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000024 -1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000037 -1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000037 -1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000001 -1000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000001 -2000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000001 -2000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000001 2000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000002 -1000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000002 -2000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000002 -2000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000002 2000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000003 -1000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000003 -2000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000003 -2000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000003 2000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000004 -1000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000004 -2000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000004 -2000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000004 2000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000005 -1000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000005 -2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000005 -2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000005 2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000006 -1000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000006 -2000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000006 -2000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000006 2000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000011 -1000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000011 -2000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000011 -2000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000011 2000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000012 -1000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000012 -2000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000012 -2000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000012 2000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000013 -1000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000013 -2000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000013 -2000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000013 2000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000014 -1000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000014 -2000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000014 -2000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000014 2000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000015 -1000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000015 -2000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000015 -2000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000015 2000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000016 -1000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000016 -2000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000016 -2000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000016 2000016" 
 
<p/>particle: id="32" name="Z'0" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" mWidth="14.54029" mMin="10.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.1458350" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.1132760" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.1458350" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.1132710" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.1457810" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0490020" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="7 -7" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="8 -8" 
 <br/>      channel: onMode="1" bRatio="0.0320250" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0636420" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0320250" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0636420" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0320220" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0636420" products="16 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="17 -17" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="18 -18" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="24 -24" 
 
<p/>particle: id="33" name="Z''0" spinType="3" chargeType="0" colType="0" 
          m0="900.00000" 
 
<p/>particle: id="34" name="W'+" antiName="W'-" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" mWidth="16.66099" mMin="10.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.2512250" products="-1 2" 
 <br/>      channel: onMode="1" bRatio="0.0129000" products="-1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="-1 6" 
 <br/>      channel: onMode="1" bRatio="0.0129000" products="-3 2" 
 <br/>      channel: onMode="1" bRatio="0.2507640" products="-3 4" 
 <br/>      channel: onMode="1" bRatio="0.0003800" products="-3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000080" products="-5 2" 
 <br/>      channel: onMode="1" bRatio="0.0004650" products="-5 4" 
 <br/>      channel: onMode="1" bRatio="0.2154180" products="-5 6" 
 <br/>      channel: onMode="1" bRatio="0.0853120" products="-11 12" 
 <br/>      channel: onMode="1" bRatio="0.0853120" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.0853100" products="-15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="24 23" 
 
<p/>particle: id="35" name="H0" spinType="1" chargeType="0" colType="0" 
          m0="300.00000" mWidth="8.38842" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000490" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0007740" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000740" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0004170" products="21 21" 
 <br/>      channel: onMode="1" bRatio="0.0000150" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.0000610" products="22 23" 
 <br/>      channel: onMode="1" bRatio="0.3067100" products="23 23" 
 <br/>      channel: onMode="1" bRatio="0.6890110" products="24 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="23 25" 
 <br/>      channel: onMode="1" bRatio="0.0028890" products="25 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="24 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="37 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="23 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="25 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="36 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000022 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000023 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000023 1000023" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000023" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000025" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000023" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000025" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000035" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000024 -1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000024 -1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000037 -1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000037 -1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000001 -1000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000001 -2000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000001 -2000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000001 2000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000002 -1000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000002 -2000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000002 -2000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000002 2000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000003 -1000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000003 -2000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000003 -2000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000003 2000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000004 -1000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000004 -2000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000004 -2000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000004 2000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000005 -1000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000005 -2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000005 -2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000005 2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000006 -1000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000006 -2000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000006 -2000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000006 2000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000011 -1000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000011 -2000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000011 -2000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000011 2000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000012 -1000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000012 -2000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000012 -2000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000012 2000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000013 -1000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000013 -2000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000013 -2000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000013 2000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000014 -1000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000014 -2000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000014 -2000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000014 2000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000015 -1000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000015 -2000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000015 -2000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000015 2000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000016 -1000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000016 -2000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000016 -2000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000016 2000016" 
 
<p/>particle: id="36" name="A0" spinType="1" chargeType="0" colType="0" 
          m0="300.00000" mWidth="3.37520" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0001210" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0019240" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0001840" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0031060" products="21 21" 
 <br/>      channel: onMode="1" bRatio="0.0000150" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="22 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="23 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="24 -24" 
 <br/>      channel: onMode="1" bRatio="0.9946460" products="23 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="25 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="24 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="37 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000022 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000023 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000023 1000023" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000023" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000025" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000022" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000023" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000025" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000035" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000024 -1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000024 -1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000037 -1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000037 -1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000001 -1000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000001 -2000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000001 -2000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000001 2000001" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000002 -1000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000002 -2000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000002 -2000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000002 2000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000003 -1000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000003 -2000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000003 -2000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000003 2000003" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000004 -1000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000004 -2000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000004 -2000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000004 2000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000005 -1000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000005 -2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000005 -2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000005 2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000006 -1000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000006 -2000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000006 -2000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000006 2000006" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000011 -1000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000011 -2000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000011 -2000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000011 2000011" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000012 -1000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000012 -2000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000012 -2000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000012 2000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000013 -1000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000013 -2000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000013 -2000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000013 2000013" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000014 -1000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000014 -2000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000014 -2000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000014 2000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000015 -1000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000015 -2000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000015 -2000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000015 2000015" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000016 -1000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000016 -2000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000016 -2000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000016 2000016" 
 
<p/>particle: id="37" name="H+" antiName="H-" spinType="1" chargeType="3" colType="0" 
          m0="300.00000" mWidth="4.17669" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000210" products="-3 4" 
 <br/>      channel: onMode="1" bRatio="0.0901350" products="-5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000130" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.0037140" products="-15 16" 
 <br/>      channel: onMode="1" bRatio="0.9061170" products="24 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000022 1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000022 1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000023 1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000023 1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000025 1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000024" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000035 1000037" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000006 -1000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000006 -1000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000006 -2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="2000006 -2000005" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000001 1000002" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000003 1000004" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000011 1000012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000013 1000014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-1000015 1000016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="-2000015 1000016" 
 
<p/>particle: id="39" name="Graviton" spinType="5" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="40" name="BlackHole" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="41" name="R0" antiName="Rbar0" spinType="3" chargeType="0" colType="0" 
          m0="5.000e+03" mWidth="4.173e+02" mMin="1.000e+02" mMax="0.000e+00" 
 <br/>      channel: onMode="1" bRatio="0.2151190" products="1 -3" 
 <br/>      channel: onMode="1" bRatio="0.2151190" products="2 -4" 
 <br/>      channel: onMode="1" bRatio="0.2151190" products="3 -5" 
 <br/>      channel: onMode="1" bRatio="0.2147240" products="4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0699600" products="11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0699590" products="13 -15" 
 
<p/>particle: id="42" name="LQ_ue" antiName="LQ_uebar" spinType="1" chargeType="-1" colType="1" 
          m0="200.00000" mWidth="0.39162" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="2 11" 
 
<p/>particle: id="45" name="H_3" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" 
 
<p/>particle: id="46" name="A_2" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" 
 
<p/>particle: id="51" name="DM(s=0)" antiName="DMbar(s=0)" spinType="1" chargeType="0" colType="0" 
          m0="100.00000" 
 
<p/>particle: id="52" name="DM(s=1/2)" antiName="DMbar(s=1/2)" spinType="2" chargeType="0" colType="0" 
          m0="100.00000" 
 
<p/>particle: id="53" name="DM(s=1)" antiName="DMbar(s=1)" spinType="3" chargeType="0" colType="0" 
          m0="100.00000" 
 
<p/>particle: id="54" name="DMmed(s=0)" antiName="DMmedbar(s=0)" spinType="1" chargeType="0" colType="0" 
          m0="100.00000" mWidth="0.1" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products=" 1  -1" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products=" 2  -2" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products=" 3  -3" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products=" 4  -4" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products=" 5  -5" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products=" 6  -6" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="16 -16" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="101" products="21  21" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="101" products="22  22" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="22  23" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="23  23" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="24 -24" 
 <br/>      channel: onMode="1" bRatio="0.050" meMode="101" products="25  25" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="101" products="51 -51" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="101" products="51  51" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="101" products="52 -52" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="101" products="52  52" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="101" products="53 -53" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="101" products="53  53" 
 
<p/>particle: id="55" name="DMmed(s=1)" antiName="DMmedbar(s=1)" spinType="3" chargeType="0" colType="0" 
          m0="100.00000" mWidth="0.1" 
 <br/>      channel: onMode="1" bRatio="0.050" products=" 1  -1" 
 <br/>      channel: onMode="1" bRatio="0.050" products=" 2  -2" 
 <br/>      channel: onMode="1" bRatio="0.050" products=" 3  -3" 
 <br/>      channel: onMode="1" bRatio="0.050" products=" 4  -4" 
 <br/>      channel: onMode="1" bRatio="0.050" products=" 5  -5" 
 <br/>      channel: onMode="1" bRatio="0.050" products=" 6  -6" 
 <br/>      channel: onMode="1" bRatio="0.050" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.050" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.050" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.050" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.050" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.050" products="16 -16" 
 <br/>      channel: onMode="1" bRatio="0.025" products="21  21" 
 <br/>      channel: onMode="1" bRatio="0.025" products="22  22" 
 <br/>      channel: onMode="1" bRatio="0.050" products="22  23" 
 <br/>      channel: onMode="1" bRatio="0.050" products="23  23" 
 <br/>      channel: onMode="1" bRatio="0.050" products="24 -24" 
 <br/>      channel: onMode="1" bRatio="0.050" products="25  25" 
 <br/>      channel: onMode="1" bRatio="0.025" products="51 -51" 
 <br/>      channel: onMode="1" bRatio="0.025" products="51  51" 
 <br/>      channel: onMode="1" bRatio="0.025" products="52 -52" 
 <br/>      channel: onMode="1" bRatio="0.025" products="52  52" 
 <br/>      channel: onMode="1" bRatio="0.025" products="53 -53" 
 <br/>      channel: onMode="1" bRatio="0.025" products="53  53" 
 
<p/>particle: id="56" name="DM?1" antiName="DMbar?1" spinType="1" chargeType="0" colType="0" 
          m0="100.00000" 
 
<p/>particle: id="57" name="DM?2" antiName="DMbar?1" spinType="1" chargeType="0" colType="0" 
          m0="100.00000" 
 
<p/>particle: id="58" name="DM?3" antiName="DMbar?3" spinType="1" chargeType="0" colType="0" 
          m0="100.00000" 
 
<p/>particle: id="59" name="DM?4" antiName="DMbar?4" spinType="1" chargeType="0" colType="0" 
          m0="100.00000" 
 
<p/>particle: id="60" name="DM?5" antiName="DMbar?5" spinType="1" chargeType="0" colType="0" 
          m0="100.00000" 
 
<p/>particle: id="81" name="specflav" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="82" name="rndmflavq" antiName="rndmflavqbar" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="83" name="rndmflavg" antiName="rndmflavgbar" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="90" name="system" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="93" name="Z0copy" spinType="3" chargeType="0" colType="0" 
          m0="91.18760" mWidth="2.49520" mMin="10.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.1539950" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.1194200" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.1539840" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.1192590" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.1522720" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0335760" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0668060" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0335760" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0668060" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0335000" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0668060" products="16 -16" 
 
<p/>particle: id="94" name="W+copy" antiName="W-copy" spinType="3" chargeType="3" colType="0" 
          m0="80.38500" mWidth="2.08500" mMin="10.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.3213690" products="-1 2" 
 <br/>      channel: onMode="1" bRatio="0.0164940" products="-1 4" 
 <br/>      channel: onMode="1" bRatio="0.0165020" products="-3 2" 
 <br/>      channel: onMode="1" bRatio="0.3206150" products="-3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-5 2" 
 <br/>      channel: onMode="1" bRatio="0.0005910" products="-5 4" 
 <br/>      channel: onMode="1" bRatio="0.1081660" products="-11 12" 
 <br/>      channel: onMode="1" bRatio="0.1081660" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.1080870" products="-15 16" 
 
<p/>particle: id="110" name="Reggeon" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="111" name="pi0" spinType="1" chargeType="0" colType="0" 
          m0="0.13498" tau0="2.55313e-05" 
 <br/>      channel: onMode="1" bRatio="0.9879900" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.0119800" meMode="11" products="22 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000300" meMode="13" products="11 -11 11 -11" 
 
<p/>particle: id="113" name="rho0" spinType="3" chargeType="0" colType="0" 
          m0="0.77549" mWidth="0.14910" mMin="0.30000" mMax="1.50000" 
 <br/>      channel: onMode="1" bRatio="0.9988447" meMode="2" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0005993" products="111 22" 
 <br/>      channel: onMode="1" bRatio="0.0002997" products="221 22" 
 <br/>      channel: onMode="1" bRatio="0.0001009" meMode="1" products="211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000471" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000454" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000449" products="111 111 22" 
 <br/>      channel: onMode="1" bRatio="0.0000180" products="211 -211 211 -211" 
 
<p/>particle: id="115" name="a_20" spinType="5" chargeType="0" colType="0" 
          m0="1.31830" mWidth="0.10700" mMin="1.00000" mMax="1.70000" 
 <br/>      channel: onMode="1" bRatio="0.3483455" products="213 -211" 
 <br/>      channel: onMode="1" bRatio="0.3483455" products="-213 211" 
 <br/>      channel: onMode="1" bRatio="0.1440000" products="221 111" 
 <br/>      channel: onMode="1" bRatio="0.1050000" products="223 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0245000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0122500" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0122500" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.0053000" products="331 111" 
 <br/>      channel: onMode="1" bRatio="0.0000090" products="22 22" 
 
<p/>particle: id="130" name="K_L0" spinType="1" chargeType="0" colType="0" 
          m0="0.49761" tau0="1.53300e+04" 
 <br/>      channel: onMode="1" bRatio="0.1952278" products="111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.1254178" products="211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.2027688" meMode="22" products="-12 11 211" 
 <br/>      channel: onMode="1" bRatio="0.2027688" meMode="22" products="12 -11 -211" 
 <br/>      channel: onMode="1" bRatio="0.1352191" meMode="22" products="-14 13 211" 
 <br/>      channel: onMode="1" bRatio="0.1352191" meMode="22" products="14 -13 -211" 
 <br/>      channel: onMode="1" bRatio="0.0019673" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0008641" products="111 111" 
 <br/>      channel: onMode="1" bRatio="0.0005471" products="22 22" 
 
<p/>particle: id="211" name="pi+" antiName="pi-" spinType="1" chargeType="3" colType="0" 
          m0="0.13957" tau0="7.80450e+03" 
 <br/>      channel: onMode="1" bRatio="0.9998770" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.0001230" products="-11 12" 
 
<p/>particle: id="213" name="rho+" antiName="rho-" spinType="3" chargeType="3" colType="0" 
          m0="0.77549" mWidth="0.14910" mMin="0.30000" mMax="1.50000" 
 <br/>      channel: onMode="1" bRatio="0.9995502" meMode="2" products="211 111" 
 <br/>      channel: onMode="1" bRatio="0.0004498" products="211 22" 
 
<p/>particle: id="215" name="a_2+" antiName="a_2-" spinType="5" chargeType="3" colType="0" 
          m0="1.31830" mWidth="0.10700" mMin="1.00000" mMax="1.70000" 
 <br/>      channel: onMode="1" bRatio="0.3480100" products="213 111" 
 <br/>      channel: onMode="1" bRatio="0.3480100" products="113 211" 
 <br/>      channel: onMode="1" bRatio="0.1440000" products="221 211" 
 <br/>      channel: onMode="1" bRatio="0.1040000" products="223 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0480000" products="321 -311" 
 <br/>      channel: onMode="1" bRatio="0.0053000" products="331 211" 
 <br/>      channel: onMode="1" bRatio="0.0026800" products="211 22" 
 
<p/>particle: id="221" name="eta" spinType="1" chargeType="0" colType="0" 
          m0="0.54785" 
 <br/>      channel: onMode="1" bRatio="0.3931181" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.3257150" products="111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002700" products="111 22 22" 
 <br/>      channel: onMode="1" bRatio="0.2274105" products="211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0460021" products="211 -211 22" 
 <br/>      channel: onMode="1" bRatio="0.0069003" meMode="11" products="22 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0003100" meMode="11" products="22 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0002680" meMode="12" products="211 -211 11 -11" 
 
<p/>particle: id="223" name="omega" spinType="3" chargeType="0" colType="0" 
          m0="0.78265" mWidth="0.00849" mMin="0.50000" mMax="1.10000" 
 <br/>      channel: onMode="1" bRatio="0.8994773" meMode="1" products="211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0834941" products="111 22" 
 <br/>      channel: onMode="1" bRatio="0.0154283" meMode="2" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0004639" products="221 22" 
 <br/>      channel: onMode="1" bRatio="0.0007765" meMode="11" products="111 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0001311" meMode="11" products="111 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000728" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000900" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000660" products="111 111 22" 
 
<p/>particle: id="225" name="f_2" spinType="5" chargeType="0" colType="0" 
          m0="1.27510" mWidth="0.18510" mMin="0.60000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.5653260" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.2826600" products="111 111" 
 <br/>      channel: onMode="1" bRatio="0.0710000" products="211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0280000" products="211 -211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0115000" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0115000" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="221 221" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="111 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000140" products="22 22" 
 
<p/>particle: id="310" name="K_S0" spinType="1" chargeType="0" colType="0" 
          m0="0.49761" tau0="2.68420e+01" 
 <br/>      channel: onMode="1" bRatio="0.6922420" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.3070073" products="111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000479" meMode="12" products="211 -211 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0003501" meMode="22" products="-12 11 211" 
 <br/>      channel: onMode="1" bRatio="0.0003501" meMode="22" products="12 -11 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000026" products="22 22" 
 
<p/>particle: id="311" name="K0" antiName="Kbar0" spinType="1" chargeType="0" colType="0" 
          m0="0.49761" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="130" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="310" 
 
<p/>particle: id="313" name="K*0" antiName="K*bar0" spinType="3" chargeType="0" colType="0" 
          m0="0.89594" mWidth="0.04870" mMin="0.65000" mMax="1.20000" 
 <br/>      channel: onMode="1" bRatio="0.6649467" meMode="2" products="321 -211" 
 <br/>      channel: onMode="1" bRatio="0.3326633" meMode="2" products="311 111" 
 <br/>      channel: onMode="1" bRatio="0.0023900" products="311 22" 
 
<p/>particle: id="315" name="K*_2(1430)0" antiName="K*_2(1430)bar0" spinType="5" chargeType="0" colType="0" 
          m0="1.43240" mWidth="0.10900" mMin="1.10000" mMax="1.80000" 
 <br/>      channel: onMode="1" bRatio="0.3335002" products="321 -211" 
 <br/>      channel: onMode="1" bRatio="0.1667502" products="311 111" 
 <br/>      channel: onMode="1" bRatio="0.1650794" products="323 -211" 
 <br/>      channel: onMode="1" bRatio="0.0825397" products="313 111" 
 <br/>      channel: onMode="1" bRatio="0.0892231" products="323 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0451128" products="313 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0581454" products="321 -213" 
 <br/>      channel: onMode="1" bRatio="0.0290727" products="311 113" 
 <br/>      channel: onMode="1" bRatio="0.0290727" products="311 223" 
 <br/>      channel: onMode="1" bRatio="0.0015038" products="311 221" 
 
<p/>particle: id="321" name="K+" antiName="K-" spinType="1" chargeType="3" colType="0" 
          m0="0.49368" tau0="3.71300e+03" 
 <br/>      channel: onMode="1" bRatio="0.6355250" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000158" products="-11 12" 
 <br/>      channel: onMode="1" bRatio="0.2066081" products="211 111" 
 <br/>      channel: onMode="1" bRatio="0.0559022" products="211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0176107" products="211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0507020" meMode="22" products="12 -11 111" 
 <br/>      channel: onMode="1" bRatio="0.0335313" meMode="22" products="14 -13 111" 
 <br/>      channel: onMode="1" bRatio="0.0000220" products="-11 12 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000409" products="-11 12 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000140" products="-13 14 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000280" products="-13 14 211 -211" 
 
<p/>particle: id="323" name="K*+" antiName="K*-" spinType="3" chargeType="3" colType="0" 
          m0="0.89166" mWidth="0.05080" mMin="0.65000" mMax="1.20000" 
 <br/>      channel: onMode="1" bRatio="0.6660067" meMode="2" products="311 211" 
 <br/>      channel: onMode="1" bRatio="0.3330033" meMode="2" products="321 111" 
 <br/>      channel: onMode="1" bRatio="0.0009900" products="321 22" 
 
<p/>particle: id="325" name="K*_2(1430)+" antiName="K*_2(1430)-" spinType="5" chargeType="3" colType="0" 
          m0="1.42560" mWidth="0.09850" mMin="1.10000" mMax="1.80000" 
 <br/>      channel: onMode="1" bRatio="0.3330333" products="311 211" 
 <br/>      channel: onMode="1" bRatio="0.1660166" products="321 111" 
 <br/>      channel: onMode="1" bRatio="0.1646498" products="313 211" 
 <br/>      channel: onMode="1" bRatio="0.0823749" products="323 111" 
 <br/>      channel: onMode="1" bRatio="0.0890089" products="313 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0450045" products="323 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0580058" products="311 213" 
 <br/>      channel: onMode="1" bRatio="0.0290029" products="321 113" 
 <br/>      channel: onMode="1" bRatio="0.0290029" products="321 223" 
 <br/>      channel: onMode="1" bRatio="0.0015002" products="321 221" 
 <br/>      channel: onMode="1" bRatio="0.0024002" products="321 22" 
 
<p/>particle: id="331" name="eta'" spinType="1" chargeType="0" colType="0" 
          m0="0.95778" mWidth="0.00020" mMin="0.95578" mMax="0.95978" 
 <br/>      channel: onMode="1" bRatio="0.4365815" products="211 -211 221" 
 <br/>      channel: onMode="1" bRatio="0.2947428" products="113 22" 
 <br/>      channel: onMode="1" bRatio="0.2172848" products="111 111 221" 
 <br/>      channel: onMode="1" bRatio="0.0276636" products="223 22" 
 <br/>      channel: onMode="1" bRatio="0.0219297" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.0016900" products="111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0001076" products="13 -13 22" 
 
<p/>particle: id="333" name="phi" spinType="3" chargeType="0" colType="0" 
          m0="1.01946" mWidth="0.00426" mMin="1.00000" mMax="1.04000" 
 <br/>      channel: onMode="1" bRatio="0.4893042" meMode="2" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.3422127" meMode="2" products="130 310" 
 <br/>      channel: onMode="1" bRatio="0.0420984" products="-213 211" 
 <br/>      channel: onMode="1" bRatio="0.0420984" products="113 111" 
 <br/>      channel: onMode="1" bRatio="0.0420984" products="213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0270000" meMode="1" products="211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0130981" products="221 22" 
 <br/>      channel: onMode="1" bRatio="0.0012708" products="111 22" 
 <br/>      channel: onMode="1" bRatio="0.0002956" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0002872" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0001151" meMode="11" products="221 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000740" meMode="2" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000470" products="223 111" 
 
<p/>particle: id="335" name="f'_2(1525)" spinType="5" chargeType="0" colType="0" 
          m0="1.52500" mWidth="0.07300" mMin="1.10000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.4444000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.2222000" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.2222000" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.1030000" products="221 221" 
 <br/>      channel: onMode="1" bRatio="0.0041000" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0041000" products="111 111" 
 
<p/>particle: id="411" name="D+" antiName="D-" spinType="1" chargeType="3" colType="0" 
          m0="1.86962" tau0="3.11800e-01" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-15 16" 
 <br/>      channel: onMode="1" bRatio="0.0043000" meMode="22" products="-11 12 111" 
 <br/>      channel: onMode="1" bRatio="0.0028000" meMode="22" products="-11 12 113" 
 <br/>      channel: onMode="1" bRatio="0.0026000" meMode="22" products="-11 12 221" 
 <br/>      channel: onMode="1" bRatio="0.0028000" meMode="22" products="-11 12 223" 
 <br/>      channel: onMode="1" bRatio="0.0900000" meMode="22" products="-11 12 311" 
 <br/>      channel: onMode="1" bRatio="0.0554000" meMode="22" products="-11 12 -313" 
 <br/>      channel: onMode="1" bRatio="0.0038000" meMode="22" products="-11 12 -315" 
 <br/>      channel: onMode="1" bRatio="0.0005000" meMode="22" products="-11 12 331" 
 <br/>      channel: onMode="1" bRatio="0.0036000" meMode="22" products="-11 12 -10313" 
 <br/>      channel: onMode="1" bRatio="0.0043000" meMode="22" products="-13 14 111" 
 <br/>      channel: onMode="1" bRatio="0.0028000" meMode="22" products="-13 14 113" 
 <br/>      channel: onMode="1" bRatio="0.0026000" meMode="22" products="-13 14 221" 
 <br/>      channel: onMode="1" bRatio="0.0028000" meMode="22" products="-13 14 223" 
 <br/>      channel: onMode="1" bRatio="0.0874000" meMode="22" products="-13 14 311" 
 <br/>      channel: onMode="1" bRatio="0.0533000" meMode="22" products="-13 14 -313" 
 <br/>      channel: onMode="1" bRatio="0.0038000" meMode="22" products="-13 14 -315" 
 <br/>      channel: onMode="1" bRatio="0.0005000" meMode="22" products="-13 14 331" 
 <br/>      channel: onMode="1" bRatio="0.0036000" meMode="22" products="-13 14 -10313" 
 <br/>      channel: onMode="1" bRatio="0.0014000" meMode="22" products="-11 12 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0027000" meMode="22" products="-11 12 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0014000" meMode="22" products="-13 14 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0027000" meMode="22" products="-13 14 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0026000" products="211 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="211 113" 
 <br/>      channel: onMode="1" bRatio="0.0076000" products="221 211" 
 <br/>      channel: onMode="1" bRatio="0.0282000" products="311 211" 
 <br/>      channel: onMode="1" bRatio="0.0210000" products="-313 213" 
 <br/>      channel: onMode="1" bRatio="0.0074000" products="321 311" 
 <br/>      channel: onMode="1" bRatio="0.0042000" products="321 -313" 
 <br/>      channel: onMode="1" bRatio="0.0310000" products="323 311" 
 <br/>      channel: onMode="1" bRatio="0.0180000" products="323 -313" 
 <br/>      channel: onMode="1" bRatio="0.0070000" products="333 211" 
 <br/>      channel: onMode="1" bRatio="0.0115000" products="-10311 211" 
 <br/>      channel: onMode="1" bRatio="0.0800000" products="20213 311" 
 <br/>      channel: onMode="1" bRatio="0.0508000" products="-20313 211" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0970000" products="311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="311 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="311 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="311 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="313 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="-313 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0078000" products="-313 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="-313 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-313 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-313 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="321 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="321 -313 111" 
 <br/>      channel: onMode="1" bRatio="0.0046000" products="321 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0920000" products="-321 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0110000" products="-321 213 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="323 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="323 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0070000" products="-323 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="-323 213 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-323 321 211" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="333 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0090000" products="211 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="221 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="221 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0188000" products="311 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0120000" products="-321 211 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0021000" products="211 211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0035000" products="311 211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0087000" products="311 211 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-321 211 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="-321 211 211 211 -211" 
 
<p/>particle: id="413" name="D*+" antiName="D*-" spinType="3" chargeType="3" colType="0" 
          m0="2.01028" 
 <br/>      channel: onMode="1" bRatio="0.6770000" meMode="2" products="421 211" 
 <br/>      channel: onMode="1" bRatio="0.3070000" meMode="2" products="411 111" 
 <br/>      channel: onMode="1" bRatio="0.0160000" products="411 22" 
 
<p/>particle: id="415" name="D*_2(2460)+" antiName="D*_2(2460)-" spinType="5" chargeType="3" colType="0" 
          m0="2.46440" mWidth="0.03700" mMin="2.30000" mMax="2.65000" 
 <br/>      channel: onMode="1" bRatio="0.2200000" products="423 211" 
 <br/>      channel: onMode="1" bRatio="0.1100000" products="413 111" 
 <br/>      channel: onMode="1" bRatio="0.3800000" products="421 211" 
 <br/>      channel: onMode="1" bRatio="0.1900000" products="411 111" 
 <br/>      channel: onMode="1" bRatio="0.0670000" products="423 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0330000" products="413 211 -211" 
 
<p/>particle: id="421" name="D0" antiName="Dbar0" spinType="1" chargeType="0" colType="0" 
          m0="1.86486" tau0="1.22900e-01" 
 <br/>      channel: onMode="1" bRatio="0.0034000" meMode="22" products="-11 12 -211" 
 <br/>      channel: onMode="1" bRatio="0.0022000" meMode="22" products="-11 12 -213" 
 <br/>      channel: onMode="1" bRatio="0.0350000" meMode="22" products="-11 12 -321" 
 <br/>      channel: onMode="1" bRatio="0.0225000" meMode="22" products="-11 12 -323" 
 <br/>      channel: onMode="1" bRatio="0.0015000" meMode="22" products="-11 12 -325" 
 <br/>      channel: onMode="1" bRatio="0.0014000" meMode="22" products="-11 12 -10323" 
 <br/>      channel: onMode="1" bRatio="0.0034000" meMode="22" products="-13 14 -211" 
 <br/>      channel: onMode="1" bRatio="0.0022000" meMode="22" products="-13 14 -213" 
 <br/>      channel: onMode="1" bRatio="0.0340000" meMode="22" products="-13 14 -321" 
 <br/>      channel: onMode="1" bRatio="0.0214000" meMode="22" products="-13 14 -323" 
 <br/>      channel: onMode="1" bRatio="0.0015000" meMode="22" products="-13 14 -325" 
 <br/>      channel: onMode="1" bRatio="0.0014000" meMode="22" products="-13 14 -10323" 
 <br/>      channel: onMode="1" bRatio="0.0011000" meMode="22" products="-11 12 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0006000" meMode="22" products="-11 12 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0011000" meMode="22" products="-13 14 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0006000" meMode="22" products="-13 14 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="111 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="113 111" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="-213 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="221 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="221 221" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.0212000" products="311 111" 
 <br/>      channel: onMode="1" bRatio="0.0071000" products="311 221" 
 <br/>      channel: onMode="1" bRatio="0.0210000" products="311 223" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="313 311" 
 <br/>      channel: onMode="1" bRatio="0.0014000" products="313 -313" 
 <br/>      channel: onMode="1" bRatio="0.0085000" products="-313 111" 
 <br/>      channel: onMode="1" bRatio="0.0146000" products="-313 113" 
 <br/>      channel: onMode="1" bRatio="0.0190000" products="-313 221" 
 <br/>      channel: onMode="1" bRatio="0.0110000" products="-313 223" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="-313 311" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0043000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0383000" products="-321 211" 
 <br/>      channel: onMode="1" bRatio="0.0035000" products="323 -321" 
 <br/>      channel: onMode="1" bRatio="0.0610000" products="-323 213" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="-323 321" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="331 111" 
 <br/>      channel: onMode="1" bRatio="0.0172000" products="331 311" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="331 -313" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="333 111" 
 <br/>      channel: onMode="1" bRatio="0.0086000" products="333 311" 
 <br/>      channel: onMode="1" bRatio="0.0071000" products="-10313 111" 
 <br/>      channel: onMode="1" bRatio="0.0107000" products="-10323 211" 
 <br/>      channel: onMode="1" bRatio="0.0730000" products="20213 -321" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0060000" products="211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0270000" products="211 -211 130" 
 <br/>      channel: onMode="1" bRatio="0.0270000" products="310 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="310 310 310" 
 <br/>      channel: onMode="1" bRatio="0.0078000" products="311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0116000" products="-313 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0225000" products="-313 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0051000" products="321 -321 311" 
 <br/>      channel: onMode="1" bRatio="0.1390000" products="-321 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0060000" products="-321 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0068000" products="-321 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="-321 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0303000" products="-321 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="-323 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0075000" products="331 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0011000" products="333 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0073000" products="211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0143000" products="311 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0085000" products="311 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="311 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="311 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="321 -321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="321 -321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0257500" products="-321 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0074000" products="-321 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0177000" products="211 211 -211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0060000" products="211 -211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0058000" products="311 211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0638000" products="311 211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0038000" products="-321 211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0038000" products="-321 211 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0192000" products="311 211 -211 111 111 111" 
 
<p/>particle: id="423" name="D*0" antiName="D*bar0" spinType="3" chargeType="0" colType="0" 
          m0="2.00698" 
 <br/>      channel: onMode="1" bRatio="0.6190000" meMode="2" products="421 111" 
 <br/>      channel: onMode="1" bRatio="0.3810000" products="421 22" 
 
<p/>particle: id="425" name="D*_2(2460)0" antiName="D*_2(2460)bar0" spinType="5" chargeType="0" colType="0" 
          m0="2.46260" mWidth="0.04900" mMin="2.30000" mMax="2.65000" 
 <br/>      channel: onMode="1" bRatio="0.2200000" products="413 -211" 
 <br/>      channel: onMode="1" bRatio="0.1100000" products="423 111" 
 <br/>      channel: onMode="1" bRatio="0.3800000" products="411 -211" 
 <br/>      channel: onMode="1" bRatio="0.1900000" products="421 111" 
 <br/>      channel: onMode="1" bRatio="0.0670000" products="413 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0330000" products="423 211 -211" 
 
<p/>particle: id="431" name="D_s+" antiName="D_s-" spinType="1" chargeType="3" colType="0" 
          m0="1.96849" tau0="1.49900e-01" 
 <br/>      channel: onMode="1" bRatio="0.0061600" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.0640000" products="-15 16" 
 <br/>      channel: onMode="1" bRatio="0.0307000" meMode="22" products="-11 12 221" 
 <br/>      channel: onMode="1" bRatio="0.0027000" meMode="22" products="-11 12 311" 
 <br/>      channel: onMode="1" bRatio="0.0010000" meMode="22" products="-11 12 -313" 
 <br/>      channel: onMode="1" bRatio="0.0106000" meMode="22" products="-11 12 331" 
 <br/>      channel: onMode="1" bRatio="0.0242000" meMode="22" products="-11 12 333" 
 <br/>      channel: onMode="1" bRatio="0.0307000" meMode="22" products="-13 14 221" 
 <br/>      channel: onMode="1" bRatio="0.0027000" meMode="22" products="-13 14 311" 
 <br/>      channel: onMode="1" bRatio="0.0010000" meMode="22" products="-13 14 -313" 
 <br/>      channel: onMode="1" bRatio="0.0106000" meMode="22" products="-13 14 331" 
 <br/>      channel: onMode="1" bRatio="0.0242000" meMode="22" products="-13 14 333" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="211 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="211 113" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="213 111" 
 <br/>      channel: onMode="1" bRatio="0.0210000" products="221 211" 
 <br/>      channel: onMode="1" bRatio="0.1310400" products="221 213" 
 <br/>      channel: onMode="1" bRatio="0.0034000" products="223 211" 
 <br/>      channel: onMode="1" bRatio="0.0023000" products="225 211" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="311 211" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="311 213" 
 <br/>      channel: onMode="1" bRatio="0.0079000" products="313 211" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="313 213" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="321 113" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="321 221" 
 <br/>      channel: onMode="1" bRatio="0.0440000" products="321 311" 
 <br/>      channel: onMode="1" bRatio="0.0400000" products="321 -313" 
 <br/>      channel: onMode="1" bRatio="0.0530000" products="323 311" 
 <br/>      channel: onMode="1" bRatio="0.0700000" products="323 -313" 
 <br/>      channel: onMode="1" bRatio="0.0470000" products="331 211" 
 <br/>      channel: onMode="1" bRatio="0.1220000" products="331 213" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="331 321" 
 <br/>      channel: onMode="1" bRatio="0.0440000" products="333 211" 
 <br/>      channel: onMode="1" bRatio="0.0820000" products="333 213" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="333 321" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="20213 311" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="9010221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0150000" products="221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="313 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="321 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="321 -313 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="321 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0110000" products="321 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="323 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="323 -313 111" 
 <br/>      channel: onMode="1" bRatio="0.0150000" products="331 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="331 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="333 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="221 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="221 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="321 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="321 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="321 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="331 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="333 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0080000" products="333 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0043000" products="321 -321 211 211 -211" 
 
<p/>particle: id="433" name="D*_s+" antiName="D*_s-" spinType="3" chargeType="3" colType="0" 
          m0="2.11230" 
 <br/>      channel: onMode="1" bRatio="0.9420000" products="431 22" 
 <br/>      channel: onMode="1" bRatio="0.0580000" meMode="2" products="431 111" 
 
<p/>particle: id="435" name="D*_2s(2573)+" antiName="D*_2s(2573)-" spinType="5" chargeType="3" colType="0" 
          m0="2.57190" mWidth="0.01700" mMin="2.51000" mMax="2.70000" 
 <br/>      channel: onMode="1" bRatio="0.0500000" products="413 311" 
 <br/>      channel: onMode="1" bRatio="0.0500000" products="423 321" 
 <br/>      channel: onMode="1" bRatio="0.4500000" products="411 311" 
 <br/>      channel: onMode="1" bRatio="0.4500000" products="421 321" 
 
<p/>particle: id="441" name="eta_c" spinType="1" chargeType="0" colType="0" 
          m0="2.98100" mWidth="0.02970" mMin="2.78040" mMax="3.18040" 
 <br/>      channel: onMode="1" bRatio="0.0002800" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.0087000" products="113 113" 
 <br/>      channel: onMode="1" bRatio="0.0173000" products="213 -213" 
 <br/>      channel: onMode="1" bRatio="0.0042000" products="313 -313" 
 <br/>      channel: onMode="1" bRatio="0.0043000" products="323 -323" 
 <br/>      channel: onMode="1" bRatio="0.0026000" products="333 333" 
 <br/>      channel: onMode="1" bRatio="0.0013000" products="2212 -2212" 
 <br/>      channel: onMode="1" bRatio="0.0163000" products="221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0327000" products="221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0095000" products="311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0191000" products="321 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0072000" products="321 -313 -211" 
 <br/>      channel: onMode="1" bRatio="0.0095000" products="321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0191000" products="-321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0072000" products="-321 313 211" 
 <br/>      channel: onMode="1" bRatio="0.0137000" products="331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0273000" products="331 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="333 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0033000" products="211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="321 321 -321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0054000" products="321 -321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.7886200" meMode="52" products="83 -83" 
 
<p/>particle: id="443" name="J/psi" spinType="3" chargeType="0" colType="0" 
          m0="3.09692" mWidth="0.00009" mMin="3.09602" mMax="3.09782" 
 <br/>      channel: onMode="1" bRatio="0.8023950" meMode="43" products="83 -83" 
 <br/>      channel: onMode="1" bRatio="0.0594000" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0593000" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0130000" products="441 22" 
 <br/>      channel: onMode="1" bRatio="0.0056000" products="113 111" 
 <br/>      channel: onMode="1" bRatio="0.0056500" products="213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0056500" products="-213 211" 
 <br/>      channel: onMode="1" bRatio="0.0036000" products="115 113" 
 <br/>      channel: onMode="1" bRatio="0.0036000" products="-215 213" 
 <br/>      channel: onMode="1" bRatio="0.0036000" products="215 -213" 
 <br/>      channel: onMode="1" bRatio="0.0043000" products="225 223" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="313 -315" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="323 -325" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="-323 325" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="321 -323" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-321 323" 
 <br/>      channel: onMode="1" bRatio="0.0021000" products="311 -313" 
 <br/>      channel: onMode="1" bRatio="0.0021000" products="-311 313" 
 <br/>      channel: onMode="1" bRatio="0.0019000" products="20323 -321" 
 <br/>      channel: onMode="1" bRatio="0.0019000" products="-20323 321" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="10213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="-10213 211" 
 <br/>      channel: onMode="1" bRatio="0.0023000" products="10113 111" 
 <br/>      channel: onMode="1" bRatio="0.0004800" products="10331 223" 
 <br/>      channel: onMode="1" bRatio="0.0007400" products="223 221" 
 <br/>      channel: onMode="1" bRatio="0.0003600" products="10331 333" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="333 335" 
 <br/>      channel: onMode="1" bRatio="0.0006800" products="20333 223" 
 <br/>      channel: onMode="1" bRatio="0.0007400" products="333 221" 
 <br/>      channel: onMode="1" bRatio="0.0004500" products="223 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="333 331" 
 <br/>      channel: onMode="1" bRatio="0.0003200" products="333 9010221" 
 <br/>      channel: onMode="1" bRatio="0.0002600" products="333 20223" 
 <br/>      channel: onMode="1" bRatio="0.0001930" products="113 221" 
 <br/>      channel: onMode="1" bRatio="0.0001820" products="223 331" 
 <br/>      channel: onMode="1" bRatio="0.0001400" products="223 9010221" 
 <br/>      channel: onMode="1" bRatio="0.0001050" products="113 331" 
 <br/>      channel: onMode="1" bRatio="0.0011000" products="2224 -2224" 
 <br/>      channel: onMode="1" bRatio="0.0005150" products="3112 -3112" 
 <br/>      channel: onMode="1" bRatio="0.0005900" products="3314 -3314" 
 <br/>      channel: onMode="1" bRatio="0.0003200" products="3324 -3324" 
 <br/>      channel: onMode="1" bRatio="0.0003200" products="3324 -3324" 
 <br/>      channel: onMode="1" bRatio="0.0001550" products="3114 -3114" 
 <br/>      channel: onMode="1" bRatio="0.0001550" products="3224 -3224" 
 
<p/>particle: id="445" name="chi_2c" spinType="5" chargeType="0" colType="0" 
          m0="3.55620" mWidth="0.00198" mMin="3.53620" mMax="3.57620" 
 <br/>      channel: onMode="1" bRatio="0.0002590" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.2020000" products="443 22" 
 <br/>      channel: onMode="1" bRatio="0.0008900" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0008900" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.0047000" products="313 -313" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0024000" products="333 333" 
 <br/>      channel: onMode="1" bRatio="0.0000680" products="2212 -2212" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="3122 -3122" 
 <br/>      channel: onMode="1" bRatio="0.0046000" products="211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0046000" products="213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0046000" products="-213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="321 -313 -211" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="-321 313 211" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="323 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="-323 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0102000" products="211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="310 310 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="321 321 -321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0103000" products="321 -321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="321 -321 310 310" 
 <br/>      channel: onMode="1" bRatio="0.0017000" products="2212 -2212 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0107000" products="211 211 211 -211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.7310930" meMode="52" products="83 -83" 
 
<p/>particle: id="511" name="B0" antiName="Bbar0" spinType="1" chargeType="0" colType="0" 
          m0="5.27958" tau0="4.58700e-01" 
 <br/>      channel: onMode="1" bRatio="0.0001330" meMode="22" products="12 -11 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002690" meMode="22" products="12 -11 -213" 
 <br/>      channel: onMode="1" bRatio="0.0207000" meMode="22" products="12 -11 -411" 
 <br/>      channel: onMode="1" bRatio="0.0570000" meMode="22" products="12 -11 -413" 
 <br/>      channel: onMode="1" bRatio="0.0023000" meMode="22" products="12 -11 -415" 
 <br/>      channel: onMode="1" bRatio="0.0045000" meMode="22" products="12 -11 -10411" 
 <br/>      channel: onMode="1" bRatio="0.0052000" meMode="22" products="12 -11 -10413" 
 <br/>      channel: onMode="1" bRatio="0.0083000" meMode="22" products="12 -11 -20413" 
 <br/>      channel: onMode="1" bRatio="0.0001330" meMode="22" products="14 -13 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002690" meMode="22" products="14 -13 -213" 
 <br/>      channel: onMode="1" bRatio="0.0207000" meMode="22" products="14 -13 -411" 
 <br/>      channel: onMode="1" bRatio="0.0570000" meMode="22" products="14 -13 -413" 
 <br/>      channel: onMode="1" bRatio="0.0023000" meMode="22" products="14 -13 -415" 
 <br/>      channel: onMode="1" bRatio="0.0045000" meMode="22" products="14 -13 -10411" 
 <br/>      channel: onMode="1" bRatio="0.0052000" meMode="22" products="14 -13 -10413" 
 <br/>      channel: onMode="1" bRatio="0.0083000" meMode="22" products="14 -13 -20413" 
 <br/>      channel: onMode="1" bRatio="0.0000600" meMode="22" products="16 -15 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000830" meMode="22" products="16 -15 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000080" meMode="22" products="16 -15 -215" 
 <br/>      channel: onMode="1" bRatio="0.0070000" meMode="22" products="16 -15 -411" 
 <br/>      channel: onMode="1" bRatio="0.0160000" meMode="22" products="16 -15 -413" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="16 -15 -415" 
 <br/>      channel: onMode="1" bRatio="0.0000080" meMode="22" products="16 -15 -10213" 
 <br/>      channel: onMode="1" bRatio="0.0013000" meMode="22" products="16 -15 -10411" 
 <br/>      channel: onMode="1" bRatio="0.0013000" meMode="22" products="16 -15 -10413" 
 <br/>      channel: onMode="1" bRatio="0.0000900" meMode="22" products="16 -15 -20213" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="16 -15 -20413" 
 <br/>      channel: onMode="1" bRatio="0.0000080" meMode="22" products="16 -15 -9000211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" meMode="22" products="12 -11 -411 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" meMode="22" products="12 -11 -413 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="12 -11 -421 -211" 
 <br/>      channel: onMode="1" bRatio="0.0007000" meMode="22" products="12 -11 -423 -211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" meMode="22" products="14 -13 -411 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" meMode="22" products="14 -13 -413 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="14 -13 -421 -211" 
 <br/>      channel: onMode="1" bRatio="0.0007000" meMode="22" products="14 -13 -423 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000015" products="111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="113 113" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="130 111" 
 <br/>      channel: onMode="1" bRatio="0.0000026" products="130 113" 
 <br/>      channel: onMode="1" bRatio="0.0000006" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0000046" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="213 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 130" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="223 22" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="223 113" 
 <br/>      channel: onMode="1" bRatio="0.0000023" products="223 130" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="223 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="223 223" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="310 111" 
 <br/>      channel: onMode="1" bRatio="0.0000026" products="310 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="310 221" 
 <br/>      channel: onMode="1" bRatio="0.0000023" products="310 223" 
 <br/>      channel: onMode="1" bRatio="0.0000006" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.0000401" products="313 22" 
 <br/>      channel: onMode="1" bRatio="0.0000017" products="313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 113" 
 <br/>      channel: onMode="1" bRatio="0.0000190" products="313 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="313 223" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="313 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="313 -313" 
 <br/>      channel: onMode="1" bRatio="0.0000180" products="321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000099" products="321 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000130" products="323 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="323 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="323 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -323" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 113" 
 <br/>      channel: onMode="1" bRatio="0.0000320" products="331 130" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 223" 
 <br/>      channel: onMode="1" bRatio="0.0000320" products="331 310" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 331" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 113" 
 <br/>      channel: onMode="1" bRatio="0.0000042" products="333 130" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 223" 
 <br/>      channel: onMode="1" bRatio="0.0000042" products="333 310" 
 <br/>      channel: onMode="1" bRatio="0.0000110" products="333 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 331" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 333" 
 <br/>      channel: onMode="1" bRatio="0.0002700" products="411 -411" 
 <br/>      channel: onMode="1" bRatio="0.0028000" products="-411 211" 
 <br/>      channel: onMode="1" bRatio="0.0077000" products="-411 213" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="-411 321" 
 <br/>      channel: onMode="1" bRatio="0.0003700" products="-411 323" 
 <br/>      channel: onMode="1" bRatio="0.0003350" products="413 -411" 
 <br/>      channel: onMode="1" bRatio="0.0008300" products="413 -413" 
 <br/>      channel: onMode="1" bRatio="0.0028000" products="-413 211" 
 <br/>      channel: onMode="1" bRatio="0.0068000" products="-413 213" 
 <br/>      channel: onMode="1" bRatio="0.0001700" products="-413 321" 
 <br/>      channel: onMode="1" bRatio="0.0003800" products="-413 323" 
 <br/>      channel: onMode="1" bRatio="0.0003350" products="-413 411" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="-415 211" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="-415 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="421 313" 
 <br/>      channel: onMode="1" bRatio="0.0002900" products="-421 111" 
 <br/>      channel: onMode="1" bRatio="0.0002900" products="-421 113" 
 <br/>      channel: onMode="1" bRatio="0.0002200" products="-421 221" 
 <br/>      channel: onMode="1" bRatio="0.0002500" products="-421 223" 
 <br/>      channel: onMode="1" bRatio="0.0000400" products="-421 311" 
 <br/>      channel: onMode="1" bRatio="0.0000400" products="-421 313" 
 <br/>      channel: onMode="1" bRatio="0.0001700" products="-421 331" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="423 313" 
 <br/>      channel: onMode="1" bRatio="0.0002700" products="-423 111" 
 <br/>      channel: onMode="1" bRatio="0.0002900" products="-423 113" 
 <br/>      channel: onMode="1" bRatio="0.0002600" products="-423 221" 
 <br/>      channel: onMode="1" bRatio="0.0004200" products="-423 223" 
 <br/>      channel: onMode="1" bRatio="0.0000400" products="-423 311" 
 <br/>      channel: onMode="1" bRatio="0.0000400" products="-423 313" 
 <br/>      channel: onMode="1" bRatio="0.0001700" products="-423 331" 
 <br/>      channel: onMode="1" bRatio="0.0000390" products="431 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000160" products="431 -213" 
 <br/>      channel: onMode="1" bRatio="0.0090000" products="431 -411" 
 <br/>      channel: onMode="1" bRatio="0.0126000" products="431 -413" 
 <br/>      channel: onMode="1" bRatio="0.0042000" products="431 -415" 
 <br/>      channel: onMode="1" bRatio="0.0000460" products="-431 321" 
 <br/>      channel: onMode="1" bRatio="0.0000160" products="-431 323" 
 <br/>      channel: onMode="1" bRatio="0.0000260" products="433 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000160" products="433 -213" 
 <br/>      channel: onMode="1" bRatio="0.0090000" products="433 -411" 
 <br/>      channel: onMode="1" bRatio="0.0240000" products="433 -413" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="433 -415" 
 <br/>      channel: onMode="1" bRatio="0.0000160" products="-433 321" 
 <br/>      channel: onMode="1" bRatio="0.0000160" products="-433 323" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="441 130" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="441 310" 
 <br/>      channel: onMode="1" bRatio="0.0016200" products="441 313" 
 <br/>      channel: onMode="1" bRatio="0.0000220" products="443 111" 
 <br/>      channel: onMode="1" bRatio="0.0000160" products="443 113" 
 <br/>      channel: onMode="1" bRatio="0.0004400" products="443 130" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="443 223" 
 <br/>      channel: onMode="1" bRatio="0.0004400" products="443 310" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="443 315" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="445 313" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="2212 -2212" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="10113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="10113 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10113 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="10113 331" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10213 321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="10311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 113" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="10311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 333" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="10313 443" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="10321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="10321 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="-10411 211" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="-10413 211" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="-10413 213" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="-10413 431" 
 <br/>      channel: onMode="1" bRatio="0.0024000" products="-10413 433" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="10431 -411" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="10431 -413" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="10441 130" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="10441 310" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="10441 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20113 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 223" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 311" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="20113 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20113 331" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="20113 20113" 
 <br/>      channel: onMode="1" bRatio="0.0000400" products="20213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 -213" 
 <br/>      channel: onMode="1" bRatio="0.0083400" products="20213 -411" 
 <br/>      channel: onMode="1" bRatio="0.0120000" products="20213 -413" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="20213 -20213" 
 <br/>      channel: onMode="1" bRatio="0.0000400" products="-20213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-20213 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-20213 321" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="-20213 323" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20313 333" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="20313 443" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="-20413 211" 
 <br/>      channel: onMode="1" bRatio="0.0013000" products="-20413 213" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="-20413 431" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="-20413 433" 
 <br/>      channel: onMode="1" bRatio="0.0041000" products="20433 -411" 
 <br/>      channel: onMode="1" bRatio="0.0098000" products="20433 -413" 
 <br/>      channel: onMode="1" bRatio="0.0002300" products="20443 130" 
 <br/>      channel: onMode="1" bRatio="0.0002300" products="20443 310" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="20443 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="30313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="30313 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="30323 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="30323 -321" 
 <br/>      channel: onMode="1" bRatio="0.0002400" products="30443 130" 
 <br/>      channel: onMode="1" bRatio="0.0002400" products="30443 310" 
 <br/>      channel: onMode="1" bRatio="0.0004800" products="30443 313" 
 <br/>      channel: onMode="1" bRatio="0.0002900" products="30443 10313" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="100113 130" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="100113 310" 
 <br/>      channel: onMode="1" bRatio="0.0002400" products="100441 130" 
 <br/>      channel: onMode="1" bRatio="0.0002400" products="100441 310" 
 <br/>      channel: onMode="1" bRatio="0.0006600" products="100441 313" 
 <br/>      channel: onMode="1" bRatio="0.0003300" products="100443 130" 
 <br/>      channel: onMode="1" bRatio="0.0003300" products="100443 310" 
 <br/>      channel: onMode="1" bRatio="0.0006600" products="100443 313" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="100443 10313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 223" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 311" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000111 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 331" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 10113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 20113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 9000111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9000211 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="-9000211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-9000211 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-9000211 321" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="-9000211 323" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 223" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="9010221 311" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9010221 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 331" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 10113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 20113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 9000111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 9010221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="113 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="113 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000240" products="211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="213 -213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="221 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 113 113" 
 <br/>      channel: onMode="1" bRatio="0.0000170" products="221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 213 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="221 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="223 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="223 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="223 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="223 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="223 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="223 221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000006" meMode="11" products="311 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000006" meMode="11" products="311 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000001" meMode="11" products="311 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000260" products="311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 223 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 223" 
 <br/>      channel: onMode="1" bRatio="0.0000480" products="311 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000018" meMode="11" products="313 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000014" meMode="11" products="313 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000002" meMode="11" products="313 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="313 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="313 223 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="313 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="313 -313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="313 -313 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-313 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="321 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 221 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 223 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -313 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 223" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -321 313" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="-321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-321 311 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-321 313 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 -213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="323 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="323 221 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 223 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -313 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 -321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -323 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="323 -323 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-323 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-323 313 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-323 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-323 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 113 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 213 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 223 113" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 223 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 223" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 313 113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 313 223" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 313 -313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 323 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 323 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 323 -323" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 331 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="333 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 311 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 311 223" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="333 313 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 321 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 323 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="333 331 113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="333 331 313" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 333 111" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="333 333 311" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="333 333 313" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="411 -411 311" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="411 -411 313" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-411 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0011000" products="-411 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0011000" products="-411 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0047000" products="413 -411 311" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="413 -411 313" 
 <br/>      channel: onMode="1" bRatio="0.0070000" products="413 -413 311" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="413 -413 313" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="-413 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-413 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-413 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="-413 411 311" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-413 411 313" 
 <br/>      channel: onMode="1" bRatio="0.0017000" products="421 -411 321" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="421 -411 323" 
 <br/>      channel: onMode="1" bRatio="0.0031000" products="421 -413 321" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="421 -413 323" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="421 -421 311" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="421 -421 313" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-421 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0049000" products="423 -411 321" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="423 -411 323" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="423 -413 321" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="423 -413 323" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="423 -421 313" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="423 -423 311" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="423 -423 313" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-423 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="-423 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-423 421 313" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="431 -411 111" 
 <br/>      channel: onMode="1" bRatio="0.0037000" products="431 -421 -211" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="433 -411 111" 
 <br/>      channel: onMode="1" bRatio="0.0037000" products="433 -421 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="441 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="441 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="443 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="443 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000900" products="443 333 311" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="445 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="445 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10311 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10311 331 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 333 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 -213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10321 221 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 -321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10321 331 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 333 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10321 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="10441 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="10441 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="20113 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20113 331 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="20213 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20213 331 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-20213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="-20213 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-20213 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-20213 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-20213 331 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20313 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20313 333 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20313 333 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20313 333 331" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20323 333 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="20443 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="20443 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001400" products="30443 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0001400" products="30443 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="100441 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000800" products="100441 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="100443 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="100443 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9000111 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9000111 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9000111 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000111 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000111 313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9000111 313 221" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000111 323 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9000111 331 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 331 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9000211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9000211 -213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000211 221 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9000211 331 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-9000211 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-9000211 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-9000211 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="-9000211 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="-9000211 323 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-9000211 323 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-9000211 331 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-9000211 331 323" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9010221 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9010221 313 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 323 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9010221 331 113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9010221 331 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 333 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 333 311" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="113 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="211 -211 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="213 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="213 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-213 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-213 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 113 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 -213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="221 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="223 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="223 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="223 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="223 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 113 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 -213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 221 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 221 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 221 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 221 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 223 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 223 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 223 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="311 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="311 311 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="311 311 221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 311 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="311 311 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="313 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="313 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="313 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="313 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="313 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-313 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-313 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="-313 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -211 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 213 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -213 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -213 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 221 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 221 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 221 -213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 221 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 223 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 223 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 -213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 311 221 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 223 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 313 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -313 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 -313 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -313 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 321 -321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 321 -321 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 321 -321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 -321 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 -321 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 -321 221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 -321 223 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -321 311 113" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 -321 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -321 311 223" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 -321 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-321 311 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-321 311 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="-321 311 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-321 311 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-321 313 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="-321 313 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="323 221 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 311 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="323 311 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 311 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 321 -321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="323 -321 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-323 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="-323 311 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-323 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-323 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="-323 321 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-323 321 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 113 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 -213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 223 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 223 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 311 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 311 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 311 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 311 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 311 311 113" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 311 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 313 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 313 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 313 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 -313 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 -213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 223 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 311 -213" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 -313 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 -321 113" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 321 -321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 -321 223" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 -321 311 213" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 -321 313 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 323 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 323 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 323 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 -323 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 -323 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="333 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="333 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="333 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 311 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 313 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 -313 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="333 321 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 321 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 -321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 -321 313" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 -323 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="333 331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="333 331 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="333 331 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="333 331 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-411 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="-411 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-413 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="-421 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-421 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="-423 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-423 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="431 -411 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="431 -411 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="431 -421 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="433 -411 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="433 -411 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="433 -421 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="441 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="441 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="441 321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="445 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="445 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="445 321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10311 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10311 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10311 311 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 321 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10311 321 -321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10311 331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10311 331 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10311 331 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10311 331 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10311 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="-10311 311 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10311 321 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-10311 331 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10321 221 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 311 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 321 -321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10321 331 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10321 321 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="10441 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="10441 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="10441 321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20313 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20313 311 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20313 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20313 321 -321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20313 331 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20313 331 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-20313 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-20313 311 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-20313 331 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20323 321 -321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-20323 321 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="20443 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="20443 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="20443 321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000700" products="30443 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0001400" products="30443 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000700" products="30443 321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="100441 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000800" products="100441 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="100441 321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="100443 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="100443 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="100443 321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-9000211 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-9000211 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9010221 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9010221 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 321 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 321 -321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 331 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="111 111 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="211 211 -211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="211 -211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="221 111 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="221 211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="221 211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 111 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 221 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 221 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="311 311 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="311 311 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="311 311 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="311 311 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 311 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 311 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 311 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="311 311 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 211 -211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 -211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 221 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 221 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 311 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 311 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 311 221 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 311 311 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 311 311 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 311 311 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 321 -321 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 321 -321 221 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 321 -321 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 321 -321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 321 -321 -321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 -321 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 -321 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 -321 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 -321 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -321 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -321 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 -321 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 -321 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 -321 311 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 -321 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="-321 311 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="-321 311 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="-321 311 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="-321 311 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 111 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 311 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 311 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 311 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 321 311 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 311 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 321 -321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 321 -321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 321 -321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="331 321 -321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 -321 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 311 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 321 311 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 321 321 -321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="333 321 -321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="55" products="-3 1" 
 <br/>      channel: onMode="1" bRatio="0.0110000" meMode="63" products="-4101 2101" 
 <br/>      channel: onMode="1" bRatio="0.0220000" meMode="63" products="-4103 2103" 
 <br/>      channel: onMode="1" bRatio="0.0030000" meMode="63" products="-4301 2101" 
 <br/>      channel: onMode="1" bRatio="0.0060000" meMode="63" products="-4303 2103" 
 <br/>      channel: onMode="1" bRatio="0.0000700" meMode="23" products="1 -1 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0018000" meMode="23" products="1 -1 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0030000" meMode="23" products="2 -1 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0020500" meMode="23" products="2 -2 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0022000" meMode="23" products="2 -2 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0210000" meMode="63" products="2 -3 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0180000" meMode="23" products="2 -4 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0009000" meMode="23" products="2 -4 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000900" meMode="23" products="3 -3 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0015000" meMode="23" products="3 -3 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0060000" meMode="43" products="4 -1 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0040000" meMode="23" products="4 -3 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0740000" meMode="43" products="4 -3 -4 1" 
 <br/>      channel: onMode="2" bRatio="0.0018920" meMode="22" products="12 -11 1 -2" 
 <br/>      channel: onMode="2" bRatio="0.0018920" meMode="22" products="14 -13 1 -2" 
 <br/>      channel: onMode="2" bRatio="0.0012910" products="443 313" 
 <br/>      channel: onMode="2" bRatio="0.0000500" products="445 130" 
 <br/>      channel: onMode="2" bRatio="0.0000500" products="445 310" 
 <br/>      channel: onMode="2" bRatio="0.0000100" products="213 -211 113" 
 <br/>      channel: onMode="2" bRatio="0.0000100" products="223 213 -211" 
 <br/>      channel: onMode="2" bRatio="0.0000067" products="313 111 111" 
 <br/>      channel: onMode="2" bRatio="0.0000100" products="321 -211 113" 
 <br/>      channel: onMode="2" bRatio="0.0000010" products="321 -321 130" 
 <br/>      channel: onMode="2" bRatio="0.0000010" products="321 -321 310" 
 <br/>      channel: onMode="2" bRatio="0.0000070" products="333 311 221" 
 <br/>      channel: onMode="2" bRatio="0.0005000" products="423 -421 311" 
 <br/>      channel: onMode="2" bRatio="0.0015000" products="-423 421 311" 
 <br/>      channel: onMode="2" bRatio="0.0000050" products="9000211 313 -211" 
 <br/>      channel: onMode="2" bRatio="0.0003118" meMode="31" products="1 -3 22" 
 <br/>      channel: onMode="2" bRatio="0.0000050" meMode="12" products="1 -3 11 -11" 
 <br/>      channel: onMode="2" bRatio="0.0000025" meMode="12" products="1 -3 13 -13" 
 <br/>      channel: onMode="2" bRatio="0.0000002" meMode="12" products="1 -3 15 -15" 
 <br/>      channel: onMode="2" bRatio="0.3158500" meMode="23" products="2 -1 -4 1" 
 <br/>      channel: onMode="3" bRatio="0.0018920" meMode="22" products="12 -11 -2 1" 
 <br/>      channel: onMode="3" bRatio="0.0018920" meMode="22" products="14 -13 -2 1" 
 <br/>      channel: onMode="3" bRatio="0.0012310" products="443 313" 
 <br/>      channel: onMode="3" bRatio="0.0000100" products="445 130" 
 <br/>      channel: onMode="3" bRatio="0.0000100" products="445 310" 
 <br/>      channel: onMode="3" bRatio="0.0000100" products="-213 211 113" 
 <br/>      channel: onMode="3" bRatio="0.0000100" products="223 -213 211" 
 <br/>      channel: onMode="3" bRatio="0.0000067" products="-313 111 111" 
 <br/>      channel: onMode="3" bRatio="0.0000050" products="321 -211 113" 
 <br/>      channel: onMode="3" bRatio="0.0000105" products="321 -321 130" 
 <br/>      channel: onMode="3" bRatio="0.0000105" products="321 -321 310" 
 <br/>      channel: onMode="3" bRatio="0.0000050" products="333 311 221" 
 <br/>      channel: onMode="3" bRatio="0.0015000" products="423 -421 311" 
 <br/>      channel: onMode="3" bRatio="0.0005000" products="-423 421 311" 
 <br/>      channel: onMode="3" bRatio="0.0000050" products="-9000211 313 211" 
 <br/>      channel: onMode="3" bRatio="0.0003118" meMode="31" products="-3 1 22" 
 <br/>      channel: onMode="3" bRatio="0.3160000" meMode="23" products="2 -1 -4 1" 
 <br/>      channel: onMode="3" bRatio="0.0000050" meMode="12" products="-3 1 11 -11" 
 <br/>      channel: onMode="3" bRatio="0.0000025" meMode="12" products="-3 1 13 -13" 
 <br/>      channel: onMode="3" bRatio="0.0000002" meMode="12" products="-3 1 15 -15" 
 
<p/>particle: id="513" name="B*0" antiName="B*bar0" spinType="3" chargeType="0" colType="0" 
          m0="5.32520" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="511 22" 
 
<p/>particle: id="515" name="B*_20" antiName="B*_2bar0" spinType="5" chargeType="0" colType="0" 
          m0="5.74300" mWidth="0.02300" mMin="5.63000" mMax="6.03000" 
 <br/>      channel: onMode="1" bRatio="0.3100000" products="523 -211" 
 <br/>      channel: onMode="1" bRatio="0.1500000" products="513 111" 
 <br/>      channel: onMode="1" bRatio="0.3100000" products="521 -211" 
 <br/>      channel: onMode="1" bRatio="0.1500000" products="511 111" 
 <br/>      channel: onMode="1" bRatio="0.0500000" products="523 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0300000" products="513 211 -211" 
 
<p/>particle: id="521" name="B+" antiName="B-" spinType="1" chargeType="3" colType="0" 
          m0="5.27925" tau0="4.91100e-01" 
 <br/>      channel: onMode="1" bRatio="0.0000930" products="16 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000720" meMode="22" products="12 -11 111" 
 <br/>      channel: onMode="1" bRatio="0.0001450" meMode="22" products="12 -11 113" 
 <br/>      channel: onMode="1" bRatio="0.0000840" meMode="22" products="12 -11 221" 
 <br/>      channel: onMode="1" bRatio="0.0001450" meMode="22" products="12 -11 223" 
 <br/>      channel: onMode="1" bRatio="0.0000840" meMode="22" products="12 -11 331" 
 <br/>      channel: onMode="1" bRatio="0.0224000" meMode="22" products="12 -11 -421" 
 <br/>      channel: onMode="1" bRatio="0.0617000" meMode="22" products="12 -11 -423" 
 <br/>      channel: onMode="1" bRatio="0.0030000" meMode="22" products="12 -11 -425" 
 <br/>      channel: onMode="1" bRatio="0.0049000" meMode="22" products="12 -11 -10421" 
 <br/>      channel: onMode="1" bRatio="0.0056000" meMode="22" products="12 -11 -10423" 
 <br/>      channel: onMode="1" bRatio="0.0090000" meMode="22" products="12 -11 -20423" 
 <br/>      channel: onMode="1" bRatio="0.0000720" meMode="22" products="14 -13 111" 
 <br/>      channel: onMode="1" bRatio="0.0001450" meMode="22" products="14 -13 113" 
 <br/>      channel: onMode="1" bRatio="0.0000840" meMode="22" products="14 -13 221" 
 <br/>      channel: onMode="1" bRatio="0.0001450" meMode="22" products="14 -13 223" 
 <br/>      channel: onMode="1" bRatio="0.0000840" meMode="22" products="14 -13 331" 
 <br/>      channel: onMode="1" bRatio="0.0224000" meMode="22" products="14 -13 -421" 
 <br/>      channel: onMode="1" bRatio="0.0617000" meMode="22" products="14 -13 -423" 
 <br/>      channel: onMode="1" bRatio="0.0030000" meMode="22" products="14 -13 -425" 
 <br/>      channel: onMode="1" bRatio="0.0049000" meMode="22" products="14 -13 -10421" 
 <br/>      channel: onMode="1" bRatio="0.0056000" meMode="22" products="14 -13 -10423" 
 <br/>      channel: onMode="1" bRatio="0.0090000" meMode="22" products="14 -13 -20423" 
 <br/>      channel: onMode="1" bRatio="0.0000300" meMode="22" products="16 -15 111" 
 <br/>      channel: onMode="1" bRatio="0.0000420" meMode="22" products="16 -15 113" 
 <br/>      channel: onMode="1" bRatio="0.0000120" meMode="22" products="16 -15 221" 
 <br/>      channel: onMode="1" bRatio="0.0000420" meMode="22" products="16 -15 223" 
 <br/>      channel: onMode="1" bRatio="0.0000200" meMode="22" products="16 -15 225" 
 <br/>      channel: onMode="1" bRatio="0.0000180" meMode="22" products="16 -15 331" 
 <br/>      channel: onMode="1" bRatio="0.0000200" meMode="22" products="16 -15 335" 
 <br/>      channel: onMode="1" bRatio="0.0070000" meMode="22" products="16 -15 -421" 
 <br/>      channel: onMode="1" bRatio="0.0160000" meMode="22" products="16 -15 -423" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="16 -15 -425" 
 <br/>      channel: onMode="1" bRatio="0.0000270" meMode="22" products="16 -15 10113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" meMode="22" products="16 -15 10221" 
 <br/>      channel: onMode="1" bRatio="0.0000130" meMode="22" products="16 -15 10223" 
 <br/>      channel: onMode="1" bRatio="0.0000130" meMode="22" products="16 -15 10333" 
 <br/>      channel: onMode="1" bRatio="0.0013000" meMode="22" products="16 -15 -10421" 
 <br/>      channel: onMode="1" bRatio="0.0013000" meMode="22" products="16 -15 -10423" 
 <br/>      channel: onMode="1" bRatio="0.0000460" meMode="22" products="16 -15 20113" 
 <br/>      channel: onMode="1" bRatio="0.0000230" meMode="22" products="16 -15 20223" 
 <br/>      channel: onMode="1" bRatio="0.0000230" meMode="22" products="16 -15 20333" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="16 -15 -20423" 
 <br/>      channel: onMode="1" bRatio="0.0000040" meMode="22" products="16 -15 9000111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" meMode="22" products="16 -15 9010221" 
 <br/>      channel: onMode="1" bRatio="0.0019000" meMode="22" products="12 -11 -411 211" 
 <br/>      channel: onMode="1" bRatio="0.0006000" meMode="22" products="12 -11 -413 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" meMode="22" products="12 -11 -421 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" meMode="22" products="12 -11 -423 111" 
 <br/>      channel: onMode="1" bRatio="0.0019000" meMode="22" products="14 -13 -411 211" 
 <br/>      channel: onMode="1" bRatio="0.0006000" meMode="22" products="14 -13 -413 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" meMode="22" products="14 -13 -421 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" meMode="22" products="14 -13 -423 111" 
 <br/>      channel: onMode="1" bRatio="0.0000055" products="211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000091" products="211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000120" products="211 130" 
 <br/>      channel: onMode="1" bRatio="0.0000120" products="213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000150" products="213 113" 
 <br/>      channel: onMode="1" bRatio="0.0000048" products="221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000086" products="221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000059" products="223 211" 
 <br/>      channel: onMode="1" bRatio="0.0000130" products="223 213" 
 <br/>      channel: onMode="1" bRatio="0.0000023" products="225 211" 
 <br/>      channel: onMode="1" bRatio="0.0000120" products="310 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 213" 
 <br/>      channel: onMode="1" bRatio="0.0000120" products="321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000052" products="321 113" 
 <br/>      channel: onMode="1" bRatio="0.0000026" products="321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000051" products="321 223" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000403" products="323 22" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="323 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 113" 
 <br/>      channel: onMode="1" bRatio="0.0000240" products="323 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 223" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="323 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -313" 
 <br/>      channel: onMode="1" bRatio="0.0000042" products="331 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 213" 
 <br/>      channel: onMode="1" bRatio="0.0000780" products="331 321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 323" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 213" 
 <br/>      channel: onMode="1" bRatio="0.0000090" products="333 321" 
 <br/>      channel: onMode="1" bRatio="0.0000110" products="333 323" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="411 111" 
 <br/>      channel: onMode="1" bRatio="0.0000110" products="411 311" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="413 111" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="413 311" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-421 211" 
 <br/>      channel: onMode="1" bRatio="0.0134000" products="-421 213" 
 <br/>      channel: onMode="1" bRatio="0.0004100" products="-421 321" 
 <br/>      channel: onMode="1" bRatio="0.0006100" products="-421 323" 
 <br/>      channel: onMode="1" bRatio="0.0002700" products="-421 411" 
 <br/>      channel: onMode="1" bRatio="0.0003350" products="-421 413" 
 <br/>      channel: onMode="1" bRatio="0.0046000" products="-423 211" 
 <br/>      channel: onMode="1" bRatio="0.0098000" products="-423 213" 
 <br/>      channel: onMode="1" bRatio="0.0003600" products="-423 321" 
 <br/>      channel: onMode="1" bRatio="0.0007700" products="-423 323" 
 <br/>      channel: onMode="1" bRatio="0.0003350" products="-423 411" 
 <br/>      channel: onMode="1" bRatio="0.0010400" products="-423 413" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="-425 211" 
 <br/>      channel: onMode="1" bRatio="0.0038000" products="-425 213" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="431 111" 
 <br/>      channel: onMode="1" bRatio="0.0000280" products="431 113" 
 <br/>      channel: onMode="1" bRatio="0.0129000" products="431 -421" 
 <br/>      channel: onMode="1" bRatio="0.0124000" products="431 -423" 
 <br/>      channel: onMode="1" bRatio="0.0042000" products="431 -425" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="433 111" 
 <br/>      channel: onMode="1" bRatio="0.0000280" products="433 113" 
 <br/>      channel: onMode="1" bRatio="0.0111000" products="433 -421" 
 <br/>      channel: onMode="1" bRatio="0.0278000" products="433 -423" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="433 -425" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="441 321" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="441 323" 
 <br/>      channel: onMode="1" bRatio="0.0000400" products="443 211" 
 <br/>      channel: onMode="1" bRatio="0.0000600" products="443 213" 
 <br/>      channel: onMode="1" bRatio="0.0010600" products="443 321" 
 <br/>      channel: onMode="1" bRatio="0.0014300" products="443 323" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="443 325" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="445 321" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10113 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10113 321" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10213 311" 
 <br/>      channel: onMode="1" bRatio="0.0000700" products="10311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 213" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-10311 321" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 333" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="10323 443" 
 <br/>      channel: onMode="1" bRatio="0.0009100" products="-10421 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-10423 211" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="-10423 213" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="-10423 431" 
 <br/>      channel: onMode="1" bRatio="0.0024000" products="-10423 433" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="10431 -421" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="10431 -423" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="10441 321" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="10441 323" 
 <br/>      channel: onMode="1" bRatio="0.0000400" products="20113 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 321" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="20113 323" 
 <br/>      channel: onMode="1" bRatio="0.0000400" products="20213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 223" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 311" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="20213 313" 
 <br/>      channel: onMode="1" bRatio="0.0088700" products="20213 -421" 
 <br/>      channel: onMode="1" bRatio="0.0159700" products="20213 -423" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="20213 20113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20323 333" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="20323 443" 
 <br/>      channel: onMode="1" bRatio="0.0007500" products="-20423 211" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="-20423 213" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="-20423 431" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="-20423 433" 
 <br/>      channel: onMode="1" bRatio="0.0041000" products="20433 -421" 
 <br/>      channel: onMode="1" bRatio="0.0098000" products="20433 -423" 
 <br/>      channel: onMode="1" bRatio="0.0005700" products="20443 321" 
 <br/>      channel: onMode="1" bRatio="0.0002900" products="20443 323" 
 <br/>      channel: onMode="1" bRatio="0.0004800" products="30443 321" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="30443 323" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="30443 10323" 
 <br/>      channel: onMode="1" bRatio="0.0000022" products="100113 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="100113 321" 
 <br/>      channel: onMode="1" bRatio="0.0003600" products="100441 321" 
 <br/>      channel: onMode="1" bRatio="0.0004800" products="100441 323" 
 <br/>      channel: onMode="1" bRatio="0.0006300" products="100443 321" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="100443 323" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="100443 10323" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9000111 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 321" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000111 323" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9000211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000211 311" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000211 313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000085" products="9010221 321" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 323" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 20213" 
 <br/>      channel: onMode="1" bRatio="0.0000260" products="211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="211 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="211 113 113" 
 <br/>      channel: onMode="1" bRatio="0.0000160" products="211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="213 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="213 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="213 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="213 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-213 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 213 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="221 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="223 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="223 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="223 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="223 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="223 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="313 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="313 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="313 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="313 -313 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-313 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000006" meMode="11" products="321 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000006" meMode="11" products="321 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000001" meMode="11" products="321 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000049" products="321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 223 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 223" 
 <br/>      channel: onMode="1" bRatio="0.0000480" products="321 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 313 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 -313 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -313 311" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000260" products="321 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 213" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="-321 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000018" meMode="11" products="323 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000014" meMode="11" products="323 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000002" meMode="11" products="323 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="323 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="323 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="323 221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="323 223 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="323 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="323 -313 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-323 321 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-323 321 321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 213 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 223 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 311 213" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 313 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 223" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 -313" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 323 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 323 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 323 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 323 223" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 323 311" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 323 -313" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 331 321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="333 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="333 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 311 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 321 113" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="333 321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 321 223" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 323 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="333 331 211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="333 331 213" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="333 331 321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 333 211" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="333 333 321" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="333 333 323" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="411 -411 321" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="411 -411 323" 
 <br/>      channel: onMode="1" bRatio="0.0010200" products="-411 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="-411 213 211" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="413 -411 321" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="413 -411 323" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="413 -413 321" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="413 -413 323" 
 <br/>      channel: onMode="1" bRatio="0.0012500" products="-413 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="-413 213 211" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="-413 411 321" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-413 411 323" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="421 -421 321" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="421 -421 323" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-421 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0021000" products="-421 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0017000" products="-421 411 311" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-421 411 313" 
 <br/>      channel: onMode="1" bRatio="0.0049000" products="-421 413 311" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-421 413 313" 
 <br/>      channel: onMode="1" bRatio="0.0047000" products="423 -421 321" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="423 -421 323" 
 <br/>      channel: onMode="1" bRatio="0.0070000" products="423 -423 321" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="423 -423 323" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-423 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-423 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-423 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0031000" products="-423 411 311" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-423 411 313" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="-423 413 311" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-423 413 313" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="-423 421 321" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-423 421 323" 
 <br/>      channel: onMode="1" bRatio="0.0036000" products="431 -411 211" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="431 -421 111" 
 <br/>      channel: onMode="1" bRatio="0.0037000" products="433 -411 211" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="433 -421 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="441 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="441 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="443 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="443 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000900" products="443 333 321" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="445 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="445 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10311 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10311 331 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 333 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10311 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10321 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10321 331 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 333 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10321 333 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10321 333 331" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10321 321 321" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="10441 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="10441 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="20113 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20113 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20113 331 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="20213 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20213 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20213 331 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-20213 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20313 333 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20323 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20323 333 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20323 333 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20323 333 331" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="20443 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="20443 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="30443 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="30443 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000800" products="100441 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="100441 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="100443 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="100443 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9000111 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000111 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000111 323 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9000111 331 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9000211 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9000211 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000211 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9000211 313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9000211 331 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-9000211 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9010221 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 313 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 323 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="9010221 323 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9010221 331 213" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9010221 331 323" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 333 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 333 321" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="211 113 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="211 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="211 211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="213 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="213 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-213 211 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 211 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="221 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 213 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 213 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 -213 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="221 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 221 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="223 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="223 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 211 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 213 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 213 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 -213 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="311 221 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 221 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 223 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="311 311 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="311 311 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 311 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="313 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="313 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="313 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-313 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 113 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 221 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 221 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 223 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 223 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 -213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 311 221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 311 221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 311 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 313 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -313 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 -313 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -313 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 321 -321 113" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 321 -321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 321 -321 223" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 321 -321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 -321 221 211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="321 -321 221 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 223 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -321 311 213" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-321 311 213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-321 313 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="323 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="323 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="323 221 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="323 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="323 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="323 -321 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-323 311 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-323 321 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-323 321 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 211 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 213 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 213 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 -213 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 223 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 311 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 311 311 213" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 313 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 311 113" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 321 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 -313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 321 -321 213" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 323 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 323 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 323 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="331 323 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="333 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="333 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="333 321 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 323 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 323 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="333 331 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="333 331 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="-411 211 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0150000" products="-413 211 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-421 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-423 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="-423 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0033000" products="431 -411 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="431 -421 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0033000" products="431 -421 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0033000" products="433 -411 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="433 -421 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0033000" products="433 -421 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="441 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="441 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="441 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="445 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="445 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="445 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10311 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10311 321 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10311 321 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10311 331 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10311 331 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10311 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10311 321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="-10311 321 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10311 321 321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-10311 331 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10321 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="10321 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="10321 321 -321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10321 331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="10321 331 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-10321 321 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="-10321 321 321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-10321 331 321 321" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="10441 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="10441 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="10441 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20313 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="20313 321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="20313 321 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20313 321 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20313 331 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-20313 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="-20313 321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="-20313 321 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-20313 331 321 311" 
 <br/>      channel: onMode="1" bRatio="0.0000040" products="20323 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20323 311 311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20323 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20323 321 -321 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="20323 331 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="20323 331 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-20323 321 321 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="20443 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="20443 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="20443 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="30443 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="30443 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="30443 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="100441 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="100441 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000800" products="100441 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="100443 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="100443 321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="100443 321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000111 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9000211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="-9000211 211 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9010221 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="9010221 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="9010221 321 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="9010221 331 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="211 111 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="211 211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="221 211 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="311 211 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 221 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 221 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="311 221 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="311 311 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="311 311 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="311 311 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="311 311 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 111 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="321 211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 221 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 221 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 221 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 311 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 311 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 311 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 311 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 311 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 311 311 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 311 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 321 -321 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="321 321 -321 221 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 321 -321 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 321 -321 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 -321 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="321 -321 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="321 -321 221 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="321 -321 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="321 -321 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="-321 311 211 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="-321 311 221 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 211 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 211 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 311 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 311 311 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="331 321 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 321 311 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 321 311 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="331 321 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 321 -321 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 -321 311 211 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 311 311 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 321 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 321 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="55" products="-3 2" 
 <br/>      channel: onMode="1" bRatio="0.0330000" meMode="63" products="-4103 2203" 
 <br/>      channel: onMode="1" bRatio="0.0090000" meMode="63" products="-4303 2203" 
 <br/>      channel: onMode="1" bRatio="0.0000700" meMode="23" products="1 -1 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0018000" meMode="23" products="1 -1 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0030000" meMode="23" products="2 -1 -2 2" 
 <br/>      channel: onMode="1" bRatio="0.0020500" meMode="23" products="2 -2 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0022000" meMode="23" products="2 -2 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0225000" meMode="43" products="2 -3 -4 2" 
 <br/>      channel: onMode="1" bRatio="0.0000900" meMode="23" products="3 -3 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0015000" meMode="23" products="3 -3 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0040000" meMode="43" products="4 -1 -4 2" 
 <br/>      channel: onMode="1" bRatio="0.0040000" meMode="23" products="4 -3 -2 2" 
 <br/>      channel: onMode="1" bRatio="0.0740000" meMode="43" products="4 -3 -4 2" 
 <br/>      channel: onMode="2" bRatio="0.0019480" meMode="22" products="12 -11 2 -2" 
 <br/>      channel: onMode="2" bRatio="0.0019480" meMode="22" products="14 -13 2 -2" 
 <br/>      channel: onMode="2" bRatio="0.0000200" products="445 323" 
 <br/>      channel: onMode="2" bRatio="0.0000010" products="333 321 313 311" 
 <br/>      channel: onMode="2" bRatio="0.0000020" products="-20313 321 321 -211" 
 <br/>      channel: onMode="2" bRatio="0.0003118" meMode="31" products="2 -3 22" 
 <br/>      channel: onMode="2" bRatio="0.2682660" meMode="23" products="2 -1 -4 2" 
 <br/>      channel: onMode="2" bRatio="0.0000050" meMode="12" products="2 -3 11 -11" 
 <br/>      channel: onMode="2" bRatio="0.0000025" meMode="12" products="2 -3 13 -13" 
 <br/>      channel: onMode="2" bRatio="0.0000002" meMode="12" products="2 -3 15 -15" 
 <br/>      channel: onMode="3" bRatio="0.0019480" meMode="22" products="12 -11 -2 2" 
 <br/>      channel: onMode="3" bRatio="0.0019480" meMode="22" products="14 -13 -2 2" 
 <br/>      channel: onMode="3" bRatio="0.0000400" products="445 323" 
 <br/>      channel: onMode="3" bRatio="0.0000010" products="333 321 -313 311" 
 <br/>      channel: onMode="3" bRatio="0.0000020" products="20313 321 321 -211" 
 <br/>      channel: onMode="3" bRatio="0.0003118" meMode="31" products="-3 2 22" 
 <br/>      channel: onMode="3" bRatio="0.2683360" meMode="23" products="2 -1 -4 2" 
 <br/>      channel: onMode="3" bRatio="0.0000050" meMode="12" products="-3 2 11 -11" 
 <br/>      channel: onMode="3" bRatio="0.0000025" meMode="12" products="-3 2 13 -13" 
 <br/>      channel: onMode="3" bRatio="0.0000002" meMode="12" products="-3 2 15 -15" 
 
<p/>particle: id="523" name="B*+" antiName="B*-" spinType="3" chargeType="3" colType="0" 
          m0="5.32520" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="521 22" 
 
<p/>particle: id="525" name="B*_2+" antiName="B*_2-" spinType="5" chargeType="3" colType="0" 
          m0="5.74300" mWidth="0.02300" mMin="5.63000" mMax="6.03000" 
 <br/>      channel: onMode="1" bRatio="0.3100000" products="513 211" 
 <br/>      channel: onMode="1" bRatio="0.1500000" products="523 111" 
 <br/>      channel: onMode="1" bRatio="0.3100000" products="511 211" 
 <br/>      channel: onMode="1" bRatio="0.1500000" products="521 111" 
 <br/>      channel: onMode="1" bRatio="0.0500000" products="513 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0300000" products="523 211 -211" 
 
<p/>particle: id="531" name="B_s0" antiName="B_sbar0" spinType="1" chargeType="0" colType="0" 
          m0="5.36677" tau0="4.39000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0002000" meMode="22" products="12 -11 -321" 
 <br/>      channel: onMode="1" bRatio="0.0003000" meMode="22" products="12 -11 -323" 
 <br/>      channel: onMode="1" bRatio="0.0210000" meMode="22" products="12 -11 -431" 
 <br/>      channel: onMode="1" bRatio="0.0490000" meMode="22" products="12 -11 -433" 
 <br/>      channel: onMode="1" bRatio="0.0070000" meMode="22" products="12 -11 -435" 
 <br/>      channel: onMode="1" bRatio="0.0003000" meMode="22" products="12 -11 -10323" 
 <br/>      channel: onMode="1" bRatio="0.0040000" meMode="22" products="12 -11 -10431" 
 <br/>      channel: onMode="1" bRatio="0.0070000" meMode="22" products="12 -11 -10433" 
 <br/>      channel: onMode="1" bRatio="0.0002000" meMode="22" products="12 -11 -20323" 
 <br/>      channel: onMode="1" bRatio="0.0040000" meMode="22" products="12 -11 -20433" 
 <br/>      channel: onMode="1" bRatio="0.0002000" meMode="22" products="14 -13 -321" 
 <br/>      channel: onMode="1" bRatio="0.0003000" meMode="22" products="14 -13 -323" 
 <br/>      channel: onMode="1" bRatio="0.0210000" meMode="22" products="14 -13 -431" 
 <br/>      channel: onMode="1" bRatio="0.0490000" meMode="22" products="14 -13 -433" 
 <br/>      channel: onMode="1" bRatio="0.0070000" meMode="22" products="14 -13 -435" 
 <br/>      channel: onMode="1" bRatio="0.0003000" meMode="22" products="14 -13 -10323" 
 <br/>      channel: onMode="1" bRatio="0.0040000" meMode="22" products="14 -13 -10431" 
 <br/>      channel: onMode="1" bRatio="0.0070000" meMode="22" products="14 -13 -10433" 
 <br/>      channel: onMode="1" bRatio="0.0002000" meMode="22" products="14 -13 -20323" 
 <br/>      channel: onMode="1" bRatio="0.0040000" meMode="22" products="14 -13 -20433" 
 <br/>      channel: onMode="1" bRatio="0.0080000" meMode="22" products="16 -15 -431" 
 <br/>      channel: onMode="1" bRatio="0.0160000" meMode="22" products="16 -15 -433" 
 <br/>      channel: onMode="1" bRatio="0.0028000" meMode="22" products="16 -15 -435" 
 <br/>      channel: onMode="1" bRatio="0.0018000" meMode="22" products="16 -15 -10431" 
 <br/>      channel: onMode="1" bRatio="0.0028000" meMode="22" products="16 -15 -10433" 
 <br/>      channel: onMode="1" bRatio="0.0018000" meMode="22" products="16 -15 -20433" 
 <br/>      channel: onMode="1" bRatio="0.0000005" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000040" products="221 221" 
 <br/>      channel: onMode="1" bRatio="0.0000012" products="223 221" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="311 113" 
 <br/>      channel: onMode="1" bRatio="0.0000002" products="311 221" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="311 223" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="313 130" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="313 310" 
 <br/>      channel: onMode="1" bRatio="0.0000040" products="313 -313" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-313 111" 
 <br/>      channel: onMode="1" bRatio="0.0000008" products="-313 113" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-313 130" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="-313 221" 
 <br/>      channel: onMode="1" bRatio="0.0000020" products="-313 310" 
 <br/>      channel: onMode="1" bRatio="0.0000185" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000048" products="-321 211" 
 <br/>      channel: onMode="1" bRatio="0.0000120" products="-321 213" 
 <br/>      channel: onMode="1" bRatio="0.0000046" products="323 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="323 -323" 
 <br/>      channel: onMode="1" bRatio="0.0000250" products="-323 211" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="-323 213" 
 <br/>      channel: onMode="1" bRatio="0.0000082" products="-323 321" 
 <br/>      channel: onMode="1" bRatio="0.0000250" products="331 221" 
 <br/>      channel: onMode="1" bRatio="0.0000025" products="331 223" 
 <br/>      channel: onMode="1" bRatio="0.0000001" products="331 311" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="331 -313" 
 <br/>      channel: onMode="1" bRatio="0.0000580" products="331 331" 
 <br/>      channel: onMode="1" bRatio="0.0000450" products="333 22" 
 <br/>      channel: onMode="1" bRatio="0.0000213" products="333 221" 
 <br/>      channel: onMode="1" bRatio="0.0000004" products="333 -313" 
 <br/>      channel: onMode="1" bRatio="0.0000125" products="333 331" 
 <br/>      channel: onMode="1" bRatio="0.0000080" products="333 333" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="-421 311" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="-421 -313" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="-423 311" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="-423 -313" 
 <br/>      channel: onMode="1" bRatio="0.0017000" products="431 -411" 
 <br/>      channel: onMode="1" bRatio="0.0017000" products="431 -413" 
 <br/>      channel: onMode="1" bRatio="0.0086000" products="431 -431" 
 <br/>      channel: onMode="1" bRatio="0.0026000" products="-431 211" 
 <br/>      channel: onMode="1" bRatio="0.0073000" products="-431 213" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="-431 321" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="-431 323" 
 <br/>      channel: onMode="1" bRatio="0.0017000" products="433 -411" 
 <br/>      channel: onMode="1" bRatio="0.0017000" products="433 -413" 
 <br/>      channel: onMode="1" bRatio="0.0197000" products="433 -433" 
 <br/>      channel: onMode="1" bRatio="0.0027000" products="-433 211" 
 <br/>      channel: onMode="1" bRatio="0.0070000" products="-433 213" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="-433 321" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="-433 323" 
 <br/>      channel: onMode="1" bRatio="0.0013000" products="-435 211" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="441 221" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="441 331" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="441 333" 
 <br/>      channel: onMode="1" bRatio="0.0003200" products="443 221" 
 <br/>      channel: onMode="1" bRatio="0.0000800" products="443 311" 
 <br/>      channel: onMode="1" bRatio="0.0006400" products="443 331" 
 <br/>      channel: onMode="1" bRatio="0.0013500" products="443 333" 
 <br/>      channel: onMode="1" bRatio="0.0002350" products="445 221" 
 <br/>      channel: onMode="1" bRatio="0.0004650" products="445 331" 
 <br/>      channel: onMode="1" bRatio="0.0000500" products="10441 221" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="10441 331" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="10441 333" 
 <br/>      channel: onMode="1" bRatio="0.0002350" products="10443 221" 
 <br/>      channel: onMode="1" bRatio="0.0004650" products="10443 331" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="10443 333" 
 <br/>      channel: onMode="1" bRatio="0.0085000" products="20213 -431" 
 <br/>      channel: onMode="1" bRatio="0.0122000" products="20213 -433" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="-20433 211" 
 <br/>      channel: onMode="1" bRatio="0.0021000" products="-20433 213" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="20443 221" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="20443 331" 
 <br/>      channel: onMode="1" bRatio="0.0014000" products="20443 333" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="100441 221" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="100441 331" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="100441 333" 
 <br/>      channel: onMode="1" bRatio="0.0002350" products="100443 221" 
 <br/>      channel: onMode="1" bRatio="0.0004650" products="100443 331" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="100443 333" 
 <br/>      channel: onMode="1" bRatio="0.0000023" meMode="11" products="333 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000023" meMode="11" products="333 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="411 -411 311" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="413 -411 311" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="421 411 -321" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="-421 413 -321" 
 <br/>      channel: onMode="1" bRatio="0.0096000" products="431 -411 311" 
 <br/>      channel: onMode="1" bRatio="0.0096000" products="431 421 -321" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="-431 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="-431 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="-431 411 311" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-431 411 313" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-431 413 311" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-431 413 313" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="-431 421 321" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-431 421 323" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-431 423 321" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-431 423 323" 
 <br/>      channel: onMode="1" bRatio="0.0096000" products="433 -411 311" 
 <br/>      channel: onMode="1" bRatio="0.0096000" products="433 -421 -321" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-433 211 113" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-433 213 111" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-433 411 311" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-433 411 313" 
 <br/>      channel: onMode="1" bRatio="0.0150000" products="-433 413 311" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="-433 413 313" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-433 421 321" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="-433 421 323" 
 <br/>      channel: onMode="1" bRatio="0.0150000" products="-433 423 321" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="-433 423 323" 
 <br/>      channel: onMode="1" bRatio="0.0002800" products="441 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0002800" products="441 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="443 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="443 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="443 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="443 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="445 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="445 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="10441 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="10441 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="10443 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="10443 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0002600" products="20443 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0002600" products="20443 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0001200" products="100441 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0001200" products="100441 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="100443 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="100443 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="100443 311 311" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="100443 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="411 -411 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="411 -411 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="413 -411 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="413 -411 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="-421 411 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="-421 411 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="-421 413 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="-421 413 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0024000" products="431 -411 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0048000" products="431 -411 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0048000" products="431 -421 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0024000" products="431 -421 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="-431 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="-431 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0024000" products="433 -411 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0048000" products="433 -411 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0048000" products="433 -421 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0024000" products="433 -421 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-433 211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0077000" products="-433 211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="441 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="441 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002800" products="441 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0002800" products="441 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0002800" products="441 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="441 331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="441 331 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="441 333 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="441 333 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="443 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="443 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="443 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="443 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="443 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="443 331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="443 331 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0003900" products="443 333 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0003900" products="443 333 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="445 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="445 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="445 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="10441 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="10441 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="10441 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="10443 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="10443 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="10443 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="20443 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="20443 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002600" products="20443 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0002600" products="20443 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0002600" products="20443 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="20443 331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="20443 331 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="20443 333 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="20443 333 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001200" products="100441 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0001200" products="100441 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0001200" products="100441 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="100443 221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="100443 221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="100443 311 311 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="100443 321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="100443 -321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="100443 331 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="100443 331 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0003400" products="100443 333 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0003400" products="100443 333 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="55" products="-3 3" 
 <br/>      channel: onMode="1" bRatio="0.0200000" meMode="63" products="-4301 2101" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="63" products="-4303 2103" 
 <br/>      channel: onMode="1" bRatio="0.0007000" meMode="23" products="1 -1 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0016000" meMode="23" products="1 -1 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.3574344" meMode="23" products="2 -1 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0036000" meMode="23" products="2 -2 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="23" products="2 -2 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0172000" meMode="23" products="2 -3 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0195000" meMode="23" products="2 -4 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0009000" meMode="23" products="2 -4 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0009000" meMode="23" products="3 -3 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0013000" meMode="23" products="3 -3 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0070000" meMode="43" products="4 -1 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0040000" meMode="23" products="4 -3 -2 3" 
 <br/>      channel: onMode="2" bRatio="0.0090000" products="433 -431" 
 <br/>      channel: onMode="2" bRatio="0.0099000" products="-433 431" 
 <br/>      channel: onMode="3" bRatio="0.0099000" products="433 -431" 
 <br/>      channel: onMode="3" bRatio="0.0090000" products="-433 431" 
 
<p/>particle: id="533" name="B*_s0" antiName="B*_sbar0" spinType="3" chargeType="0" colType="0" 
          m0="5.41540" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="531 22" 
 
<p/>particle: id="535" name="B*_2s0" antiName="B*_2sbar0" spinType="5" chargeType="0" colType="0" 
          m0="5.83970" mWidth="0.02000" mMin="5.81970" mMax="5.85970" 
 <br/>      channel: onMode="1" bRatio="0.1700000" products="513 311" 
 <br/>      channel: onMode="1" bRatio="0.1700000" products="523 -321" 
 <br/>      channel: onMode="1" bRatio="0.3300000" products="511 311" 
 <br/>      channel: onMode="1" bRatio="0.3300000" products="521 -321" 
 
<p/>particle: id="541" name="B_c+" antiName="B_c-" spinType="1" chargeType="3" colType="0" 
          m0="6.27700" tau0="1.38000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0160000" products="16 -15" 
 <br/>      channel: onMode="1" bRatio="0.0034000" meMode="22" products="-11 12 511" 
 <br/>      channel: onMode="1" bRatio="0.0058000" meMode="22" products="-11 12 513" 
 <br/>      channel: onMode="1" bRatio="0.0403000" meMode="22" products="-11 12 531" 
 <br/>      channel: onMode="1" bRatio="0.0506000" meMode="22" products="-11 12 533" 
 <br/>      channel: onMode="1" bRatio="0.0000400" meMode="22" products="12 -11 421" 
 <br/>      channel: onMode="1" bRatio="0.0001800" meMode="22" products="12 -11 423" 
 <br/>      channel: onMode="1" bRatio="0.0075000" meMode="22" products="12 -11 441" 
 <br/>      channel: onMode="1" bRatio="0.0190000" meMode="22" products="12 -11 443" 
 <br/>      channel: onMode="1" bRatio="0.0002000" meMode="22" products="12 -11 100441" 
 <br/>      channel: onMode="1" bRatio="0.0009400" meMode="22" products="12 -11 100443" 
 <br/>      channel: onMode="1" bRatio="0.0034000" meMode="22" products="-13 14 511" 
 <br/>      channel: onMode="1" bRatio="0.0058000" meMode="22" products="-13 14 513" 
 <br/>      channel: onMode="1" bRatio="0.0403000" meMode="22" products="-13 14 531" 
 <br/>      channel: onMode="1" bRatio="0.0506000" meMode="22" products="-13 14 533" 
 <br/>      channel: onMode="1" bRatio="0.0000400" meMode="22" products="14 -13 421" 
 <br/>      channel: onMode="1" bRatio="0.0001800" meMode="22" products="14 -13 423" 
 <br/>      channel: onMode="1" bRatio="0.0075000" meMode="22" products="14 -13 441" 
 <br/>      channel: onMode="1" bRatio="0.0190000" meMode="22" products="14 -13 443" 
 <br/>      channel: onMode="1" bRatio="0.0002000" meMode="22" products="14 -13 100441" 
 <br/>      channel: onMode="1" bRatio="0.0009400" meMode="22" products="14 -13 100443" 
 <br/>      channel: onMode="1" bRatio="0.0000200" meMode="22" products="16 -15 421" 
 <br/>      channel: onMode="1" bRatio="0.0000800" meMode="22" products="16 -15 423" 
 <br/>      channel: onMode="1" bRatio="0.0023000" meMode="22" products="16 -15 441" 
 <br/>      channel: onMode="1" bRatio="0.0048000" meMode="22" products="16 -15 443" 
 <br/>      channel: onMode="1" bRatio="0.0000160" meMode="22" products="16 -15 100441" 
 <br/>      channel: onMode="1" bRatio="0.0000800" meMode="22" products="16 -15 100443" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="211 113" 
 <br/>      channel: onMode="1" bRatio="0.0000003" products="421 411" 
 <br/>      channel: onMode="1" bRatio="0.0000004" products="421 413" 
 <br/>      channel: onMode="1" bRatio="0.0000530" products="-421 411" 
 <br/>      channel: onMode="1" bRatio="0.0000490" products="-421 413" 
 <br/>      channel: onMode="1" bRatio="0.0000003" products="423 411" 
 <br/>      channel: onMode="1" bRatio="0.0000016" products="423 413" 
 <br/>      channel: onMode="1" bRatio="0.0000750" products="-423 411" 
 <br/>      channel: onMode="1" bRatio="0.0003300" products="-423 413" 
 <br/>      channel: onMode="1" bRatio="0.0000066" products="431 421" 
 <br/>      channel: onMode="1" bRatio="0.0000048" products="431 -421" 
 <br/>      channel: onMode="1" bRatio="0.0000063" products="431 423" 
 <br/>      channel: onMode="1" bRatio="0.0000071" products="431 -423" 
 <br/>      channel: onMode="1" bRatio="0.0000085" products="433 421" 
 <br/>      channel: onMode="1" bRatio="0.0000045" products="433 -421" 
 <br/>      channel: onMode="1" bRatio="0.0000404" products="433 423" 
 <br/>      channel: onMode="1" bRatio="0.0000260" products="433 -423" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="441 211" 
 <br/>      channel: onMode="1" bRatio="0.0042000" products="441 213" 
 <br/>      channel: onMode="1" bRatio="0.0001300" products="441 321" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="441 323" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="441 411" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="441 413" 
 <br/>      channel: onMode="1" bRatio="0.0028000" products="441 431" 
 <br/>      channel: onMode="1" bRatio="0.0027000" products="441 433" 
 <br/>      channel: onMode="1" bRatio="0.0013000" products="443 211" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="443 213" 
 <br/>      channel: onMode="1" bRatio="0.0001100" products="443 321" 
 <br/>      channel: onMode="1" bRatio="0.0002200" products="443 323" 
 <br/>      channel: onMode="1" bRatio="0.0000900" products="443 411" 
 <br/>      channel: onMode="1" bRatio="0.0002800" products="443 413" 
 <br/>      channel: onMode="1" bRatio="0.0017000" products="443 431" 
 <br/>      channel: onMode="1" bRatio="0.0067000" products="443 433" 
 <br/>      channel: onMode="1" bRatio="0.0106000" products="511 211" 
 <br/>      channel: onMode="1" bRatio="0.0096000" products="511 213" 
 <br/>      channel: onMode="1" bRatio="0.0007000" products="511 321" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="511 323" 
 <br/>      channel: onMode="1" bRatio="0.0095000" products="513 211" 
 <br/>      channel: onMode="1" bRatio="0.0257000" products="513 213" 
 <br/>      channel: onMode="1" bRatio="0.0005500" products="513 321" 
 <br/>      channel: onMode="1" bRatio="0.0005800" products="513 323" 
 <br/>      channel: onMode="1" bRatio="0.0003700" products="521 111" 
 <br/>      channel: onMode="1" bRatio="0.0003400" products="521 113" 
 <br/>      channel: onMode="1" bRatio="0.0198000" products="521 311" 
 <br/>      channel: onMode="1" bRatio="0.0003300" products="523 111" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="523 113" 
 <br/>      channel: onMode="1" bRatio="0.0160000" products="523 311" 
 <br/>      channel: onMode="1" bRatio="0.1640000" products="531 211" 
 <br/>      channel: onMode="1" bRatio="0.0720000" products="531 213" 
 <br/>      channel: onMode="1" bRatio="0.0106000" products="531 321" 
 <br/>      channel: onMode="1" bRatio="0.0650000" products="533 211" 
 <br/>      channel: onMode="1" bRatio="0.2020000" products="533 213" 
 <br/>      channel: onMode="1" bRatio="0.0037000" products="533 321" 
 <br/>      channel: onMode="1" bRatio="0.0600502" meMode="42" products="4 -3" 
 <br/>      channel: onMode="2" bRatio="0.0043000" products="521 313" 
 <br/>      channel: onMode="2" bRatio="0.0167000" products="523 313" 
 <br/>      channel: onMode="3" bRatio="0.0043000" products="521 -313" 
 <br/>      channel: onMode="3" bRatio="0.0167000" products="523 -313" 
 
<p/>particle: id="543" name="B*_c+" antiName="B*_c-" spinType="3" chargeType="3" colType="0" 
          m0="6.34000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="541 22" 
 
<p/>particle: id="545" name="B*_2c+" antiName="B*_2c-" spinType="5" chargeType="3" colType="0" 
          m0="7.35000" mWidth="0.02000" mMin="7.20000" mMax="7.50000" 
 <br/>      channel: onMode="1" bRatio="0.3000000" products="511 411" 
 <br/>      channel: onMode="1" bRatio="0.3000000" products="521 421" 
 <br/>      channel: onMode="1" bRatio="0.2000000" products="513 411" 
 <br/>      channel: onMode="1" bRatio="0.2000000" products="523 421" 
 
<p/>particle: id="551" name="eta_b" spinType="1" chargeType="0" colType="0" 
          m0="9.40000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="91" products="21 21" 
 
<p/>particle: id="553" name="Upsilon" spinType="3" chargeType="0" colType="0" 
          m0="9.46030" mWidth="0.00005" mMin="9.45980" mMax="9.46080" 
 <br/>      channel: onMode="1" bRatio="0.7757000" meMode="92" products="21 21 21" 
 <br/>      channel: onMode="1" bRatio="0.0290000" meMode="92" products="22 21 21" 
 <br/>      channel: onMode="1" bRatio="0.0238000" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0248000" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0267000" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="91" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0450000" meMode="91" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="91" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0450000" meMode="91" products="4 -4" 
 
<p/>particle: id="555" name="chi_2b" spinType="5" chargeType="0" colType="0" 
          m0="9.91220" 
 <br/>      channel: onMode="1" bRatio="0.2200000" products="553 22" 
 <br/>      channel: onMode="1" bRatio="0.7800000" meMode="91" products="21 21" 
 
<p/>particle: id="990" name="Pomeron" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="1103" name="dd_1" antiName="dd_1bar" spinType="3" chargeType="-2" colType="-1" 
          m0="0.77133" 
 
<p/>particle: id="1114" name="Delta-" antiName="Deltabar+" spinType="4" chargeType="-3" colType="0" 
          m0="1.23200" mWidth="0.11700" mMin="1.08000" mMax="1.60000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="2112 -211" 
 
<p/>particle: id="2101" name="ud_0" antiName="ud_0bar" spinType="1" chargeType="1" colType="-1" 
          m0="0.57933" 
 
<p/>particle: id="2103" name="ud_1" antiName="ud_1bar" spinType="3" chargeType="1" colType="-1" 
          m0="0.77133" 
 
<p/>particle: id="2112" name="n0" antiName="nbar0" spinType="2" chargeType="0" colType="0" 
          m0="0.93957" tau0="2.65500e+14" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="22" products="-12 11 2212" 
 
<p/>particle: id="2114" name="Delta0" antiName="Deltabar0" spinType="4" chargeType="0" colType="0" 
          m0="1.23200" mWidth="0.11700" mMin="1.08000" mMax="1.60000" 
 <br/>      channel: onMode="1" bRatio="0.3314104" products="2212 -211" 
 <br/>      channel: onMode="1" bRatio="0.6630208" products="2112 111" 
 <br/>      channel: onMode="1" bRatio="0.0055688" products="2112 22" 
 
<p/>particle: id="2203" name="uu_1" antiName="uu_1bar" spinType="3" chargeType="4" colType="-1" 
          m0="0.77133" 
 
<p/>particle: id="2212" name="p+" antiName="pbar-" spinType="2" chargeType="3" colType="0" 
          m0="0.93827" 
 
<p/>particle: id="2214" name="Delta+" antiName="Deltabar-" spinType="4" chargeType="3" colType="0" 
          m0="1.23200" mWidth="0.11700" mMin="1.08000" mMax="1.60000" 
 <br/>      channel: onMode="1" bRatio="0.6630208" products="2212 111" 
 <br/>      channel: onMode="1" bRatio="0.3314104" products="2112 211" 
 <br/>      channel: onMode="1" bRatio="0.0055688" products="2212 22" 
 
<p/>particle: id="2224" name="Delta++" antiName="Deltabar--" spinType="4" chargeType="6" colType="0" 
          m0="1.23200" mWidth="0.11700" mMin="1.08000" mMax="1.60000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="2212 211" 
 
<p/>particle: id="3101" name="sd_0" antiName="sd_0bar" spinType="1" chargeType="-2" colType="-1" 
          m0="0.80473" 
 
<p/>particle: id="3103" name="sd_1" antiName="sd_1bar" spinType="3" chargeType="-2" colType="-1" 
          m0="0.92953" 
 
<p/>particle: id="3112" name="Sigma-" antiName="Sigmabar+" spinType="2" chargeType="-3" colType="0" 
          m0="1.19745" tau0="4.43400e+01" 
 <br/>      channel: onMode="1" bRatio="0.9984757" products="2112 -211" 
 <br/>      channel: onMode="1" bRatio="0.0010170" meMode="22" products="-12 11 2112" 
 <br/>      channel: onMode="1" bRatio="0.0004500" meMode="22" products="-14 13 2112" 
 <br/>      channel: onMode="1" bRatio="0.0000573" meMode="22" products="-12 11 3122" 
 
<p/>particle: id="3114" name="Sigma*-" antiName="Sigma*bar+" spinType="4" chargeType="-3" colType="0" 
          m0="1.38720" mWidth="0.03940" mMin="1.34000" mMax="1.70000" 
 <br/>      channel: onMode="1" bRatio="0.8814590" products="3122 -211" 
 <br/>      channel: onMode="1" bRatio="0.0592705" products="3212 -211" 
 <br/>      channel: onMode="1" bRatio="0.0592705" products="3112 111" 
 
<p/>particle: id="3122" name="Lambda0" antiName="Lambdabar0" spinType="2" chargeType="0" colType="0" 
          m0="1.11568" tau0="7.89000e+01" 
 <br/>      channel: onMode="1" bRatio="0.6391668" products="2212 -211" 
 <br/>      channel: onMode="1" bRatio="0.3580935" products="2112 111" 
 <br/>      channel: onMode="1" bRatio="0.0017505" products="2112 22" 
 <br/>      channel: onMode="1" bRatio="0.0008322" meMode="22" products="-12 11 2212" 
 <br/>      channel: onMode="1" bRatio="0.0001570" meMode="22" products="-14 13 2212" 
 
<p/>particle: id="3124" name="Lambda(1520)0" antiName="Lambda(1520)bar0" spinType="4" chargeType="0" colType="0" 
          m0="1.51950" mWidth="0.01560" mMin="1.40000" mMax="1.65000" 
 <br/>      channel: onMode="1" bRatio="0.2300000" products="2212 -321" 
 <br/>      channel: onMode="1" bRatio="0.2300000" products="2112 -311" 
 <br/>      channel: onMode="1" bRatio="0.1400000" products="3222 -211" 
 <br/>      channel: onMode="1" bRatio="0.1400000" products="3112 211" 
 <br/>      channel: onMode="1" bRatio="0.1400000" products="3212 111" 
 <br/>      channel: onMode="1" bRatio="0.0333000" products="3122 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0667000" products="3122 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="3222 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="3112 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="3212 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3212 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0110000" products="3122 22" 
 
<p/>particle: id="3201" name="su_0" antiName="su_0bar" spinType="1" chargeType="1" colType="-1" 
          m0="0.80473" 
 
<p/>particle: id="3203" name="su_1" antiName="su_1bar" spinType="3" chargeType="1" colType="-1" 
          m0="0.92953" 
 
<p/>particle: id="3212" name="Sigma0" antiName="Sigmabar0" spinType="2" chargeType="0" colType="0" 
          m0="1.19264" 
 <br/>      channel: onMode="1" bRatio="0.9950249" products="3122 22" 
 <br/>      channel: onMode="1" bRatio="0.0049751" meMode="11" products="3122 11 -11" 
 
<p/>particle: id="3214" name="Sigma*0" antiName="Sigma*bar0" spinType="4" chargeType="0" colType="0" 
          m0="1.38370" mWidth="0.03600" mMin="1.34000" mMax="1.70000" 
 <br/>      channel: onMode="1" bRatio="0.8700000" products="3122 111" 
 <br/>      channel: onMode="1" bRatio="0.0585000" products="3222 -211" 
 <br/>      channel: onMode="1" bRatio="0.0585000" products="3112 211" 
 <br/>      channel: onMode="1" bRatio="0.0130000" products="3122 22" 
 
<p/>particle: id="3222" name="Sigma+" antiName="Sigmabar-" spinType="2" chargeType="3" colType="0" 
          m0="1.18937" tau0="2.40400e+01" 
 <br/>      channel: onMode="1" bRatio="0.5156743" products="2212 111" 
 <br/>      channel: onMode="1" bRatio="0.4830758" products="2112 211" 
 <br/>      channel: onMode="1" bRatio="0.0012299" products="2212 22" 
 <br/>      channel: onMode="1" bRatio="0.0000200" meMode="22" products="-11 12 3122" 
 
<p/>particle: id="3224" name="Sigma*+" antiName="Sigma*bar-" spinType="4" chargeType="3" colType="0" 
          m0="1.38280" mWidth="0.03600" mMin="1.34000" mMax="1.70000" 
 <br/>      channel: onMode="1" bRatio="0.8814590" products="3122 211" 
 <br/>      channel: onMode="1" bRatio="0.0592705" products="3222 111" 
 <br/>      channel: onMode="1" bRatio="0.0592705" products="3212 211" 
 
<p/>particle: id="3303" name="ss_1" antiName="ss_1bar" spinType="3" chargeType="-2" colType="-1" 
          m0="1.09361" 
 
<p/>particle: id="3312" name="Xi-" antiName="Xibar+" spinType="2" chargeType="-3" colType="0" 
          m0="1.32171" tau0="4.91000e+01" 
 <br/>      channel: onMode="1" bRatio="0.9988730" products="3122 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001270" products="3112 22" 
 <br/>      channel: onMode="1" bRatio="0.0005630" meMode="22" products="-12 11 3122" 
 <br/>      channel: onMode="1" bRatio="0.0003500" meMode="22" products="-14 13 3122" 
 <br/>      channel: onMode="1" bRatio="0.0000870" meMode="22" products="-12 11 3212" 
 
<p/>particle: id="3314" name="Xi*-" antiName="Xi*bar+" spinType="4" chargeType="-3" colType="0" 
          m0="1.53500" mWidth="0.00990" mMin="1.46000" mMax="1.63000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="3322 -211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="3312 111" 
 
<p/>particle: id="3322" name="Xi0" antiName="Xibar0" spinType="2" chargeType="0" colType="0" 
          m0="1.31486" tau0="8.71000e+01" 
 <br/>      channel: onMode="1" bRatio="0.9952424" products="3122 111" 
 <br/>      channel: onMode="1" bRatio="0.0011700" products="3122 22" 
 <br/>      channel: onMode="1" bRatio="0.0033300" products="3212 22" 
 <br/>      channel: onMode="1" bRatio="0.0002530" meMode="22" products="-12 11 3222" 
 <br/>      channel: onMode="1" bRatio="0.0000046" meMode="22" products="-14 13 3222" 
 
<p/>particle: id="3324" name="Xi*0" antiName="Xi*bar0" spinType="4" chargeType="0" colType="0" 
          m0="1.53180" mWidth="0.00910" mMin="1.46000" mMax="1.63000" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="3322 111" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="3312 211" 
 
<p/>particle: id="3334" name="Omega-" antiName="Omegabar+" spinType="4" chargeType="-3" colType="0" 
          m0="1.67245" tau0="2.46100e+01" 
 <br/>      channel: onMode="1" bRatio="0.6737955" products="3122 -321" 
 <br/>      channel: onMode="1" bRatio="0.2345365" products="3322 -211" 
 <br/>      channel: onMode="1" bRatio="0.0854667" products="3312 111" 
 <br/>      channel: onMode="1" bRatio="0.0006360" products="3324 -211" 
 <br/>      channel: onMode="1" bRatio="0.0055653" meMode="22" products="-12 11 3322" 
 
<p/>particle: id="4101" name="cd_0" antiName="cd_0bar" spinType="1" chargeType="1" colType="-1" 
          m0="1.96908" 
 
<p/>particle: id="4103" name="cd_1" antiName="cd_1bar" spinType="3" chargeType="1" colType="-1" 
          m0="2.00808" 
 
<p/>particle: id="4112" name="Sigma_c0" antiName="Sigma_cbar0" spinType="2" chargeType="0" colType="0" 
          m0="2.45374" mWidth="0.00216" mMin="2.43176" mMax="2.47576" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="4122 -211" 
 
<p/>particle: id="4114" name="Sigma*_c0" antiName="Sigma*_cbar0" spinType="4" chargeType="0" colType="0" 
          m0="2.51880" mWidth="0.01450" mMin="2.43000" mMax="2.68000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="4122 -211" 
 
<p/>particle: id="4122" name="Lambda_c+" antiName="Lambda_cbar-" spinType="2" chargeType="3" colType="0" 
          m0="2.28646" tau0="5.99000e-02" 
 <br/>      channel: onMode="1" bRatio="0.0030000" meMode="22" products="-11 12 2112" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="-11 12 2114" 
 <br/>      channel: onMode="1" bRatio="0.0180000" meMode="22" products="-11 12 3122" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-11 12 3212" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-11 12 3214" 
 <br/>      channel: onMode="1" bRatio="0.0030000" meMode="22" products="-13 14 2112" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="-13 14 2114" 
 <br/>      channel: onMode="1" bRatio="0.0180000" meMode="22" products="-13 14 3122" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-13 14 3212" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-13 14 3214" 
 <br/>      channel: onMode="1" bRatio="0.0060000" meMode="22" products="-11 12 2112 111" 
 <br/>      channel: onMode="1" bRatio="0.0060000" meMode="22" products="-11 12 2212 -211" 
 <br/>      channel: onMode="1" bRatio="0.0060000" meMode="22" products="-13 14 2112 111" 
 <br/>      channel: onMode="1" bRatio="0.0060000" meMode="22" products="-13 14 2212 -211" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="2112 211" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="2112 213" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="2114 211" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="2114 213" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="2212 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="2212 113" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="2212 221" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="2212 223" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="2212 311" 
 <br/>      channel: onMode="1" bRatio="0.0400000" products="2212 -313" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="2212 331" 
 <br/>      channel: onMode="1" bRatio="0.0013000" products="2212 333" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="2214 111" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="2214 113" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="2214 221" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="2214 223" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="2214 311" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="2214 -313" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="2214 331" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="2224 -211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="2224 -213" 
 <br/>      channel: onMode="1" bRatio="0.0066000" products="2224 -321" 
 <br/>      channel: onMode="1" bRatio="0.0250000" products="2224 -323" 
 <br/>      channel: onMode="1" bRatio="0.0058000" products="3122 211" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="3122 213" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="3122 321" 
 <br/>      channel: onMode="1" bRatio="0.0050000" products="3122 323" 
 <br/>      channel: onMode="1" bRatio="0.0055000" products="3212 211" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="3212 213" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3212 321" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3212 323" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="3214 211" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="3214 213" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="3214 321" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="3214 323" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="3222 111" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="3222 113" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3222 221" 
 <br/>      channel: onMode="1" bRatio="0.0040000" products="3222 223" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3222 311" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3222 313" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3222 331" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="3224 111" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="3224 113" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3224 221" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="3224 223" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="3224 311" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="3224 313" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3322 321" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3322 323" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="3324 321" 
 <br/>      channel: onMode="1" bRatio="0.0018000" products="9010221 2212" 
 <br/>      channel: onMode="1" bRatio="0.0300000" meMode="43" products="1 2203" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="43" products="2 2101" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="43" products="2 2103" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="43" products="2 3201" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="43" products="2 3203" 
 <br/>      channel: onMode="1" bRatio="0.0950000" meMode="43" products="3 2203" 
 <br/>      channel: onMode="1" bRatio="0.0350000" meMode="43" products="2 -1 1 2101" 
 <br/>      channel: onMode="1" bRatio="0.1300000" meMode="43" products="2 -1 1 3201" 
 <br/>      channel: onMode="1" bRatio="0.0570000" meMode="43" products="2 -1 1 3203" 
 <br/>      channel: onMode="1" bRatio="0.0350000" meMode="43" products="2 -3 1 3201" 
 
<p/>particle: id="4124" name="Lambda_c(2625)+" antiName="Lambda_c(2625)-" spinType="4" chargeType="3" colType="0" 
          m0="2.62810" 
 <br/>      channel: onMode="1" bRatio="0.6600000" products="4122 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.3300000" products="4122 111" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="4122 22" 
 
<p/>particle: id="4132" name="Xi_c0" antiName="Xi_cbar0" spinType="2" chargeType="0" colType="0" 
          m0="2.47088" tau0="3.36000e-02" 
 <br/>      channel: onMode="1" bRatio="0.0200000" meMode="22" products="-11 12 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-11 12 3 3103" 
 <br/>      channel: onMode="1" bRatio="0.0200000" meMode="22" products="-13 14 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-13 14 3 3103" 
 <br/>      channel: onMode="1" bRatio="0.5400000" meMode="42" products="2 -1 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.2100000" meMode="42" products="3 3201" 
 <br/>      channel: onMode="1" bRatio="0.1000000" meMode="42" products="3 3203" 
 <br/>      channel: onMode="1" bRatio="0.1000000" meMode="42" products="2 3303" 
 
<p/>particle: id="4201" name="cu_0" antiName="cu_0bar" spinType="1" chargeType="4" colType="-1" 
          m0="1.96908" 
 
<p/>particle: id="4203" name="cu_1" antiName="cu_1bar" spinType="3" chargeType="4" colType="-1" 
          m0="2.00808" 
 
<p/>particle: id="4212" name="Sigma_c+" antiName="Sigma_cbar-" spinType="2" chargeType="3" colType="0" 
          m0="2.45290" mWidth="0.00220" mMin="2.43090" mMax="2.47490" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="4122 111" 
 
<p/>particle: id="4214" name="Sigma*_c+" antiName="Sigma*_cbar-" spinType="4" chargeType="3" colType="0" 
          m0="2.51750" mWidth="0.01550" mMin="2.43000" mMax="2.68000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="4122 111" 
 
<p/>particle: id="4222" name="Sigma_c++" antiName="Sigma_cbar--" spinType="2" chargeType="6" colType="0" 
          m0="2.45398" mWidth="0.00226" mMin="2.43202" mMax="2.47602" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="4122 211" 
 
<p/>particle: id="4224" name="Sigma*_c++" antiName="Sigma*_cbar--" spinType="4" chargeType="6" colType="0" 
          m0="2.51790" mWidth="0.01490" mMin="2.43000" mMax="2.68000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="4122 211" 
 
<p/>particle: id="4232" name="Xi_c+" antiName="Xi_cbar-" spinType="2" chargeType="3" colType="0" 
          m0="2.46780" tau0="1.32000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0280000" meMode="22" products="-11 12 3 3201" 
 <br/>      channel: onMode="1" bRatio="0.0070000" meMode="22" products="-11 12 3 3203" 
 <br/>      channel: onMode="1" bRatio="0.0280000" meMode="22" products="-13 14 3 3201" 
 <br/>      channel: onMode="1" bRatio="0.0070000" meMode="22" products="-13 14 3 3203" 
 <br/>      channel: onMode="1" bRatio="0.9300000" meMode="42" products="2 -1 3 3201" 
 
<p/>particle: id="4301" name="cs_0" antiName="cs_0bar" spinType="1" chargeType="1" colType="-1" 
          m0="2.15432" 
 
<p/>particle: id="4303" name="cs_1" antiName="cs_1bar" spinType="3" chargeType="1" colType="-1" 
          m0="2.17967" 
 
<p/>particle: id="4312" name="Xi'_c0" antiName="Xi'_cbar0" spinType="2" chargeType="0" colType="0" 
          m0="2.57790" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="4132 22" 
 
<p/>particle: id="4314" name="Xi*_c0" antiName="Xi*_cbar0" spinType="4" chargeType="0" colType="0" 
          m0="2.64590" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="4132 111" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="4132 22" 
 
<p/>particle: id="4322" name="Xi'_c+" antiName="Xi'_cbar-" spinType="2" chargeType="3" colType="0" 
          m0="2.57560" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="4232 22" 
 
<p/>particle: id="4324" name="Xi*_c+" antiName="Xi*_cbar-" spinType="4" chargeType="3" colType="0" 
          m0="2.64590" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="4232 111" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="4232 22" 
 
<p/>particle: id="4332" name="Omega_c0" antiName="Omega_cbar0" spinType="2" chargeType="0" colType="0" 
          m0="2.69520" tau0="2.10000e-02" 
 <br/>      channel: onMode="1" bRatio="0.0180000" meMode="22" products="-11 12 3 3303" 
 <br/>      channel: onMode="1" bRatio="0.0180000" meMode="22" products="-13 14 3 3303" 
 <br/>      channel: onMode="1" bRatio="0.9640000" meMode="42" products="2 -1 3 3303" 
 
<p/>particle: id="4334" name="Omega*_c0" antiName="Omega*_cbar0" spinType="4" chargeType="0" colType="0" 
          m0="2.76590" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="4332 22" 
 
<p/>particle: id="4403" name="cc_1" antiName="cc_1bar" spinType="3" chargeType="4" colType="-1" 
          m0="3.27531" 
 
<p/>particle: id="4412" name="Xi_cc+" antiName="Xi_ccbar-" spinType="2" chargeType="3" colType="0" 
          m0="3.59798" tau0="1.00000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-11 12 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-13 14 3 81" 
 <br/>      channel: onMode="1" bRatio="0.7600000" meMode="42" products="2 -1 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="42" products="2 -3 3 81" 
 
<p/>particle: id="4414" name="Xi*_cc+" antiName="Xi*_ccbar-" spinType="4" chargeType="3" colType="0" 
          m0="3.65648" tau0="1.00000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-11 12 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-13 14 3 81" 
 <br/>      channel: onMode="1" bRatio="0.7600000" meMode="42" products="2 -1 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="42" products="2 -3 3 81" 
 
<p/>particle: id="4422" name="Xi_cc++" antiName="Xi_ccbar--" spinType="2" chargeType="6" colType="0" 
          m0="3.59798" tau0="1.00000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-11 12 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-13 14 3 81" 
 <br/>      channel: onMode="1" bRatio="0.7600000" meMode="42" products="2 -1 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="42" products="2 -3 3 81" 
 
<p/>particle: id="4424" name="Xi*_cc++" antiName="Xi*_ccbar--" spinType="4" chargeType="6" colType="0" 
          m0="3.65648" tau0="1.00000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-11 12 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-13 14 3 81" 
 <br/>      channel: onMode="1" bRatio="0.7600000" meMode="42" products="2 -1 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="42" products="2 -3 3 81" 
 
<p/>particle: id="4432" name="Omega_cc+" antiName="Omega_ccbar-" spinType="2" chargeType="3" colType="0" 
          m0="3.78663" tau0="1.00000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-11 12 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-13 14 3 81" 
 <br/>      channel: onMode="1" bRatio="0.7600000" meMode="42" products="2 -1 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="42" products="2 -3 3 81" 
 
<p/>particle: id="4434" name="Omega*_cc+" antiName="Omega*_ccbar-" spinType="4" chargeType="3" colType="0" 
          m0="3.82466" tau0="1.00000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-11 12 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-13 14 3 81" 
 <br/>      channel: onMode="1" bRatio="0.7600000" meMode="42" products="2 -1 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="42" products="2 -3 3 81" 
 
<p/>particle: id="4444" name="Omega*_ccc++" antiName="Omega*_cccbar--" spinType="4" chargeType="6" colType="0" 
          m0="4.91594" tau0="1.00000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-11 12 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-13 14 3 81" 
 <br/>      channel: onMode="1" bRatio="0.7600000" meMode="42" products="2 -1 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="42" products="2 -3 3 81" 
 
<p/>particle: id="5101" name="bd_0" antiName="bd_0bar" spinType="1" chargeType="-2" colType="-1" 
          m0="5.38897" 
 
<p/>particle: id="5103" name="bd_1" antiName="bd_1bar" spinType="3" chargeType="-2" colType="-1" 
          m0="5.40145" 
 
<p/>particle: id="5112" name="Sigma_b-" antiName="Sigma_bbar+" spinType="2" chargeType="-3" colType="0" 
          m0="5.81550" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5122 -211" 
 
<p/>particle: id="5114" name="Sigma*_b-" antiName="Sigma*_bbar+" spinType="4" chargeType="-3" colType="0" 
          m0="5.83510" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5122 -211" 
 
<p/>particle: id="5122" name="Lambda_b0" antiName="Lambda_bbar0" spinType="2" chargeType="0" colType="0" 
          m0="5.61940" tau0="3.69000e-01" 
 <br/>      channel: onMode="1" bRatio="0.0546000" meMode="22" products="-12 11 4122" 
 <br/>      channel: onMode="1" bRatio="0.0096000" meMode="22" products="-12 11 4124" 
 <br/>      channel: onMode="1" bRatio="0.0128000" meMode="22" products="-12 11 14122" 
 <br/>      channel: onMode="1" bRatio="0.0546000" meMode="22" products="-14 13 4122" 
 <br/>      channel: onMode="1" bRatio="0.0096000" meMode="22" products="-14 13 4124" 
 <br/>      channel: onMode="1" bRatio="0.0128000" meMode="22" products="-14 13 14122" 
 <br/>      channel: onMode="1" bRatio="0.0172000" meMode="22" products="-16 15 4122" 
 <br/>      channel: onMode="1" bRatio="0.0032000" meMode="22" products="-16 15 4124" 
 <br/>      channel: onMode="1" bRatio="0.0043000" meMode="22" products="-16 15 14122" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="2112 421" 
 <br/>      channel: onMode="1" bRatio="0.0000048" products="2212 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000185" products="2212 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000650" products="3122 22" 
 <br/>      channel: onMode="1" bRatio="0.0000050" products="3122 113" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="3122 333" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="3122 -421" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="3122 441" 
 <br/>      channel: onMode="1" bRatio="0.0004700" products="3122 443" 
 <br/>      channel: onMode="1" bRatio="0.0000590" products="3124 22" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="4112 111" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="4112 221" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="4112 331" 
 <br/>      channel: onMode="1" bRatio="0.0400000" products="4122 -211" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="4122 -213" 
 <br/>      channel: onMode="1" bRatio="0.0005500" products="4122 -321" 
 <br/>      channel: onMode="1" bRatio="0.0220000" products="4122 -431" 
 <br/>      channel: onMode="1" bRatio="0.0440000" products="4122 -433" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="4132 311" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="4212 -211" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="4312 311" 
 <br/>      channel: onMode="1" bRatio="0.0200000" products="-20213 4122" 
 <br/>      channel: onMode="1" bRatio="0.0000570" products="23122 22" 
 <br/>      channel: onMode="1" bRatio="0.0000560" products="33122 22" 
 <br/>      channel: onMode="1" bRatio="0.0003800" products="100443 3122" 
 <br/>      channel: onMode="1" bRatio="0.0220000" products="4122 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0200000" products="3122 311 211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0120000" meMode="22" products="-2 1 2 2101" 
 <br/>      channel: onMode="1" bRatio="0.4411147" meMode="23" products="-2 1 4 2101" 
 <br/>      channel: onMode="1" bRatio="0.0910000" meMode="43" products="-2 4 1 2101" 
 <br/>      channel: onMode="1" bRatio="0.0120000" meMode="22" products="-4 3 2 2101" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="43" products="-4 3 4 2101" 
 
<p/>particle: id="5132" name="Xi_b-" antiName="Xi_bbar+" spinType="2" chargeType="-3" colType="0" 
          m0="5.79110" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1080010" meMode="22" products="-12 11 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="-12 11 2 3101" 
 <br/>      channel: onMode="1" bRatio="0.1080000" meMode="22" products="-14 13 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="-14 13 2 3101" 
 <br/>      channel: onMode="1" bRatio="0.0250000" meMode="22" products="-16 15 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0010000" meMode="22" products="-16 15 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="443 3312" 
 <br/>      channel: onMode="1" bRatio="0.0004370" products="100443 3312" 
 <br/>      channel: onMode="1" bRatio="0.0004710" products="20443 3312" 
 <br/>      channel: onMode="1" bRatio="0.0000900" products="445 3312" 
 <br/>      channel: onMode="1" bRatio="0.0004900" products="441 3312" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="443 3314" 
 <br/>      channel: onMode="1" bRatio="0.0006560" products="100443 3314" 
 <br/>      channel: onMode="1" bRatio="0.0007060" products="20443 3314" 
 <br/>      channel: onMode="1" bRatio="0.0001350" products="445 3314" 
 <br/>      channel: onMode="1" bRatio="0.0007350" products="441 3314" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="443 -321 3122" 
 <br/>      channel: onMode="1" bRatio="0.0005240" products="100443 -321 3122" 
 <br/>      channel: onMode="1" bRatio="0.0005650" products="20443 -321 3122" 
 <br/>      channel: onMode="1" bRatio="0.0001080" products="445 -321 3122" 
 <br/>      channel: onMode="1" bRatio="0.0005880" products="441 -321 3122" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="443 -311 3112" 
 <br/>      channel: onMode="1" bRatio="0.0002620" products="100443 -311 3112" 
 <br/>      channel: onMode="1" bRatio="0.0002830" products="20443 -311 3112" 
 <br/>      channel: onMode="1" bRatio="0.0000540" products="445 -311 3112" 
 <br/>      channel: onMode="1" bRatio="0.0002940" products="441 -311 3112" 
 <br/>      channel: onMode="1" bRatio="0.0038200" meMode="43" products="443 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.0016690" meMode="43" products="100443 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.0017990" meMode="43" products="20443 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.0003440" meMode="43" products="445 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.0018720" meMode="43" products="441 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.1096770" meMode="22" products="-2 1 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.2632250" meMode="22" products="-2 4 1 3101" 
 <br/>      channel: onMode="1" bRatio="0.0658060" meMode="42" products="-2 1 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="42" products="-2 4 1 3101" 
 <br/>      channel: onMode="1" bRatio="0.0057720" meMode="22" products="-2 3 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0138540" meMode="22" products="-2 4 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.0034630" meMode="42" products="-2 3 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="42" products="-2 4 3 3101" 
 <br/>      channel: onMode="1" bRatio="0.0090000" meMode="22" products="-2 1 2 3101" 
 <br/>      channel: onMode="1" bRatio="0.0060000" meMode="22" products="-2 2 1 3101" 
 <br/>      channel: onMode="1" bRatio="0.0230000" meMode="63" products="-431 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0230000" meMode="63" products="-433 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0130000" products="-431 4132" 
 <br/>      channel: onMode="1" bRatio="0.0090000" products="-431 4314" 
 <br/>      channel: onMode="1" bRatio="0.0090000" products="-433 4132" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="-433 4314" 
 <br/>      channel: onMode="1" bRatio="0.0080000" meMode="22" products="-421 -321 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0080000" meMode="22" products="-411 -311 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0320000" meMode="22" products="-423 -321 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0320000" meMode="22" products="-413 -311 4 3101" 
 <br/>      channel: onMode="1" bRatio="0.0770000" meMode="42" products="4122 -2203 3101" 
 
<p/>particle: id="5142" name="Xi_bc0" antiName="Xi_bcbar0" spinType="2" chargeType="0" colType="0" 
          m0="7.00575" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5201" name="bu_0" antiName="bu_0bar" spinType="1" chargeType="1" colType="-1" 
          m0="5.38897" 
 
<p/>particle: id="5203" name="bu_1" antiName="bu_1bar" spinType="3" chargeType="1" colType="-1" 
          m0="5.40145" 
 
<p/>particle: id="5212" name="Sigma_b0" antiName="Sigma_bbar0" spinType="2" chargeType="0" colType="0" 
          m0="5.80000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5122 111" 
 
<p/>particle: id="5214" name="Sigma*_b0" antiName="Sigma*_bbar0" spinType="4" chargeType="0" colType="0" 
          m0="5.81000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5122 111" 
 
<p/>particle: id="5222" name="Sigma_b+" antiName="Sigma_bbar-" spinType="2" chargeType="3" colType="0" 
          m0="5.81130" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5122 211" 
 
<p/>particle: id="5224" name="Sigma*_b+" antiName="Sigma*_bbar-" spinType="4" chargeType="3" colType="0" 
          m0="5.83210" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5122 211" 
 
<p/>particle: id="5232" name="Xi_b0" antiName="Xi_bbar0" spinType="2" chargeType="0" colType="0" 
          m0="5.78800" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1080010" meMode="22" products="-12 11 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="-12 11 2 3201" 
 <br/>      channel: onMode="1" bRatio="0.1080000" meMode="22" products="-14 13 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="-14 13 2 3201" 
 <br/>      channel: onMode="1" bRatio="0.0250000" meMode="22" products="-16 15 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0010000" meMode="22" products="-16 15 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="443 3322" 
 <br/>      channel: onMode="1" bRatio="0.0004370" products="100443 3322" 
 <br/>      channel: onMode="1" bRatio="0.0004710" products="20443 3322" 
 <br/>      channel: onMode="1" bRatio="0.0000900" products="445 3322" 
 <br/>      channel: onMode="1" bRatio="0.0004900" products="441 3322" 
 <br/>      channel: onMode="1" bRatio="0.0015000" products="443 3324" 
 <br/>      channel: onMode="1" bRatio="0.0006560" products="100443 3324" 
 <br/>      channel: onMode="1" bRatio="0.0007060" products="20443 3324" 
 <br/>      channel: onMode="1" bRatio="0.0001350" products="445 3324" 
 <br/>      channel: onMode="1" bRatio="0.0007350" products="441 3324" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="443 -321 3222" 
 <br/>      channel: onMode="1" bRatio="0.0005240" products="100443 -321 3222" 
 <br/>      channel: onMode="1" bRatio="0.0005650" products="20443 -321 3222" 
 <br/>      channel: onMode="1" bRatio="0.0001080" products="445 -321 3222" 
 <br/>      channel: onMode="1" bRatio="0.0005880" products="441 -321 3222" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="443 -311 3212" 
 <br/>      channel: onMode="1" bRatio="0.0002620" products="100443 -311 3212" 
 <br/>      channel: onMode="1" bRatio="0.0002830" products="20443 -311 3212" 
 <br/>      channel: onMode="1" bRatio="0.0000540" products="445 -311 3212" 
 <br/>      channel: onMode="1" bRatio="0.0002940" products="441 -311 3212" 
 <br/>      channel: onMode="1" bRatio="0.0038200" meMode="43" products="443 3 3201" 
 <br/>      channel: onMode="1" bRatio="0.0016690" meMode="43" products="100443 3 3201" 
 <br/>      channel: onMode="1" bRatio="0.0017990" meMode="43" products="20443 3 3201" 
 <br/>      channel: onMode="1" bRatio="0.0003440" meMode="43" products="445 3 3201" 
 <br/>      channel: onMode="1" bRatio="0.0018720" meMode="43" products="441 3 3201" 
 <br/>      channel: onMode="1" bRatio="0.1096770" meMode="22" products="-2 1 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.2632250" meMode="22" products="-2 4 1 3201" 
 <br/>      channel: onMode="1" bRatio="0.0658060" meMode="42" products="-2 1 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="42" products="-2 4 1 3201" 
 <br/>      channel: onMode="1" bRatio="0.0057720" meMode="22" products="-2 3 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0138540" meMode="22" products="-2 4 3 3201" 
 <br/>      channel: onMode="1" bRatio="0.0034630" meMode="42" products="-2 3 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="42" products="-2 4 3 3201" 
 <br/>      channel: onMode="1" bRatio="0.0090000" meMode="22" products="-2 1 2 3201" 
 <br/>      channel: onMode="1" bRatio="0.0060000" meMode="22" products="-2 2 1 3201" 
 <br/>      channel: onMode="1" bRatio="0.0230000" meMode="63" products="-431 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0230000" meMode="63" products="-433 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0130000" products="-431 4232" 
 <br/>      channel: onMode="1" bRatio="0.0090000" products="-431 4324" 
 <br/>      channel: onMode="1" bRatio="0.0090000" products="-433 4232" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="-433 4324" 
 <br/>      channel: onMode="1" bRatio="0.0080000" meMode="22" products="-421 -321 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0080000" meMode="22" products="-411 -311 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0320000" meMode="22" products="-423 -321 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0320000" meMode="22" products="-413 -311 4 3201" 
 <br/>      channel: onMode="1" bRatio="0.0770000" meMode="42" products="4122 -2203 3201" 
 
<p/>particle: id="5242" name="Xi_bc+" antiName="Xi_bcbar-" spinType="2" chargeType="3" colType="0" 
          m0="7.00575" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5301" name="bs_0" antiName="bs_0bar" spinType="1" chargeType="-2" colType="-1" 
          m0="5.56725" 
 
<p/>particle: id="5303" name="bs_1" antiName="bs_1bar" spinType="3" chargeType="-2" colType="-1" 
          m0="5.57536" 
 
<p/>particle: id="5312" name="Xi'_b-" antiName="Xi'_bbar+" spinType="2" chargeType="-3" colType="0" 
          m0="5.96000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5132 22" 
 
<p/>particle: id="5314" name="Xi*_b-" antiName="Xi*_bbar+" spinType="4" chargeType="-3" colType="0" 
          m0="5.97000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5132 22" 
 
<p/>particle: id="5322" name="Xi'_b0" antiName="Xi'_bbar0" spinType="2" chargeType="0" colType="0" 
          m0="5.96000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5232 22" 
 
<p/>particle: id="5324" name="Xi*_b0" antiName="Xi*_bbar0" spinType="4" chargeType="0" colType="0" 
          m0="5.97000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5232 22" 
 
<p/>particle: id="5332" name="Omega_b-" antiName="Omega_bbar+" spinType="2" chargeType="-3" colType="0" 
          m0="6.07000" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1080010" meMode="22" products="-12 11 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="-12 11 2 3303" 
 <br/>      channel: onMode="1" bRatio="0.1080000" meMode="22" products="-14 13 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0020000" meMode="22" products="-14 13 2 3303" 
 <br/>      channel: onMode="1" bRatio="0.0250000" meMode="22" products="-16 15 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0010000" meMode="22" products="-16 15 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="443 3334" 
 <br/>      channel: onMode="1" bRatio="0.0010930" products="100443 3334" 
 <br/>      channel: onMode="1" bRatio="0.0011770" products="20443 3334" 
 <br/>      channel: onMode="1" bRatio="0.0002250" products="445 3334" 
 <br/>      channel: onMode="1" bRatio="0.0012250" products="441 3334" 
 <br/>      channel: onMode="1" bRatio="0.0012000" products="443 -321 3322" 
 <br/>      channel: onMode="1" bRatio="0.0005240" products="100443 -321 3322" 
 <br/>      channel: onMode="1" bRatio="0.0005650" products="20443 -321 3322" 
 <br/>      channel: onMode="1" bRatio="0.0001080" products="445 -321 3322" 
 <br/>      channel: onMode="1" bRatio="0.0005880" products="441 -321 3322" 
 <br/>      channel: onMode="1" bRatio="0.0006000" products="443 -311 3312" 
 <br/>      channel: onMode="1" bRatio="0.0002620" products="100443 -311 3312" 
 <br/>      channel: onMode="1" bRatio="0.0002830" products="20443 -311 3312" 
 <br/>      channel: onMode="1" bRatio="0.0000540" products="445 -311 3312" 
 <br/>      channel: onMode="1" bRatio="0.0002940" products="441 -311 3312" 
 <br/>      channel: onMode="1" bRatio="0.0038200" meMode="43" products="443 3 3303" 
 <br/>      channel: onMode="1" bRatio="0.0016690" meMode="43" products="100443 3 3303" 
 <br/>      channel: onMode="1" bRatio="0.0017990" meMode="43" products="20443 3 3303" 
 <br/>      channel: onMode="1" bRatio="0.0003440" meMode="43" products="445 3 3303" 
 <br/>      channel: onMode="1" bRatio="0.0018720" meMode="43" products="441 3 3303" 
 <br/>      channel: onMode="1" bRatio="0.1096770" meMode="22" products="-2 1 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.2632250" meMode="22" products="-2 4 1 3303" 
 <br/>      channel: onMode="1" bRatio="0.0658060" meMode="42" products="-2 1 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="42" products="-2 4 1 3303" 
 <br/>      channel: onMode="1" bRatio="0.0057720" meMode="22" products="-2 3 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0138540" meMode="22" products="-2 4 3 3303" 
 <br/>      channel: onMode="1" bRatio="0.0034630" meMode="42" products="-2 3 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="42" products="-2 4 3 3303" 
 <br/>      channel: onMode="1" bRatio="0.0090000" meMode="22" products="-2 1 2 3303" 
 <br/>      channel: onMode="1" bRatio="0.0060000" meMode="22" products="-2 2 1 3303" 
 <br/>      channel: onMode="1" bRatio="0.0230000" meMode="63" products="-431 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0230000" meMode="63" products="-433 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0130000" products="-431 4332" 
 <br/>      channel: onMode="1" bRatio="0.0090000" products="-431 4334" 
 <br/>      channel: onMode="1" bRatio="0.0090000" products="-433 4332" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="-433 4334" 
 <br/>      channel: onMode="1" bRatio="0.0080000" meMode="22" products="-421 -321 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0080000" meMode="22" products="-411 -311 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0320000" meMode="22" products="-423 -321 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0320000" meMode="22" products="-413 -311 4 3303" 
 <br/>      channel: onMode="1" bRatio="0.0770000" meMode="42" products="4122 -2203 3303" 
 
<p/>particle: id="5334" name="Omega*_b-" antiName="Omega*_bbar+" spinType="4" chargeType="-3" colType="0" 
          m0="6.13000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="5332 22" 
 
<p/>particle: id="5342" name="Omega_bc0" antiName="Omega_bcbar0" spinType="2" chargeType="0" colType="0" 
          m0="7.19099" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5401" name="bc_0" antiName="bc_0bar" spinType="1" chargeType="1" colType="-1" 
          m0="6.67143" 
 
<p/>particle: id="5403" name="bc_1" antiName="bc_1bar" spinType="3" chargeType="1" colType="-1" 
          m0="6.67397" 
 
<p/>particle: id="5412" name="Xi'_bc0" antiName="Xi'_bcbar0" spinType="2" chargeType="0" colType="0" 
          m0="7.03724" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5414" name="Xi*_bc0" antiName="Xi*_bcbar0" spinType="4" chargeType="0" colType="0" 
          m0="7.04850" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5422" name="Xi'_bc+" antiName="Xi'_bcbar-" spinType="2" chargeType="3" colType="0" 
          m0="7.03724" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5424" name="Xi*_bc+" antiName="Xi*_bcbar-" spinType="4" chargeType="3" colType="0" 
          m0="7.04850" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5432" name="Omega'_bc0" antiName="Omega'_bcbar0" spinType="2" chargeType="0" colType="0" 
          m0="7.21101" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5434" name="Omega*_bc0" antiName="Omega*_bcbar0" spinType="4" chargeType="0" colType="0" 
          m0="7.21900" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5442" name="Omega_bcc+" antiName="Omega_bccbar-" spinType="2" chargeType="3" colType="0" 
          m0="8.30945" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5444" name="Omega*_bcc+" antiName="Omega*_bccbar-" spinType="4" chargeType="3" colType="0" 
          m0="8.31325" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5503" name="bb_1" antiName="bb_1bar" spinType="3" chargeType="-2" colType="-1" 
          m0="10.07354" 
 
<p/>particle: id="5512" name="Xi_bb-" antiName="Xi_bbbar+" spinType="2" chargeType="-3" colType="0" 
          m0="10.42272" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5514" name="Xi*_bb-" antiName="Xi*_bbbar+" spinType="4" chargeType="-3" colType="0" 
          m0="10.44144" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5522" name="Xi_bb0" antiName="Xi_bbbar0" spinType="2" chargeType="0" colType="0" 
          m0="10.42272" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5524" name="Xi*_bb0" antiName="Xi*_bbbar0" spinType="4" chargeType="0" colType="0" 
          m0="10.44144" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5532" name="Omega_bb-" antiName="Omega_bbbar+" spinType="2" chargeType="-3" colType="0" 
          m0="10.60209" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5534" name="Omega*_bb-" antiName="Omega*_bbbar+" spinType="4" chargeType="-3" colType="0" 
          m0="10.61426" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5542" name="Omega_bbc0" antiName="Omega_bbcbar0" spinType="2" chargeType="0" colType="0" 
          m0="11.70767" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5544" name="Omega*_bbc0" antiName="Omega*_bbcbar0" spinType="4" chargeType="0" colType="0" 
          m0="11.71147" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="5554" name="Omega*_bbb-" antiName="Omega*_bbbbar+" spinType="4" chargeType="-3" colType="0" 
          m0="15.11061" tau0="3.64000e-01" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-12 11 4 81" 
 <br/>      channel: onMode="1" bRatio="0.1050000" meMode="22" products="-14 13 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0400000" meMode="22" products="-16 15 4 81" 
 <br/>      channel: onMode="1" bRatio="0.5000000" meMode="22" products="-2 1 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0800000" meMode="22" products="-2 4 1 81" 
 <br/>      channel: onMode="1" bRatio="0.1400000" meMode="22" products="-4 3 4 81" 
 <br/>      channel: onMode="1" bRatio="0.0100000" meMode="22" products="-4 4 3 81" 
 <br/>      channel: onMode="1" bRatio="0.0150000" meMode="22" products="-2 1 2 81" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="22" products="-4 3 2 81" 
 
<p/>particle: id="10111" name="a_0(1450)0" spinType="1" chargeType="0" colType="0" 
          m0="1.47400" mWidth="0.26500" mMin="1.00000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.3000000" products="111 221" 
 <br/>      channel: onMode="1" bRatio="0.1000000" products="111 331" 
 <br/>      channel: onMode="1" bRatio="0.1200000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0600000" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0600000" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.1800000" products="223 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.1800000" products="223 111 111" 
 
<p/>particle: id="10113" name="b_1(1235)0" spinType="3" chargeType="0" colType="0" 
          m0="1.22950" mWidth="0.14200" mMin="0.95000" mMax="1.70000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="223 111" 
 
<p/>particle: id="10211" name="a_0(1450)+" antiName="a_0(1450)-" spinType="1" chargeType="3" colType="0" 
          m0="1.47400" mWidth="0.26500" mMin="1.00000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.3000000" products="211 221" 
 <br/>      channel: onMode="1" bRatio="0.1000000" products="211 331" 
 <br/>      channel: onMode="1" bRatio="0.2400000" products="321 -311" 
 <br/>      channel: onMode="1" bRatio="0.3600000" products="223 211 111" 
 
<p/>particle: id="10213" name="b_1(1235)+" antiName="b_1(1235)-" spinType="3" chargeType="3" colType="0" 
          m0="1.22950" mWidth="0.14200" mMin="0.95000" mMax="1.70000" 
 <br/>      channel: onMode="1" bRatio="0.9984000" products="223 211" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="211 22" 
 
<p/>particle: id="10221" name="f_0(1370)" spinType="1" chargeType="0" colType="0" 
          m0="1.35000" mWidth="0.20000" mMin="1.00000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.2000000" products="113 111" 
 <br/>      channel: onMode="1" bRatio="0.2000000" products="213 -213" 
 <br/>      channel: onMode="1" bRatio="0.1000000" products="111 111 111 111" 
 <br/>      channel: onMode="1" bRatio="0.2000000" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.1000000" products="111 111" 
 <br/>      channel: onMode="1" bRatio="0.0500000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0250000" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0250000" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.1000000" products="221 221" 
 
<p/>particle: id="10223" name="h_1(1170)" spinType="3" chargeType="0" colType="0" 
          m0="1.17000" mWidth="0.36000" mMin="0.95000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="213 -211" 
 <br/>      channel: onMode="1" bRatio="0.3340000" products="113 111" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="-213 211" 
 
<p/>particle: id="10311" name="K*_0(1430)0" antiName="K*_0(1430)bar0" spinType="1" chargeType="0" colType="0" 
          m0="1.43000" mWidth="0.27000" mMin="0.70000" mMax="2.20000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="321 -211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="311 111" 
 
<p/>particle: id="10313" name="K_1(1270)0" antiName="K_1(1270)bar0" spinType="3" chargeType="0" colType="0" 
          m0="1.27200" mWidth="0.09000" mMin="1.00000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.2886598" products="321 -213" 
 <br/>      channel: onMode="1" bRatio="0.1443299" products="311 113" 
 <br/>      channel: onMode="1" bRatio="0.1924399" products="10321 -211" 
 <br/>      channel: onMode="1" bRatio="0.0962199" products="10311 111" 
 <br/>      channel: onMode="1" bRatio="0.1099656" products="323 -211" 
 <br/>      channel: onMode="1" bRatio="0.0549828" products="313 111" 
 <br/>      channel: onMode="1" bRatio="0.1134021" products="311 223" 
 
<p/>particle: id="10321" name="K*_0(1430)+" antiName="K*_0(1430)-" spinType="1" chargeType="3" colType="0" 
          m0="1.43000" mWidth="0.27000" mMin="0.70000" mMax="2.20000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="311 211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="321 111" 
 
<p/>particle: id="10323" name="K_1(1270)+" antiName="K_1(1270)-" spinType="3" chargeType="3" colType="0" 
          m0="1.27200" mWidth="0.09000" mMin="1.00000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.2886598" products="311 213" 
 <br/>      channel: onMode="1" bRatio="0.1443299" products="321 113" 
 <br/>      channel: onMode="1" bRatio="0.1924399" products="10311 211" 
 <br/>      channel: onMode="1" bRatio="0.0962199" products="10321 111" 
 <br/>      channel: onMode="1" bRatio="0.1099656" products="313 211" 
 <br/>      channel: onMode="1" bRatio="0.0549828" products="323 111" 
 <br/>      channel: onMode="1" bRatio="0.1134021" products="321 223" 
 
<p/>particle: id="10331" name="f_0(1710)" spinType="1" chargeType="0" colType="0" 
          m0="1.72000" mWidth="0.13500" mMin="1.10000" mMax="2.40000" 
 <br/>      channel: onMode="1" bRatio="0.3000000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.1500000" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.1500000" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.3000000" products="221 221" 
 <br/>      channel: onMode="1" bRatio="0.0500000" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0500000" products="111 111" 
 
<p/>particle: id="10333" name="h_1(1380)" spinType="3" chargeType="0" colType="0" 
          m0="1.38600" mWidth="0.09100" mMin="1.38000" mMax="1.60000" 
 <br/>      channel: onMode="1" bRatio="0.2500000" products="313 -311" 
 <br/>      channel: onMode="1" bRatio="0.2500000" products="-313 311" 
 <br/>      channel: onMode="1" bRatio="0.2500000" products="323 -321" 
 <br/>      channel: onMode="1" bRatio="0.2500000" products="-323 321" 
 
<p/>particle: id="10411" name="D*_0+" antiName="D*_0-" spinType="1" chargeType="3" colType="0" 
          m0="2.31800" mWidth="0.27000" mMin="2.05000" mMax="2.50000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="421 211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="411 111" 
 
<p/>particle: id="10413" name="D_1+" antiName="D_1-" spinType="3" chargeType="3" colType="0" 
          m0="2.42400" mWidth="0.02000" mMin="2.22400" mMax="2.62400" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="423 211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="413 111" 
 
<p/>particle: id="10421" name="D*_00" antiName="D*_0bar0" spinType="1" chargeType="0" colType="0" 
          m0="2.31800" mWidth="0.27000" mMin="2.05000" mMax="2.50000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="411 -211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="421 111" 
 
<p/>particle: id="10423" name="D_10" antiName="D_1bar0" spinType="3" chargeType="0" colType="0" 
          m0="2.42130" mWidth="0.02710" mMin="2.21830" mMax="2.62630" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="413 -211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="423 111" 
 
<p/>particle: id="10431" name="D*_0s+" antiName="D*_0s-" spinType="1" chargeType="3" colType="0" 
          m0="2.31780" mWidth="0.02000" mMin="2.20000" mMax="2.44000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="431 111" 
 
<p/>particle: id="10433" name="D_1s+" antiName="D_1s-" spinType="3" chargeType="3" colType="0" 
          m0="2.53512" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="423 321" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="413 311" 
 
<p/>particle: id="10441" name="chi_0c" spinType="1" chargeType="0" colType="0" 
          m0="3.41475" mWidth="0.01040" mMin="3.31076" mMax="3.51876" 
 <br/>      channel: onMode="1" bRatio="0.0002600" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.0021000" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0049000" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0021000" products="221 221" 
 <br/>      channel: onMode="1" bRatio="0.0021000" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="313 -313" 
 <br/>      channel: onMode="1" bRatio="0.0060000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="333 333" 
 <br/>      channel: onMode="1" bRatio="0.0200000" products="443 22" 
 <br/>      channel: onMode="1" bRatio="0.0002200" products="2212 -2212" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="3122 -3122" 
 <br/>      channel: onMode="1" bRatio="0.0028000" products="9010221 9010221" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="-213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0032000" products="321 -313 -211" 
 <br/>      channel: onMode="1" bRatio="0.0032000" products="-321 313 211" 
 <br/>      channel: onMode="1" bRatio="0.0043000" products="323 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0043000" products="-323 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0134000" products="211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0021000" products="321 321 -321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0153000" products="321 -321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0022000" products="2212 -2212 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0098000" products="211 211 211 -211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.8686200" meMode="52" products="83 -83" 
 
<p/>particle: id="10443" name="h_1c" spinType="3" chargeType="0" colType="0" 
          m0="3.52541" mWidth="0.01000" mMin="3.36000" mMax="3.56000" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="441 22" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="443 111" 
 <br/>      channel: onMode="1" bRatio="0.4900000" meMode="42" products="83 -83" 
 
<p/>particle: id="10511" name="B*_00" antiName="B*_0bar0" spinType="1" chargeType="0" colType="0" 
          m0="5.68000" mWidth="0.05000" mMin="5.58000" mMax="5.78000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="521 -211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="511 111" 
 
<p/>particle: id="10513" name="B_10" antiName="B_1bar0" spinType="3" chargeType="0" colType="0" 
          m0="5.73000" mWidth="0.05000" mMin="5.63000" mMax="5.83000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="523 -211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="513 111" 
 
<p/>particle: id="10521" name="B*_0+" antiName="B*_0-" spinType="1" chargeType="3" colType="0" 
          m0="5.68000" mWidth="0.05000" mMin="5.58000" mMax="5.78000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="511 211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="521 111" 
 
<p/>particle: id="10523" name="B_1+" antiName="B_1-" spinType="3" chargeType="3" colType="0" 
          m0="5.73000" mWidth="0.05000" mMin="5.63000" mMax="5.83000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="513 211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="523 111" 
 
<p/>particle: id="10531" name="B*_0s0" antiName="B*_0sbar0" spinType="1" chargeType="0" colType="0" 
          m0="5.92000" mWidth="0.05000" mMin="5.82000" mMax="6.02000" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="521 -321" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="511 -311" 
 
<p/>particle: id="10533" name="B_1s0" antiName="B_1sbar0" spinType="3" chargeType="0" colType="0" 
          m0="5.82900" mWidth="0.05000" mMin="5.77900" mMax="5.87900" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="523 -321" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="513 -311" 
 
<p/>particle: id="10541" name="B*_0c+" antiName="B*_0c-" spinType="1" chargeType="3" colType="0" 
          m0="7.25000" mWidth="0.05000" mMin="7.20000" mMax="7.30000" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="511 411" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="521 421" 
 
<p/>particle: id="10543" name="B_1c+" antiName="B_1c-" spinType="3" chargeType="3" colType="0" 
          m0="7.30000" mWidth="0.05000" mMin="7.20000" mMax="7.40000" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="513 411" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="523 421" 
 
<p/>particle: id="10551" name="chi_0b" spinType="1" chargeType="0" colType="0" 
          m0="9.85940" 
 <br/>      channel: onMode="1" bRatio="0.9800000" meMode="91" products="21 21" 
 <br/>      channel: onMode="1" bRatio="0.0200000" products="553 22" 
 
<p/>particle: id="10553" name="h_1b" spinType="3" chargeType="0" colType="0" 
          m0="9.89860" mWidth="0.01000" mMin="9.85500" mMax="9.89500" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="91" products="21 21" 
 
<p/>particle: id="13122" name="Lambda(1405)0" antiName="Lambda(1405)bar0" spinType="2" chargeType="0" colType="0" 
          m0="1.40510" mWidth="0.05000" mMin="1.32000" mMax="1.80000" 
 <br/>      channel: onMode="1" bRatio="0.3333000" products="3222 -211" 
 <br/>      channel: onMode="1" bRatio="0.3333000" products="3112 211" 
 <br/>      channel: onMode="1" bRatio="0.3334000" products="3212 111" 
 
<p/>particle: id="14122" name="Lambda_c(2593)+" antiName="Lambda_c(2593)-" spinType="2" chargeType="3" colType="0" 
          m0="2.59225" mWidth="0.00260" mMin="2.57000" mMax="2.63000" 
 <br/>      channel: onMode="1" bRatio="0.2400000" products="4222 -211" 
 <br/>      channel: onMode="1" bRatio="0.2400000" products="4112 211" 
 <br/>      channel: onMode="1" bRatio="0.1800000" products="4122 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.2400000" products="4212 111" 
 <br/>      channel: onMode="1" bRatio="0.0900000" products="4122 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="4122 22" 
 
<p/>particle: id="20113" name="a_1(1260)0" spinType="3" chargeType="0" colType="0" 
          m0="1.23000" mWidth="0.42000" mMin="0.93000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.3300000" products="213 -211" 
 <br/>      channel: onMode="1" bRatio="0.3300000" products="-213 211" 
 <br/>      channel: onMode="1" bRatio="0.3400000" products="113 111" 
 
<p/>particle: id="20213" name="a_1(1260)+" antiName="a_1(1260)-" spinType="3" chargeType="3" colType="0" 
          m0="1.23000" mWidth="0.42000" mMin="0.93000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="113 211" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="213 111" 
 
<p/>particle: id="20223" name="f_1(1285)" spinType="3" chargeType="0" colType="0" 
          m0="1.28210" mWidth="0.02420" mMin="1.20000" mMax="1.50000" 
 <br/>      channel: onMode="1" bRatio="0.1200000" products="9000211 -211" 
 <br/>      channel: onMode="1" bRatio="0.1200000" products="9000111 111" 
 <br/>      channel: onMode="1" bRatio="0.1200000" products="-9000211 211" 
 <br/>      channel: onMode="1" bRatio="0.0800000" products="221 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0800000" products="221 111 111" 
 <br/>      channel: onMode="1" bRatio="0.1100000" products="113 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0740000" products="213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0740000" products="113 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0740000" products="-213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="321 -321 111" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="321 -311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="311 -311 111" 
 <br/>      channel: onMode="1" bRatio="0.0230000" products="311 -321 211" 
 <br/>      channel: onMode="1" bRatio="0.0552600" products="113 22" 
 <br/>      channel: onMode="1" bRatio="0.0007400" products="333 22" 
 
<p/>particle: id="20313" name="K_1(1400)0" antiName="K_1(1400)bar0" spinType="3" chargeType="0" colType="0" 
          m0="1.40300" mWidth="0.17400" mMin="1.10000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.6270000" products="323 -211" 
 <br/>      channel: onMode="1" bRatio="0.3130000" products="313 111" 
 <br/>      channel: onMode="1" bRatio="0.0200000" products="321 -213" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="311 113" 
 <br/>      channel: onMode="1" bRatio="0.0200000" products="311 10221" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="311 223" 
 
<p/>particle: id="20323" name="K_1(1400)+" antiName="K_1(1400)-" spinType="3" chargeType="3" colType="0" 
          m0="1.40300" mWidth="0.17400" mMin="1.10000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.6270000" products="313 211" 
 <br/>      channel: onMode="1" bRatio="0.3130000" products="323 111" 
 <br/>      channel: onMode="1" bRatio="0.0200000" products="311 213" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="321 113" 
 <br/>      channel: onMode="1" bRatio="0.0200000" products="321 10221" 
 <br/>      channel: onMode="1" bRatio="0.0100000" products="321 223" 
 
<p/>particle: id="20333" name="f_1(1420)" spinType="3" chargeType="0" colType="0" 
          m0="1.42640" mWidth="0.05490" mMin="1.40000" mMax="1.80000" 
 <br/>      channel: onMode="1" bRatio="0.2500000" products="313 -311" 
 <br/>      channel: onMode="1" bRatio="0.2500000" products="-313 311" 
 <br/>      channel: onMode="1" bRatio="0.2500000" products="323 -321" 
 <br/>      channel: onMode="1" bRatio="0.2500000" products="-323 321" 
 
<p/>particle: id="20413" name="D*_1+" antiName="D*_1-" spinType="3" chargeType="3" colType="0" 
          m0="2.42700" mWidth="0.38400" mMin="2.15000" mMax="3.00000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="423 211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="413 111" 
 
<p/>particle: id="20423" name="D*_10" antiName="D*_1bar0" spinType="3" chargeType="0" colType="0" 
          m0="2.42700" mWidth="0.38400" mMin="2.15000" mMax="3.00000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="413 -211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="423 111" 
 
<p/>particle: id="20433" name="D*_1s+" antiName="D*_1s-" spinType="3" chargeType="3" colType="0" 
          m0="2.45960" mWidth="0.03000" mMin="2.40000" mMax="2.60000" 
 <br/>      channel: onMode="1" bRatio="0.7600000" products="433 111" 
 <br/>      channel: onMode="1" bRatio="0.2400000" products="433 22" 
 
<p/>particle: id="20443" name="chi_1c" spinType="3" chargeType="0" colType="0" 
          m0="3.51066" mWidth="0.00086" mMin="3.50176" mMax="3.51956" 
 <br/>      channel: onMode="1" bRatio="0.3560000" products="443 22" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0000100" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="313 -313" 
 <br/>      channel: onMode="1" bRatio="0.0000720" products="2212 -2212" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="3122 -3122" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="213 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0020000" products="-213 211 111" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="321 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="321 -313 -211" 
 <br/>      channel: onMode="1" bRatio="0.0025000" products="-321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0002000" products="-321 313 211" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="323 311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0009000" products="-323 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0062000" products="211 211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="310 310 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0004000" products="321 321 -321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0038000" products="321 -321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0003000" products="321 -321 310 310" 
 <br/>      channel: onMode="1" bRatio="0.0005000" products="2212 -2212 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0058000" products="211 211 211 -211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.6110080" meMode="52" products="83 -83" 
 
<p/>particle: id="20513" name="B*_10" antiName="B*_1bar0" spinType="3" chargeType="0" colType="0" 
          m0="5.78000" mWidth="0.05000" mMin="5.68000" mMax="5.88000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="523 -211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="513 111" 
 
<p/>particle: id="20523" name="B*_1+" antiName="B*_1-" spinType="3" chargeType="3" colType="0" 
          m0="5.78000" mWidth="0.05000" mMin="5.68000" mMax="5.88000" 
 <br/>      channel: onMode="1" bRatio="0.6670000" products="513 211" 
 <br/>      channel: onMode="1" bRatio="0.3330000" products="523 111" 
 
<p/>particle: id="20533" name="B*_1s0" antiName="B*_1sbar0" spinType="3" chargeType="0" colType="0" 
          m0="6.02000" mWidth="0.05000" mMin="5.92000" mMax="6.12000" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="523 -321" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="513 -311" 
 
<p/>particle: id="20543" name="B*_1c+" antiName="B*_1c-" spinType="3" chargeType="3" colType="0" 
          m0="7.30000" mWidth="0.05000" mMin="7.20000" mMax="7.40000" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="513 411" 
 <br/>      channel: onMode="1" bRatio="0.5000000" products="523 421" 
 
<p/>particle: id="20553" name="chi_1b" spinType="3" chargeType="0" colType="0" 
          m0="9.89280" 
 <br/>      channel: onMode="1" bRatio="0.3500000" products="553 22" 
 <br/>      channel: onMode="1" bRatio="0.6500000" meMode="91" products="21 21" 
 
<p/>particle: id="23122" name="Lambda(1600)0" antiName="Lambda(1600)bar0" spinType="2" chargeType="0" colType="0" 
          m0="1.60000" mWidth="0.15000" mMin="1.42000" mMax="2.20000" 
 <br/>      channel: onMode="1" bRatio="0.1760000" products="2212 -321" 
 <br/>      channel: onMode="1" bRatio="0.1760000" products="2112 -311" 
 <br/>      channel: onMode="1" bRatio="0.2160000" products="3222 -211" 
 <br/>      channel: onMode="1" bRatio="0.2160000" products="3112 211" 
 <br/>      channel: onMode="1" bRatio="0.2160000" products="3212 111" 
 
<p/>particle: id="30313" name="K*(1680)0" antiName="K*(1680)bar0" spinType="3" chargeType="0" colType="0" 
          m0="1.71700" mWidth="0.32000" mMin="1.05000" mMax="2.50000" 
 <br/>      channel: onMode="1" bRatio="0.2580000" products="321 -211" 
 <br/>      channel: onMode="1" bRatio="0.1290000" products="311 111" 
 <br/>      channel: onMode="1" bRatio="0.2093000" products="323 -211" 
 <br/>      channel: onMode="1" bRatio="0.1047000" products="313 111" 
 <br/>      channel: onMode="1" bRatio="0.1993000" products="-213 321" 
 <br/>      channel: onMode="1" bRatio="0.0997000" products="113 311" 
 
<p/>particle: id="30323" name="K*(1680)+" antiName="K*(1680)-" spinType="3" chargeType="3" colType="0" 
          m0="1.71700" mWidth="0.32000" mMin="1.05000" mMax="2.50000" 
 <br/>      channel: onMode="1" bRatio="0.2580000" products="311 211" 
 <br/>      channel: onMode="1" bRatio="0.1290000" products="321 111" 
 <br/>      channel: onMode="1" bRatio="0.2093000" products="313 211" 
 <br/>      channel: onMode="1" bRatio="0.1047000" products="323 111" 
 <br/>      channel: onMode="1" bRatio="0.1993000" products="213 311" 
 <br/>      channel: onMode="1" bRatio="0.0997000" products="113 321" 
 
<p/>particle: id="30443" name="psi(3770)" spinType="3" chargeType="0" colType="0" 
          m0="3.77315" mWidth="0.02720" mMin="3.54110" mMax="4.00110" 
 <br/>      channel: onMode="1" bRatio="0.4243000" products="411 -411" 
 <br/>      channel: onMode="1" bRatio="0.5723000" products="421 -421" 
 <br/>      channel: onMode="1" bRatio="0.0034000" products="443 211 -211" 
 
<p/>particle: id="33122" name="Lambda(1670)0" antiName="Lambda(1670)bar0" spinType="2" chargeType="0" colType="0" 
          m0="1.67000" mWidth="0.03500" mMin="1.42000" mMax="2.00000" 
 <br/>      channel: onMode="1" bRatio="0.1000000" products="2212 -321" 
 <br/>      channel: onMode="1" bRatio="0.1000000" products="2112 -311" 
 <br/>      channel: onMode="1" bRatio="0.1600000" products="3222 -211" 
 <br/>      channel: onMode="1" bRatio="0.1600000" products="3112 211" 
 <br/>      channel: onMode="1" bRatio="0.1600000" products="3212 111" 
 <br/>      channel: onMode="1" bRatio="0.3200000" products="3122 221" 
 
<p/>particle: id="100113" name="rho(1450)0" spinType="3" chargeType="0" colType="0" 
          m0="1.46500" mWidth="0.40000" mMin="1.00000" mMax="2.20000" 
 <br/>      channel: onMode="1" bRatio="0.4000000" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.3500000" products="211 -211 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.1500000" products="211 -211 111 111" 
 <br/>      channel: onMode="1" bRatio="0.1000000" products="111 111 111 111" 
 
<p/>particle: id="100213" name="rho(1450)+" antiName="rho(1450)-" spinType="3" chargeType="3" colType="0" 
          m0="1.46500" mWidth="0.40000" mMin="1.00000" mMax="2.20000" 
 <br/>      channel: onMode="1" bRatio="0.4000000" products="211 111" 
 <br/>      channel: onMode="1" bRatio="0.4000000" products="211 211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.2000000" products="211 111 111 111" 
 
<p/>particle: id="100441" name="eta_c(2S)" spinType="1" chargeType="0" colType="0" 
          m0="3.63890" mWidth="0.01000" mMin="3.49800" mMax="3.77800" 
 <br/>      channel: onMode="1" bRatio="0.0190000" products="321 -311 -211" 
 <br/>      channel: onMode="1" bRatio="0.0190000" products="-321 311 211" 
 <br/>      channel: onMode="1" bRatio="0.0095000" products="111 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0095000" products="311 -311 111" 
 <br/>      channel: onMode="1" bRatio="0.9430000" meMode="52" products="83 -83" 
 
<p/>particle: id="100443" name="psi(2S)" spinType="3" chargeType="0" colType="0" 
          m0="3.68611" mWidth="0.00030" mMin="3.68269" mMax="3.68949" 
 <br/>      channel: onMode="1" bRatio="0.0073500" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0073000" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0028000" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000080" products="113 111" 
 <br/>      channel: onMode="1" bRatio="0.0000800" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000080" products="213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000080" products="-213 211" 
 <br/>      channel: onMode="1" bRatio="0.0000300" products="221 113" 
 <br/>      channel: onMode="1" bRatio="0.0000250" products="223 111" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="223 221" 
 <br/>      channel: onMode="1" bRatio="0.0002100" products="225 22" 
 <br/>      channel: onMode="1" bRatio="0.0000520" products="310 130" 
 <br/>      channel: onMode="1" bRatio="0.0000460" products="313 311" 
 <br/>      channel: onMode="1" bRatio="0.0000460" products="-313 311" 
 <br/>      channel: onMode="1" bRatio="0.0001000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000065" products="323 -321" 
 <br/>      channel: onMode="1" bRatio="0.0000065" products="-323 321" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="331 22" 
 <br/>      channel: onMode="1" bRatio="0.0000010" products="333 111" 
 <br/>      channel: onMode="1" bRatio="0.0000200" products="333 221" 
 <br/>      channel: onMode="1" bRatio="0.0032000" products="441 22" 
 <br/>      channel: onMode="1" bRatio="0.0013000" products="443 111" 
 <br/>      channel: onMode="1" bRatio="0.0324000" products="443 221" 
 <br/>      channel: onMode="1" bRatio="0.0933000" products="445 22" 
 <br/>      channel: onMode="1" bRatio="0.0002100" products="2212 -2212" 
 <br/>      channel: onMode="1" bRatio="0.0001300" products="2224 -2224" 
 <br/>      channel: onMode="1" bRatio="0.0001800" products="3122 -3122" 
 <br/>      channel: onMode="1" bRatio="0.0001200" products="3212 -3212" 
 <br/>      channel: onMode="1" bRatio="0.0001100" products="3224 -3224" 
 <br/>      channel: onMode="1" bRatio="0.0000900" products="3312 -3312" 
 <br/>      channel: onMode="1" bRatio="0.0002140" products="10113 111" 
 <br/>      channel: onMode="1" bRatio="0.0002140" products="10213 -211" 
 <br/>      channel: onMode="1" bRatio="0.0002140" products="-10213 211" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="10323 -321" 
 <br/>      channel: onMode="1" bRatio="0.0010000" products="-10323 321" 
 <br/>      channel: onMode="1" bRatio="0.0922000" products="10441 22" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="10443 111" 
 <br/>      channel: onMode="1" bRatio="0.0907000" products="20443 22" 
 <br/>      channel: onMode="1" bRatio="0.0001640" products="211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0004200" products="211 -211 113" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="321 -321 223" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="333 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0000600" products="333 321 -321" 
 <br/>      channel: onMode="1" bRatio="0.1658000" products="443 111 111" 
 <br/>      channel: onMode="1" bRatio="0.3366000" products="443 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0001400" products="2212 -2212 111" 
 <br/>      channel: onMode="1" bRatio="0.0002200" products="310 310 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0016000" products="321 -321 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0008000" products="2212 -2212 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0030000" products="211 211 -211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0001500" products="211 211 211 -211 -211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0035000" products="211 211 211 -211 -211 -211 111" 
 <br/>      channel: onMode="1" bRatio="0.0168000" meMode="53" products="83 -83" 
 <br/>      channel: onMode="1" bRatio="0.1258780" meMode="92" products="21 21 21" 
 <br/>      channel: onMode="1" bRatio="0.0089380" meMode="92" products="22 21 21" 
 
<p/>particle: id="100553" name="Upsilon(2S)" spinType="3" chargeType="0" colType="0" 
          m0="10.02326" mWidth="0.00003" mMin="10.02297" mMax="10.02357" 
 <br/>      channel: onMode="1" bRatio="0.0191000" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0193000" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0170000" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0670000" products="555 22" 
 <br/>      channel: onMode="1" bRatio="0.0430000" products="10551 22" 
 <br/>      channel: onMode="1" bRatio="0.0660000" products="20553 22" 
 <br/>      channel: onMode="1" bRatio="0.0900000" products="553 111 111" 
 <br/>      channel: onMode="1" bRatio="0.1850000" products="553 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="91" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0200000" meMode="91" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0050000" meMode="91" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0200000" meMode="91" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.4276000" meMode="92" products="21 21 21" 
 <br/>      channel: onMode="1" bRatio="0.0160000" meMode="92" products="22 21 21" 
 
<p/>particle: id="200553" name="Upsilon(3S)" spinType="3" chargeType="0" colType="0" 
          m0="10.3552" mWidth="0.00002" mMin="10.3552" mMax="10.3552" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0379639" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0398795" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0383122" products="553 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0761019" products="553 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0322171" products="100553 111 111" 
 <br/>      channel: onMode="1" bRatio="0.0491092" products="100553 211 -211" 
 <br/>      channel: onMode="1" bRatio="0.0870731" products="100553 22 22" 
 <br/>      channel: onMode="1" bRatio="0.0007488" products="10553 111" 
 <br/>      channel: onMode="1" bRatio="0.6217021" meMode="92" products="21 21 21" 
 <br/>      channel: onMode="1" bRatio="0.0168922" meMode="92" products="22 21 21" 
 
<p/>particle: id="1000001" name="~d_L" antiName="~d_Lbar" spinType="1" chargeType="-1" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -5" 
 
<p/>particle: id="1000002" name="~u_L" antiName="~u_Lbar" spinType="1" chargeType="2" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -5" 
 
<p/>particle: id="1000003" name="~s_L" antiName="~s_Lbar" spinType="1" chargeType="-1" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -5" 
 
<p/>particle: id="1000004" name="~c_L" antiName="~c_Lbar" spinType="1" chargeType="2" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -5" 
 
<p/>particle: id="1000005" name="~b_1" antiName="~b_1bar" spinType="1" chargeType="-1" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -3" 
 
<p/>particle: id="1000006" name="~t_1" antiName="~t_1bar" spinType="1" chargeType="2" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -5" 
 
<p/>particle: id="1000011" name="~e_L-" antiName="~e_L+" spinType="1" chargeType="-3" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000012 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000012 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000012 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 5" 
 
<p/>particle: id="1000012" name="~nu_eL" antiName="~nu_eLbar" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000011 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000011 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000011 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000011 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 5" 
 
<p/>particle: id="1000013" name="~mu_L-" antiName="~mu_L+" spinType="1" chargeType="-3" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000014 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000014 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000014 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000014 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 5" 
 
<p/>particle: id="1000014" name="~nu_muL" antiName="~nu_muLbar" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000013 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000013 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000013 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000013 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 5" 
 
<p/>particle: id="1000015" name="~tau_1-" antiName="~tau_1+" spinType="1" chargeType="-3" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000016 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000016 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000016 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000016 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 5" 
 
<p/>particle: id="1000016" name="~nu_tauL" antiName="~nu_tauLbar" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000015 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000015 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000015 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000015 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 5" 
 
<p/>particle: id="1000021" name="~g" spinType="2" chargeType="0" colType="2" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 21" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000006 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 3 5" 
 
<p/>particle: id="1000022" name="~chi_10" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="20.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 3 5" 
 
<p/>particle: id="1000023" name="~chi_20" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000011 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000011 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000011 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000011 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000012 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000012 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000012 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000012 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000013 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000013 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000013 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000013 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000014 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000014 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000014 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000014 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000015 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000015 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000015 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000015 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000016 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000016 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000016 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000016 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 16 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 11 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 13 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 15 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 11 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 13 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 15 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000006 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 3 5" 
 
<p/>particle: id="1000024" name="~chi_1+" antiName="~chi_1-" spinType="2" chargeType="3" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000012 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000012 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000011 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000011 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000014 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000014 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000013 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000013 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000016 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000016 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000015 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000015 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 14 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 14 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 14 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 16 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 16 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 16 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 16 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 16 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 16 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 6 3" 
 
<p/>particle: id="1000025" name="~chi_30" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000011 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000011 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000011 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000011 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000012 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000012 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000012 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000012 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000013 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000013 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000013 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000013 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000014 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000014 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000014 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000014 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000015 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000015 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000015 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000015 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000016 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000016 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000016 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000016 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 16 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 16 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 11 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 13 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 15 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 11 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 13 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 15 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000006 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 3 5" 
 
<p/>particle: id="1000035" name="~chi_40" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 22" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 16 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 16 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 16 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 11 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 13 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 15 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 11 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 13 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 15 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000011 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000011 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000011 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000011 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000012 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000012 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000012 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000012 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000013 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000013 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000013 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000013 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000014 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000014 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000014 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000014 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000015 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000015 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000015 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000015 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000016 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000016 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000016 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000016 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000002 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000002 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000004 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000004 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000006 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000006 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 3 5" 
 
<p/>particle: id="1000037" name="~chi_2+" antiName="~chi_2-" spinType="2" chargeType="3" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 16 -16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000012 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000012 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000011 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000011 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000014 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000014 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000013 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000013 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000016 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000016 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000015 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000015 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 2 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 2 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 4 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 4 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 6 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 6 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000001 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000001 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000003 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000003 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000005 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2000005 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 14 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 14 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -13 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 14 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 16 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 16 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 16 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 12 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 12 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -11 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 12 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 16 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -15 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 16 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -15 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -15 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 16 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -15 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 12 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -11 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 12 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -11 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -11 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 12 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -11 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 14 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -13 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 14 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -13 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -13 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 14 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -13 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -2 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -4 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -6 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -2 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -4 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -6 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -1 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -1 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -2 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -1 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -3 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -3 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -4 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -3 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -5 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -5 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -6 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 -5 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 6 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -3 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 6 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 6 3" 
 
<p/>particle: id="1000039" name="~Gravitino" spinType="0" chargeType="0" colType="0" 
          m0="1.000e-03" 
 
<p/>particle: id="1000045" name="~chi_50" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" 
 
<p/>particle: id="1000512" name="R0(~b dbar)" antiName="R0(~bbar d)" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000522" name="R-(~b ubar)" antiName="R+(~bbar u)" spinType="2" chargeType="-3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000532" name="R0(~b sbar)" antiName="R0(~bbar s)" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000542" name="R-(~b cbar)" antiName="R+(~bbar c)" spinType="2" chargeType="-3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000552" name="R0(~b bbar)" antiName="R0(~bbar b)" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000612" name="R+(~t dbar)" antiName="R-(~tbar d)" spinType="2" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000622" name="R0(~t ubar)" antiName="R0(~tbar u)" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000632" name="R+(~t sbar)" antiName="R-(~tbar s)" spinType="2" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000642" name="R0(~t cbar)" antiName="R0(~tbar c)" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000652" name="R+(~t bbar)" antiName="R-(~tbar b)" spinType="2" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1000993" name="R0(~g g)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1005113" name="R-(~b dd1)" antiName="Rbar+(~b dd1)" spinType="3" chargeType="-3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1005211" name="R0(~b ud0)" antiName="Rbar0(~b ud0)" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1005213" name="R0(~b ud1)" antiName="Rbar0(~b ud1)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1005223" name="R+(~b uu1)" antiName="Rbar-(~b uu1)" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1005311" name="R-(~b sd0)" antiName="Rbar+(~b sd0)" spinType="1" chargeType="-3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1005313" name="R-(~b sd1)" antiName="Rbar+(~b sd1)" spinType="3" chargeType="-3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1005321" name="R0(~b su0)" antiName="Rbar0(~b su0)" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1005323" name="R0(~b su1)" antiName="Rbar0(~b su1)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1005333" name="R-(~b ss1)" antiName="Rbar+(~b ss1)" spinType="3" chargeType="-3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1006113" name="R0(~t dd1)" antiName="Rbar0(~t dd1)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1006211" name="R+(~t ud0)" antiName="Rbar-(~t ud0)" spinType="1" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1006213" name="R+(~t ud1)" antiName="Rbar-(~t ud1)" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1006223" name="R++(~t uu1)" antiName="Rbar--(~t uu1)" spinType="3" chargeType="6" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1006311" name="R-(~t sd0)" antiName="Rbar+(~t sd0)" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1006313" name="R-(~t sd1)" antiName="Rbar+(~t sd1)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1006321" name="R0(~t su0)" antiName="Rbar0(~t su0)" spinType="1" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1006323" name="R0(~t su1)" antiName="Rbar0(~t su1)" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1006333" name="R0(~t ss1)" antiName="Rbar0(~t ss1)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009002" name="Rtemp(~g q)" antiName="Rtemp(~g qbar)" spinType="2" chargeType="0" colType="1" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009113" name="R0(~g d dbar)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009213" name="R+(~g u dbar)" antiName="R-(~g d ubar)" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009223" name="R0(~g u ubar)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009313" name="R0(~g d sbar)" antiName="R0(~g s dbar)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009323" name="R+(~g u sbar)" antiName="R-(~g s ubar)" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009333" name="R0(~g s sbar)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009413" name="R+(~g c dbar)" antiName="R-(~g d cbar)" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009423" name="R0(~g c ubar)" antiName="R0(~g u cbar)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009433" name="R+(~g c sbar)" antiName="R-(~g s cbar)" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009443" name="R0(~g c cbar)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009513" name="R0(~g d bbar)" antiName="R0(~g b dbar)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009523" name="R+(~g u bbar)" antiName="R-(~g b ubar)" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009533" name="R0(~g s bbar)" antiName="R0(~g b sbar)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009543" name="R+(~g c bbar)" antiName="R-(~g b cbar)" spinType="3" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1009553" name="R0(~g b bbar)" spinType="3" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1091114" name="R-(~g ddd)" antiName="Rbar+(~g ddd)" spinType="4" chargeType="-3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1092114" name="R0(~g udd)" antiName="Rbar0(~g udd)" spinType="4" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1092214" name="R+(~g uud)" antiName="Rbar-(~g uud)" spinType="4" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1092224" name="R++(~g uuu)" antiName="Rbar--(~g uuu)" spinType="4" chargeType="6" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1093114" name="R-(~g sdd)" antiName="Rbar+(~g sdd)" spinType="4" chargeType="-3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1093214" name="R0(~g sud)" antiName="Rbar0(~g sud)" spinType="4" chargeType="0" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1093224" name="R+(~g suu)" antiName="Rbar-(~g suu)" spinType="4" chargeType="3" colType="0" 
          m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1093314" name="R-(~g ssd)" antiName="Rbar+(~g ssd)" spinType="4" chargeType="-3" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1093324" name="R0(~g ssu)" antiName="Rbar0(~g ssu)" spinType="4" chargeType="0" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1093334" name="R-(~g sss)" antiName="Rbar+(~g sss)" spinType="4" chargeType="-3" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1094114" name="R0(~g cdd)" antiName="Rbar0(~g cdd)" spinType="4" chargeType="0" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1094214" name="R+(~g cud)" antiName="Rbar-(~g cud)" spinType="4" chargeType="3" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1094224" name="R++(~g cuu)" antiName="Rbar--(~g cuu)" spinType="4" chargeType="6" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1094314" name="R0(~g csd)" antiName="Rbar0(~g csd)" spinType="4" chargeType="0" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1094324" name="R+(~g csu)" antiName="Rbar-(~g csu)" spinType="4" chargeType="3" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1094334" name="R0(~g css)" antiName="Rbar0(~g css)" spinType="4" chargeType="0" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1095114" name="R-(~g bdd)" antiName="Rbar+(~g bdd)" spinType="4" chargeType="-3" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1095214" name="R0(~g bud)" antiName="Rbar0(~g bud)" spinType="4" chargeType="0" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1095224" name="R+(~g buu)" antiName="Rbar-(~g buu)" spinType="4" chargeType="3" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1095314" name="R-(~g bsd)" antiName="Rbar+(~g bsd)" spinType="4" chargeType="-3" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1095324" name="R0(~g bsu)" antiName="Rbar0(~g bsu)" spinType="4" chargeType="0" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="1095334" name="R-(~g bss)" antiName="Rbar+(~g bss)" spinType="4" chargeType="-3" colType="0" 
           m0="500.00000" tau0="1e-05" 
 
<p/>particle: id="2000001" name="~d_R" antiName="~d_Rbar" spinType="1" chargeType="-1" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -5" 
 
<p/>particle: id="2000002" name="~u_R" antiName="~u_Rbar" spinType="1" chargeType="2" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -5" 
 
<p/>particle: id="2000003" name="~s_R" antiName="~s_Rbar" spinType="1" chargeType="-1" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -5" 
 
<p/>particle: id="2000004" name="~c_R" antiName="~c_Rbar" spinType="1" chargeType="2" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -5" 
 
<p/>particle: id="2000005" name="~b_2" antiName="~b_2bar" spinType="1" chargeType="-1" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000006 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 -3" 
 
<p/>particle: id="2000006" name="~t_2" antiName="~t_2bar" spinType="1" chargeType="2" colType="1" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000024 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000037 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000002 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000004 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000006 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000002 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000004 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000001 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000003 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000005 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000021 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-3 -5" 
 
<p/>particle: id="2000011" name="~e_R-" antiName="~e_R+" spinType="1" chargeType="-3" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000011 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000011 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000011 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000011 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000012 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000012 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000012 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000012 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 5" 
 
<p/>particle: id="2000012" name="~nu_eR" antiName="~nu_eRbar" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" 
 
<p/>particle: id="2000013" name="~mu_R-" antiName="~mu_R+" spinType="1" chargeType="-3" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000013 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000013 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000013 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000013 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000014 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000014 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000014 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000014 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-16 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 5" 
 
<p/>particle: id="2000014" name="~nu_muR" antiName="~nu_muRbar" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" 
 
<p/>particle: id="2000015" name="~tau_2-" antiName="~tau_2+" spinType="1" chargeType="-3" colType="0" 
          m0="500.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" meMode="103" products="1000039 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000024 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1000037 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000022 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000023 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000025 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000035 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000015 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000015 25" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000015 35" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000015 36" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000016 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000016 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1000016 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2000016 -37" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-12 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-14 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-2 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-4 5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-6 5" 
 
<p/>particle: id="2000016" name="~nu_tauR" antiName="~nu_tauRbar" spinType="1" chargeType="0" colType="0" 
          m0="500.00000" 
 
<p/>particle: id="3000111" name="pi_tc0" spinType="1" chargeType="0" colType="0" 
          m0="110.00000" mWidth="0.02911" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0174310" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0540480" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.8576940" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0002500" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0705780" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="21 21" 
 
<p/>particle: id="3000113" name="rho_tc0" spinType="3" chargeType="0" colType="0" 
          m0="210.00000" mWidth="0.86860" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.1440510" products="24 -24" 
 <br/>      channel: onMode="1" bRatio="0.3519020" products="24 -3000211" 
 <br/>      channel: onMode="1" bRatio="0.3519020" products="3000211 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="3000211 -3000211" 
 <br/>      channel: onMode="1" bRatio="0.0821070" products="22 3000111" 
 <br/>      channel: onMode="1" bRatio="0.0295660" products="22 3000221" 
 <br/>      channel: onMode="1" bRatio="0.0015110" products="23 3000111" 
 <br/>      channel: onMode="1" bRatio="0.0007260" products="23 3000221" 
 <br/>      channel: onMode="1" bRatio="0.0045180" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0065220" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0045180" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0065220" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0045130" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0029080" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0009730" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0029080" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0009730" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0029080" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0009730" products="16 -16" 
 
<p/>particle: id="3000211" name="pi_tc+" antiName="pi_tc-" spinType="1" chargeType="3" colType="0" 
          m0="110.00000" mWidth="0.01741" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0227480" products="4 -1" 
 <br/>      channel: onMode="1" bRatio="0.0265760" products="4 -3" 
 <br/>      channel: onMode="1" bRatio="0.3594860" products="2 -5" 
 <br/>      channel: onMode="1" bRatio="0.5615810" products="4 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="24 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 12" 
 <br/>      channel: onMode="1" bRatio="0.0001040" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.0295040" products="-15 16" 
 
<p/>particle: id="3000213" name="rho_tc+" antiName="rho_tc-" spinType="3" chargeType="3" colType="0" 
          m0="210.00000" mWidth="0.62395" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.1439820" products="24 23" 
 <br/>      channel: onMode="1" bRatio="0.4898880" products="24 3000111" 
 <br/>      channel: onMode="1" bRatio="0.1951000" products="3000211 23" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="3000211 3000111" 
 <br/>      channel: onMode="1" bRatio="0.1143020" products="3000211 22" 
 <br/>      channel: onMode="1" bRatio="0.0084260" products="24 3000221" 
 <br/>      channel: onMode="1" bRatio="0.0148680" products="-1 2" 
 <br/>      channel: onMode="1" bRatio="0.0007630" products="-1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-1 6" 
 <br/>      channel: onMode="1" bRatio="0.0007630" products="-3 2" 
 <br/>      channel: onMode="1" bRatio="0.0148400" products="-3 4" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="-3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-5 2" 
 <br/>      channel: onMode="1" bRatio="0.0000270" products="-5 4" 
 <br/>      channel: onMode="1" bRatio="0.0019450" products="-5 6" 
 <br/>      channel: onMode="1" bRatio="0.0050300" products="-11 12" 
 <br/>      channel: onMode="1" bRatio="0.0050300" products="-13 14" 
 <br/>      channel: onMode="1" bRatio="0.0050300" products="-15 16" 
 
<p/>particle: id="3000221" name="pi'_tc0" spinType="1" chargeType="0" colType="0" 
          m0="110.00000" mWidth="0.04536" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0111850" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0346810" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.5503540" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0001600" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0452870" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.3583330" products="21 21" 
 
<p/>particle: id="3000223" name="omega_tc" spinType="3" chargeType="0" colType="0" 
          m0="210.00000" mWidth="0.19192" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.1337760" products="22 3000111" 
 <br/>      channel: onMode="1" bRatio="0.0032840" products="23 3000111" 
 <br/>      channel: onMode="1" bRatio="0.3716900" products="22 3000221" 
 <br/>      channel: onMode="1" bRatio="0.0068380" products="23 3000221" 
 <br/>      channel: onMode="1" bRatio="0.0309540" products="24 -3000211" 
 <br/>      channel: onMode="1" bRatio="0.0309540" products="3000211 -24" 
 <br/>      channel: onMode="1" bRatio="0.0016300" products="24 -24" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="3000211 -3000211" 
 <br/>      channel: onMode="1" bRatio="0.0472240" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0737370" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0472240" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0737320" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0471790" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0347610" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0091660" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0347610" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0091660" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0347590" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0091660" products="16 -16" 
 
<p/>particle: id="3000331" name="eta_tc0" spinType="1" chargeType="0" colType="2" 
          m0="350.00000" mWidth="0.09511" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.4457810" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.5542190" products="21 21" 
 
<p/>particle: id="3100021" name="V8_tc" spinType="1" chargeType="0" colType="2" 
          m0="500.00000" mWidth="123.27638" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0090690" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0090690" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0090690" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0090690" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.5101470" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.4535760" products="6 -6" 
 
<p/>particle: id="3100111" name="pi_22_1_tc" spinType="1" chargeType="0" colType="0" 
          m0="125.00000" mWidth="0.02296" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="21 21" 
 
<p/>particle: id="3100113" name="rho_11_tc" spinType="3" chargeType="0" colType="2" 
          m0="400.00000" mWidth="23.26819" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0011280" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0011280" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0011280" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0011280" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.5710470" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.3822880" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0421530" products="21 21" 
 
<p/>particle: id="3200111" name="pi_22_8_tc" spinType="1" chargeType="0" colType="2" 
          m0="250.00000" mWidth="0.18886" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="21 21" 
 
<p/>particle: id="3200113" name="rho_12_tc" spinType="3" chargeType="0" colType="2" 
          m0="350.00000" mWidth="2.86306" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0165970" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0165970" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0165970" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0165970" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.9336100" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 
<p/>particle: id="3300113" name="rho_21_tc" spinType="3" chargeType="0" colType="2" 
          m0="350.00000" 
 <br/>      channel: onMode="1" bRatio="0.0165970" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0165970" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0165970" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0165970" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.9336100" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 
<p/>particle: id="3400113" name="rho_22_tc" spinType="3" chargeType="0" colType="2" 
          m0="300.00000" mWidth="3.45903" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0551500" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0551500" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0551500" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0551500" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.3446900" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.2289980" products="21 21" 
 <br/>      channel: onMode="1" bRatio="0.1642080" products="3100111 21" 
 <br/>      channel: onMode="1" bRatio="0.0415030" products="3200111 21" 
 
<p/>particle: id="4000001" name="d*" antiName="d*bar" spinType="2" chargeType="-1" colType="1" 
          m0="400.00000" mWidth="2.59359" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.8509730" products="21 1" 
 <br/>      channel: onMode="1" bRatio="0.0054110" products="22 1" 
 <br/>      channel: onMode="1" bRatio="0.0450250" products="23 1" 
 <br/>      channel: onMode="1" bRatio="0.0985910" products="-24 2" 
 
<p/>particle: id="4000002" name="u*" antiName="u*bar" spinType="2" chargeType="2" colType="1" 
          m0="400.00000" mWidth="2.59687" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.8498980" products="21 2" 
 <br/>      channel: onMode="1" bRatio="0.0216170" products="22 2" 
 <br/>      channel: onMode="1" bRatio="0.0300180" products="23 2" 
 <br/>      channel: onMode="1" bRatio="0.0984660" products="24 1" 
 
<p/>particle: id="4000003" name="s*" antiName="s*bar" spinType="2" chargeType="-1" colType="1" 
          m0="400.00000" mWidth="2.59359" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.8509730" products="21 3" 
 <br/>      channel: onMode="1" bRatio="0.0054110" products="22 3" 
 <br/>      channel: onMode="1" bRatio="0.0450250" products="23 3" 
 <br/>      channel: onMode="1" bRatio="0.0985910" products="-24 4" 
 
<p/>particle: id="4000004" name="c*" antiName="c*bar" spinType="2" chargeType="2" colType="1" 
          m0="400.00000" mWidth="2.59687" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.8498980" products="21 4" 
 <br/>      channel: onMode="1" bRatio="0.0216170" products="22 4" 
 <br/>      channel: onMode="1" bRatio="0.0300180" products="23 4" 
 <br/>      channel: onMode="1" bRatio="0.0984660" products="24 3" 
 
<p/>particle: id="4000005" name="b*" antiName="b*bar" spinType="2" chargeType="-1" colType="1" 
          m0="400.00000" mWidth="2.59359" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.8509730" products="21 5" 
 <br/>      channel: onMode="1" bRatio="0.0054110" products="22 5" 
 <br/>      channel: onMode="1" bRatio="0.0450250" products="23 5" 
 <br/>      channel: onMode="1" bRatio="0.0985910" products="-24 6" 
 
<p/>particle: id="4000006" name="t*" antiName="t*bar" spinType="2" chargeType="2" colType="1" 
          m0="400.00000" mWidth="2.59687" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.8498980" products="21 6" 
 <br/>      channel: onMode="1" bRatio="0.0216170" products="22 6" 
 <br/>      channel: onMode="1" bRatio="0.0300180" products="23 6" 
 <br/>      channel: onMode="1" bRatio="0.0984660" products="24 5" 
 
<p/>particle: id="4000011" name="e*-" antiName="e*bar+" spinType="2" chargeType="-3" colType="0" 
          m0="400.00000" mWidth="0.42896" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.2944480" products="22 11" 
 <br/>      channel: onMode="1" bRatio="0.1094500" products="23 11" 
 <br/>      channel: onMode="1" bRatio="0.5961020" products="-24 12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 16 -16" 
 
<p/>particle: id="4000012" name="nu*_e0" antiName="nu*_ebar0" spinType="2" chargeType="0" colType="0" 
          m0="400.00000" mWidth="0.41912" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.3899060" products="23 12" 
 <br/>      channel: onMode="1" bRatio="0.6100940" products="24 11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="12 16 -16" 
 
<p/>particle: id="4000013" name="mu*-" antiName="mu*bar+" spinType="2" chargeType="-3" colType="0" 
          m0="400.00000" mWidth="0.42896" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.2944480" products="22 13" 
 <br/>      channel: onMode="1" bRatio="0.1094500" products="23 13" 
 <br/>      channel: onMode="1" bRatio="0.5961020" products="-24 14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 16 -16" 
 
<p/>particle: id="4000014" name="nu*_mu0" antiName="nu*_mubar0" spinType="2" chargeType="0" colType="0" 
          m0="400.00000" mWidth="0.41912" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.3899060" products="23 14" 
 <br/>      channel: onMode="1" bRatio="0.6100940" products="24 13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="14 16 -16" 
 
<p/>particle: id="4000015" name="tau*-" antiName="tau*bar+" spinType="2" chargeType="-3" colType="0" 
          m0="400.00000" mWidth="0.42896" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.2944480" products="22 15" 
 <br/>      channel: onMode="1" bRatio="0.1094500" products="23 15" 
 <br/>      channel: onMode="1" bRatio="0.5961020" products="-24 16" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 16 -16" 
 
<p/>particle: id="4000016" name="nu*_tau0" antiName="nu*_taubar0" spinType="2" chargeType="0" colType="0" 
          m0="400.00000" mWidth="0.41912" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.3899060" products="23 16" 
 <br/>      channel: onMode="1" bRatio="0.6100940" products="24 15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="16 16 -16" 
 
<p/>particle: id="4900001" name="Dv" antiName="Dvbar" spinType="2" chargeType="-1" colType="1" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="1 4900101" 
 
<p/>particle: id="4900002" name="Uv" antiName="Uvbar" spinType="2" chargeType="2" colType="1" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="2 4900101" 
 
<p/>particle: id="4900003" name="Sv" antiName="Svbar" spinType="2" chargeType="-1" colType="1" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="3 4900101" 
 
<p/>particle: id="4900004" name="Cv" antiName="Cvbar" spinType="2" chargeType="2" colType="1" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="4 4900101" 
 
<p/>particle: id="4900005" name="Bv" antiName="Bvbar" spinType="2" chargeType="-1" colType="1" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="5 4900101" 
 
<p/>particle: id="4900006" name="Tv" antiName="Tvbar" spinType="2" chargeType="2" colType="1" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="6 4900101" 
 
<p/>particle: id="4900011" name="Ev" antiName="Evbar" spinType="2" chargeType="-3" colType="0" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="11 4900101" 
 
<p/>particle: id="4900012" name="nuEv" antiName="nuEvbar" spinType="2" chargeType="0" colType="0" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="12 4900101" 
 
<p/>particle: id="4900013" name="MUv" antiName="MUvbar" spinType="2" chargeType="-3" colType="0" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="13 4900101" 
 
<p/>particle: id="4900014" name="nuMUv" antiName="nuMUvbar" spinType="2" chargeType="0" colType="0" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="14 4900101" 
 
<p/>particle: id="4900015" name="TAUv" antiName="TAUvbar" spinType="2" chargeType="-3" colType="0" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="15 4900101" 
 
<p/>particle: id="4900016" name="nuTAUv" antiName="nuTAUvbar" spinType="2" chargeType="0" colType="0" 
          m0="400.00000" mWidth="1.00000" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="1.0000000" meMode="103" products="16 4900101" 
 
<p/>particle: id="4900021" name="gv" spinType="3" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="4900022" name="gammav" spinType="3" chargeType="0" colType="0" 
          m0="0.00000" 
 <br/>      channel: onMode="0" bRatio="0.05" meMode="91" products="1 -1" 
 <br/>      channel: onMode="0" bRatio="0.20" meMode="91" products="2 -2" 
 <br/>      channel: onMode="0" bRatio="0.05" meMode="91" products="3 -3" 
 <br/>      channel: onMode="0" bRatio="0.20" meMode="91" products="4 -4" 
 <br/>      channel: onMode="0" bRatio="0.05" meMode="91" products="5 -5" 
 <br/>      channel: onMode="0" bRatio="0.15" meMode="91" products="11 -11" 
 <br/>      channel: onMode="0" bRatio="0.00" meMode="91" products="12 -12" 
 <br/>      channel: onMode="0" bRatio="0.15" meMode="91" products="13 -13" 
 <br/>      channel: onMode="0" bRatio="0.00" meMode="91" products="14 -14" 
 <br/>      channel: onMode="0" bRatio="0.15" meMode="91" products="15 -15" 
 <br/>      channel: onMode="0" bRatio="0.00" meMode="91" products="16 -16" 
 
<p/>particle: id="4900023" name="Zv" spinType="3" chargeType="0" colType="0" 
          m0="1000.00000" mWidth="20.00000" mMin="100.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.075" meMode="102" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.075" meMode="102" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.075" meMode="102" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.075" meMode="102" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.075" meMode="102" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.075" meMode="102" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="102" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="102" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="102" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="102" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="102" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.025" meMode="102" products="16 -16" 
 <br/>      channel: onMode="1" bRatio="0.400" meMode="102" products="4900101 -4900101" 
 
<p/>particle: id="4900101" name="qv" antiName="qvbar" spinType="1" chargeType="0" colType="0" 
          m0="100.00000" 
 
<p/>particle: id="4900111" name="pivDiag" spinType="1" chargeType="0" colType="0" 
          m0="10.00000" 
 <br/>      channel: onMode="0" bRatio="1.23e-6" meMode="91" products="1 -1" 
 <br/>      channel: onMode="0" bRatio="4.96e-7" meMode="91" products="2 -2" 
 <br/>      channel: onMode="0" bRatio="0.000492" meMode="91" products="3 -3" 
 <br/>      channel: onMode="0" bRatio="0.079384" meMode="91" products="4 -4" 
 <br/>      channel: onMode="0" bRatio="0.8679713" meMode="91" products="5 -5" 
 <br/>      channel: onMode="0" bRatio="4.0e-9" meMode="91" products="11 -11" 
 <br/>      channel: onMode="0" bRatio="0.00" meMode="91" products="12 -12" 
 <br/>      channel: onMode="0" bRatio="0.000184" meMode="91" products="13 -13" 
 <br/>      channel: onMode="0" bRatio="0.00" meMode="91" products="14 -14" 
 <br/>      channel: onMode="0" bRatio="0.051967" meMode="91" products="15 -15" 
 <br/>      channel: onMode="0" bRatio="0.00" meMode="91" products="16 -16" 
 
<p/>particle: id="4900113" name="rhovDiag" spinType="3" chargeType="0" colType="0" 
          m0="10.00000" 
 <br/>      channel: onMode="0" bRatio="0.05" meMode="91" products="1 -1" 
 <br/>      channel: onMode="0" bRatio="0.20" meMode="91" products="2 -2" 
 <br/>      channel: onMode="0" bRatio="0.05" meMode="91" products="3 -3" 
 <br/>      channel: onMode="0" bRatio="0.20" meMode="91" products="4 -4" 
 <br/>      channel: onMode="0" bRatio="0.05" meMode="91" products="5 -5" 
 <br/>      channel: onMode="0" bRatio="0.15" meMode="91" products="11 -11" 
 <br/>      channel: onMode="0" bRatio="0.00" meMode="91" products="12 -12" 
 <br/>      channel: onMode="0" bRatio="0.15" meMode="91" products="13 -13" 
 <br/>      channel: onMode="0" bRatio="0.00" meMode="91" products="14 -14" 
 <br/>      channel: onMode="0" bRatio="0.15" meMode="91" products="15 -15" 
 <br/>      channel: onMode="0" bRatio="0.00" meMode="91" products="16 -16" 
 
<p/>particle: id="4900211" name="pivUp" antiName="pivDn" spinType="1" chargeType="0" colType="0" 
          m0="10.00000" 
 
<p/>particle: id="4900213" name="rhovUp" antiName="rhovDn" spinType="3" chargeType="0" colType="0" 
          m0="10.00000" 
 
<p/>particle: id="4900991" name="ggv" spinType="1" chargeType="0" colType="0" 
          m0="1.00000" 
 
<p/>particle: id="5000023" name="Z_KK" spinType="3" chargeType="0" colType="0" 
          m0="4000.00000" mWidth="240.00000" mMin="1000.00000" mMax="0.00000" 
 
<p/>particle: id="5000039" name="Graviton" spinType="5" chargeType="0" colType="0" 
           m0="0.00000" 
 
<p/>particle: id="5100021" name="KKgluon*" spinType="3" chargeType="0" colType="2" 
           m0="1.000e+03" mWidth="1.7e02" mMin="5.000e+01" mMax="0.000e+00" 
 <br/>      channel: onMode="1" bRatio="0.005" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.005" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.005" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.005" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.055" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.925" products="6 -6" 
 
<p/>particle: id="5100039" name="Graviton*" spinType="5" chargeType="0" colType="0" 
          m0="1.000e+03" mWidth="1.415e-01" mMin="5.000e+01" mMax="0.000e+00" 
 <br/>      channel: onMode="1" bRatio="0.0633000" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.0633000" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.0633000" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.0632990" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.0632950" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0562810" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0204950" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0204950" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0204950" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0204950" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0204950" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0204950" products="16 -16" 
 <br/>      channel: onMode="1" bRatio="0.3279190" products="21 21" 
 <br/>      channel: onMode="1" bRatio="0.0409900" products="22 22" 
 <br/>      channel: onMode="1" bRatio="0.0452360" products="23 23" 
 <br/>      channel: onMode="1" bRatio="0.0901120" products="24 -24" 
 <br/>      channel: onMode="1" bRatio="0.0"       products="25 25" 
 
<p/>particle: id="9000111" name="a_0(980)0" spinType="1" chargeType="0" colType="0" 
          m0="0.98350" mWidth="0.06000" mMin="0.70000" mMax="1.50000" 
 <br/>      channel: onMode="1" bRatio="0.9000000" products="221 111" 
 <br/>      channel: onMode="1" bRatio="0.0250000" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0250000" products="310 310" 
 <br/>      channel: onMode="1" bRatio="0.0500000" products="321 -321" 
 
<p/>particle: id="9000211" name="a_0(980)+" antiName="a_0(980)-" spinType="1" chargeType="3" colType="0" 
          m0="0.98350" mWidth="0.06000" mMin="0.70000" mMax="1.50000" 
 <br/>      channel: onMode="1" bRatio="0.9000000" products="221 211" 
 <br/>      channel: onMode="1" bRatio="0.1000000" products="321 311" 
 
<p/>particle: id="9010221" name="f_0(980)" spinType="1" chargeType="0" colType="0" 
          m0="1.00000" 
 <br/>      channel: onMode="1" bRatio="0.5200000" products="211 -211" 
 <br/>      channel: onMode="1" bRatio="0.2600000" products="111 111" 
 <br/>      channel: onMode="1" bRatio="0.1100000" products="321 -321" 
 <br/>      channel: onMode="1" bRatio="0.0550000" products="130 130" 
 <br/>      channel: onMode="1" bRatio="0.0550000" products="310 310" 
 
<p/>particle: id="9900012" name="nu_Re" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" mWidth="0.00098" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.1987400" products="11 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0102040" products="11 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="11 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0102050" products="11 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.1983560" products="11 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0001510" products="11 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="11 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0003670" products="11 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0819670" products="11 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.1987400" products="-11 1 -2" 
 <br/>      channel: onMode="1" bRatio="0.0102040" products="-11 1 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="-11 1 -6" 
 <br/>      channel: onMode="1" bRatio="0.0102050" products="-11 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.1983560" products="-11 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0001510" products="-11 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="-11 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0003670" products="-11 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0819670" products="-11 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 -13 9900014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 13 9900014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="11 -15 9900016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-11 15 9900016" 
 
<p/>particle: id="9900014" name="nu_Rmu" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" mWidth="0.00098" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.1987760" products="13 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0102060" products="13 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="13 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0102070" products="13 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.1983900" products="13 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0001510" products="13 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="13 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0003670" products="13 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0818930" products="13 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.1987760" products="-13 1 -2" 
 <br/>      channel: onMode="1" bRatio="0.0102060" products="-13 1 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="-13 1 -6" 
 <br/>      channel: onMode="1" bRatio="0.0102070" products="-13 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.1983900" products="-13 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0001510" products="-13 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="-13 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0003670" products="-13 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0818930" products="-13 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 -11 9900012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 11 9900012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="13 -15 9900016" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-13 15 9900016" 
 
<p/>particle: id="9900016" name="nu_Rtau" spinType="2" chargeType="0" colType="0" 
          m0="500.00000" mWidth="0.00097" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.1993440" products="15 -1 2" 
 <br/>      channel: onMode="1" bRatio="0.0102340" products="15 -1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="15 -1 6" 
 <br/>      channel: onMode="1" bRatio="0.0102360" products="15 -3 2" 
 <br/>      channel: onMode="1" bRatio="0.1989280" products="15 -3 4" 
 <br/>      channel: onMode="1" bRatio="0.0001490" products="15 -3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="15 -5 2" 
 <br/>      channel: onMode="1" bRatio="0.0003680" products="15 -5 4" 
 <br/>      channel: onMode="1" bRatio="0.0807330" products="15 -5 6" 
 <br/>      channel: onMode="1" bRatio="0.1993440" products="-15 1 -2" 
 <br/>      channel: onMode="1" bRatio="0.0102340" products="-15 1 -4" 
 <br/>      channel: onMode="1" bRatio="0.0000030" products="-15 1 -6" 
 <br/>      channel: onMode="1" bRatio="0.0102360" products="-15 3 -2" 
 <br/>      channel: onMode="1" bRatio="0.1989280" products="-15 3 -4" 
 <br/>      channel: onMode="1" bRatio="0.0001490" products="-15 3 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000060" products="-15 5 -2" 
 <br/>      channel: onMode="1" bRatio="0.0003680" products="-15 5 -4" 
 <br/>      channel: onMode="1" bRatio="0.0807330" products="-15 5 -6" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 -11 9900012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 11 9900012" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="15 -13 9900014" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="-15 13 9900014" 
 
<p/>particle: id="9900023" name="Z_R0" spinType="3" chargeType="0" colType="0" 
          m0="1.200e+03" mWidth="2.672e+01" mMin="5.000e+01" mMax="0.000e+00" 
 <br/>      channel: onMode="1" bRatio="0.1847380" products="1 -1" 
 <br/>      channel: onMode="1" bRatio="0.1045880" products="2 -2" 
 <br/>      channel: onMode="1" bRatio="0.1847380" products="3 -3" 
 <br/>      channel: onMode="1" bRatio="0.1045870" products="4 -4" 
 <br/>      channel: onMode="1" bRatio="0.1847310" products="5 -5" 
 <br/>      channel: onMode="1" bRatio="0.0958200" products="6 -6" 
 <br/>      channel: onMode="1" bRatio="0.0229020" products="11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0084290" products="12 -12" 
 <br/>      channel: onMode="1" bRatio="0.0156020" products="9900012 9900012" 
 <br/>      channel: onMode="1" bRatio="0.0229020" products="13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0084290" products="14 -14" 
 <br/>      channel: onMode="1" bRatio="0.0156020" products="9900014 9900014" 
 <br/>      channel: onMode="1" bRatio="0.0229020" products="15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0084290" products="16 -16" 
 <br/>      channel: onMode="1" bRatio="0.0156020" products="9900016 9900016" 
 
<p/>particle: id="9900024" name="W_R+" antiName="W_R-" spinType="3" chargeType="3" colType="0" 
          m0="750.00000" mWidth="21.74916" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.2895900" products="-1 2" 
 <br/>      channel: onMode="1" bRatio="0.0148700" products="-1 4" 
 <br/>      channel: onMode="1" bRatio="0.0000080" products="-1 6" 
 <br/>      channel: onMode="1" bRatio="0.0148700" products="-3 2" 
 <br/>      channel: onMode="1" bRatio="0.2890610" products="-3 4" 
 <br/>      channel: onMode="1" bRatio="0.0004920" products="-3 6" 
 <br/>      channel: onMode="1" bRatio="0.0000090" products="-5 2" 
 <br/>      channel: onMode="1" bRatio="0.0005360" products="-5 4" 
 <br/>      channel: onMode="1" bRatio="0.2791100" products="-5 6" 
 <br/>      channel: onMode="1" bRatio="0.0371510" products="-11 9900012" 
 <br/>      channel: onMode="1" bRatio="0.0371510" products="-13 9900014" 
 <br/>      channel: onMode="1" bRatio="0.0371500" products="-15 9900016" 
 
<p/>particle: id="9900041" name="H_L++" antiName="H_L--" spinType="1" chargeType="6" colType="0" 
          m0="200.00000" mWidth="0.88159" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0902660" products="-11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0018050" products="-11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0018050" products="-11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0902660" products="-13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0018050" products="-13 -15" 
 <br/>      channel: onMode="1" bRatio="0.8122630" products="-15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0017900" products="24 24" 
 
<p/>particle: id="9900042" name="H_R++" antiName="H_R--" spinType="1" chargeType="6" colType="0" 
          m0="200.00000" mWidth="0.88001" mMin="50.00000" mMax="0.00000" 
 <br/>      channel: onMode="1" bRatio="0.0904280" products="-11 -11" 
 <br/>      channel: onMode="1" bRatio="0.0018090" products="-11 -13" 
 <br/>      channel: onMode="1" bRatio="0.0018080" products="-11 -15" 
 <br/>      channel: onMode="1" bRatio="0.0904280" products="-13 -13" 
 <br/>      channel: onMode="1" bRatio="0.0018080" products="-13 -15" 
 <br/>      channel: onMode="1" bRatio="0.8137200" products="-15 -15" 
 <br/>      channel: onMode="1" bRatio="0.0000000" products="9900024 9900024" 
 
<p/>particle: id="9900110" name="rho_diff0" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="9900210" name="pi_diffr+" antiName="pi_diffr-" spinType="0" chargeType="3" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="9900220" name="omega_di" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="9900330" name="phi_diff" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="9900440" name="J/psi_di" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="9902110" name="n_diffr0" antiName="n_diffrbar0" spinType="0" chargeType="0" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="9902210" name="p_diffr+" antiName="p_diffrbar-" spinType="0" chargeType="3" colType="0" 
          m0="0.00000" 
 
<p/>particle: id="9940003" name="J/psi[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="3.29692" mWidth="0.0" mMin="3.29692" mMax="3.29692" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="443 21" 
 
<p/>particle: id="9940005" name="chi_2c[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="3.7562" mWidth="0.0" mMin="3.7562" mMax="3.7562" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="445 21" 
 
<p/>particle: id="9940011" name="chi_0c[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="3.61475" mWidth="0.0" mMin="3.61475" mMax="3.61475" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="10441 21" 
 
<p/>particle: id="9940023" name="chi_1c[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="3.71066" mWidth="0.0" mMin="3.71066" mMax="3.71066" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="20443 21" 
 
<p/>particle: id="9940103" name="psi(2S)[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="3.88611" mWidth="0.0" mMin="3.88611" mMax="3.88611" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="100443 21" 
 
<p/>particle: id="9941003" name="J/psi[1S0(8)]" spinType="1" chargeType="0" colType="2" 
          m0="3.29692" mWidth="0.0" mMin="3.29692" mMax="3.29692" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="443 21" 
 
<p/>particle: id="9941103" name="psi(2S)[1S0(8)]" spinType="1" chargeType="0" colType="2" 
          m0="3.88611" mWidth="0.0" mMin="3.88611" mMax="3.88611" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="100443 21" 
 
<p/>particle: id="9942003" name="J/psi[3PJ(8)]" spinType="3" chargeType="0" colType="2" 
          m0="3.29692" mWidth="0.0" mMin="3.29692" mMax="3.29692" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="443 21" 
 
<p/>particle: id="9942033" name="psi(3770)[3PJ(8)]" spinType="3" chargeType="0" colType="2" 
          m0="3.97315" mWidth="0.0" mMin="3.97315" mMax="3.97315" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="30443 21" 
 
<p/>particle: id="9942103" name="psi(2S)[3PJ(8)]" spinType="3" chargeType="0" colType="2" 
          m0="3.88611" mWidth="0.0" mMin="3.88611" mMax="3.88611" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="100443 21" 
 
<p/>particle: id="9950003" name="Upsilon[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="9.6603" mWidth="0.0" mMin="9.6603" mMax="9.6603" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="553 21" 
 
<p/>particle: id="9950005" name="chi_2b[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="10.1122" mWidth="0.0" mMin="10.1122" mMax="10.1122" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="555 21" 
 
<p/>particle: id="9950011" name="chi_0b[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="10.0594" mWidth="0.0" mMin="10.0594" mMax="10.0594" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="10551 21" 
 
<p/>particle: id="9950023" name="chi_1b[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="10.09280" mWidth="0.0" mMin="10.09280" mMax="10.09280" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="20553 21" 
 
<p/>particle: id="9950103" name="Upsilon(2S)[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="10.22326" mWidth="0.0" mMin="10.22326" mMax="10.22326" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="100553 21" 
 
<p/>particle: id="9950203" name="Upsilon(3S)[3S1(8)]" spinType="3" chargeType="0" colType="2" 
          m0="10.5552" mWidth="0.0" mMin="10.5552" mMax="10.5552" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="200553 21" 
 
<p/>particle: id="9951003" name="Upsilon[1S0(8)]" spinType="1" chargeType="0" colType="2" 
          m0="9.6603" mWidth="0.0" mMin="9.6603" mMax="9.6603" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="553 21" 
 
<p/>particle: id="9951103" name="Upsilon(2S)[1S0(8)]" spinType="1" chargeType="0" colType="2" 
          m0="10.22326" mWidth="0.0" mMin="10.22326" mMax="10.22326" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="100553 21" 
 
<p/>particle: id="9951203" name="Upsilon(3S)[1S0(8)]" spinType="1" chargeType="0" colType="2" 
          m0="10.5552" mWidth="0.0" mMin="10.5552" mMax="10.5552" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="200553 21" 
 
<p/>particle: id="9952003" name="Upsilon[3PJ(8)]" spinType="3" chargeType="0" colType="2" 
          m0="9.6603" mWidth="0.0" mMin="9.6603" mMax="9.6603" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="553 21" 
 
<p/>particle: id="9952103" name="Upsilon(2S)[3PJ(8)]" spinType="3" chargeType="0" colType="2" 
          m0="10.22326" mWidth="0.0" mMin="10.22326" mMax="10.22326" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="100553 21" 
 
<p/>particle: id="9952203" name="Upsilon(3S)[3PJ(8)]" spinType="3" chargeType="0" colType="2" 
          m0="10.5552" mWidth="0.0" mMin="10.5552" mMax="10.5552" 
 <br/>      channel: onMode="1" bRatio="1.0000000" products="200553 21" 
 
<input type="hidden" name="saved" value="1"/>

<?php
echo "<input type='hidden' name='filepath' value='".$_GET["filepath"]."'/>"?>

<table width="100%"><tr><td align="right"><input type="submit" value="Save Settings" /></td></tr></table>
</form>

<?php

if($_POST["saved"] == 1)
{
$filepath = $_POST["filepath"];
$handle = fopen($filepath, 'a');

if($_POST["1"] != "4")
{
$data = "ParticleData:modeBreitWigner = ".$_POST["1"]."\n";
fwrite($handle,$data);
}
if($_POST["2"] != "2.5")
{
$data = "ParticleData:maxEnhanceBW = ".$_POST["2"]."\n";
fwrite($handle,$data);
}
if($_POST["3"] != "0.006")
{
$data = "ParticleData:mdRun = ".$_POST["3"]."\n";
fwrite($handle,$data);
}
if($_POST["4"] != "0.003")
{
$data = "ParticleData:muRun = ".$_POST["4"]."\n";
fwrite($handle,$data);
}
if($_POST["5"] != "0.095")
{
$data = "ParticleData:msRun = ".$_POST["5"]."\n";
fwrite($handle,$data);
}
if($_POST["6"] != "1.25")
{
$data = "ParticleData:mcRun = ".$_POST["6"]."\n";
fwrite($handle,$data);
}
if($_POST["7"] != "4.20")
{
$data = "ParticleData:mbRun = ".$_POST["7"]."\n";
fwrite($handle,$data);
}
if($_POST["8"] != "165.0")
{
$data = "ParticleData:mtRun = ".$_POST["8"]."\n";
fwrite($handle,$data);
}
if($_POST["9"] != "0.125")
{
$data = "ParticleData:alphaSvalueMRun = ".$_POST["9"]."\n";
fwrite($handle,$data);
}
fclose($handle);
}

?>
</body>
</html>
 
<!-- Copyright (C) 2017 Torbjorn Sjostrand --> 
